/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt;

import java.text.MessageFormat;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class SimpleControlSWTRenderer
extends AbstractControlSWTRenderer<VControl> {
    private static final String ICONS_UNSET_REFERENCE = "icons/unset_reference.png";
    private static final String ICONS_UNSET_FEATURE = "icons/unset_feature.png";
    private static final String ICONS_SET_REFERENCE = "icons/set_reference.png";
    private static final String ICONS_SET_FEATURE = "icons/set_feature.png";
    private SWTGridDescription rendererGridDescription;
    private UnsetModelChangeListener unsetModelChangeListener;

    public SimpleControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            int columns;
            switch (((VControl)this.getVElement()).getLabelAlignment()) {
                case DEFAULT: 
                case LEFT: {
                    columns = 3;
                    break;
                }
                case NONE: {
                    columns = 2;
                    break;
                }
                default: {
                    this.getReportService().report(new AbstractReport(MessageFormat.format("Label alignment {0} is not supported by renderer {1}. Label alignment set to default.", ((VControl)this.getVElement()).getLabelAlignment().getLiteral(), ((Object)((Object)this)).getClass().getName()), 1));
                    ((VControl)this.getVElement()).setLabelAlignment(LabelAlignment.DEFAULT);
                    columns = 3;
                }
            }
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, columns, (AbstractSWTRenderer)this);
            int i = 0;
            while (i < this.rendererGridDescription.getGrid().size() - 1) {
                SWTGridCell swtGridCell = (SWTGridCell)this.rendererGridDescription.getGrid().get(i);
                swtGridCell.setHorizontalGrab(false);
                ++i;
            }
        }
        return this.rendererGridDescription;
    }

    protected final Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        int controlIndex = gridCell.getColumn();
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE) {
            ++controlIndex;
        }
        switch (controlIndex) {
            case 0: {
                return this.createLabel(parent);
            }
            case 1: {
                return this.createValidationIcon(parent);
            }
            case 2: {
                try {
                    if (this.isUnsettable()) {
                        return this.createUnsettableControl(parent);
                    }
                    return this.createControl(parent);
                }
                catch (DatabindingFailedException ex) {
                    this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                    Label errorLabel = new Label(parent, 0);
                    errorLabel.setText(ex.getMessage());
                    return errorLabel;
                }
            }
        }
        throw new IllegalArgumentException(String.format("The provided SWTGridCell (%1$s) cannot be used by this (%2$s) renderer.", gridCell.toString(), ((Object)((Object)this)).toString()));
    }

    protected boolean isUnsettable() throws DatabindingFailedException {
        IValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        EStructuralFeature feature = (EStructuralFeature)valueProperty.getValueType();
        return feature.isUnsettable();
    }

    private Control createUnsettableControl(Composite parent) throws DatabindingFailedException {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        Composite controlComposite = new Composite(composite, 0);
        controlComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)controlComposite);
        StackLayout sl = new StackLayout();
        controlComposite.setLayout((Layout)sl);
        Control baseControl = this.createControl(controlComposite);
        Control createUnsetLabel = this.createUnsetLabel(controlComposite);
        Button unsetButton = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)unsetButton);
        unsetButton.addSelectionListener((SelectionListener)new UnsetSelectionAdapter(sl, unsetButton, createUnsetLabel, baseControl, controlComposite));
        EStructuralFeature structuralFeature = (EStructuralFeature)this.getModelValue().getValueType();
        EObject eObject = (EObject)((IObserving)this.getModelValue()).getObserved();
        if (eObject.eIsSet(structuralFeature)) {
            sl.topControl = baseControl;
            unsetButton.setImage(Activator.getImage(ICONS_UNSET_FEATURE));
        } else {
            sl.topControl = createUnsetLabel;
            unsetButton.setImage(Activator.getImage(ICONS_SET_FEATURE));
        }
        this.unsetModelChangeListener = new UnsetModelChangeListener(eObject, unsetButton, structuralFeature, createUnsetLabel, controlComposite, sl, baseControl);
        this.getViewModelContext().registerDomainChangeListener((ModelChangeListener)this.unsetModelChangeListener);
        return composite;
    }

    private Control createUnsetLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(composite);
        Label unsetLabel = new Label(composite, 0);
        unsetLabel.setBackground(parent.getBackground());
        unsetLabel.setText(this.getUnsetText());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)unsetLabel);
        return composite;
    }

    protected abstract String getUnsetText();

    protected void setValidationColor(Control control, Color validationColor) {
        control.setBackground(validationColor);
    }

    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        int controlIndex = gridCell.getColumn();
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE) {
            ++controlIndex;
        }
        switch (controlIndex) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                control.setEnabled(enabled);
            }
        }
    }

    protected final void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SimpleControlSWTRenderer.this.getControls().size() == 0 || ((Control)SimpleControlSWTRenderer.this.getControls().values().iterator().next()).isDisposed()) {
                    return;
                }
                SimpleControlSWTRenderer.this.applyInnerValidation();
            }
        });
    }

    private void applyInnerValidation() {
        Control editControl;
        Label validationIcon;
        switch (this.getControls().size()) {
            case 2: {
                validationIcon = (Label)Label.class.cast(this.getControls().get(new SWTGridCell(0, 0, (AbstractSWTRenderer)this)));
                editControl = (Control)this.getControls().get(new SWTGridCell(0, 1, (AbstractSWTRenderer)this));
                break;
            }
            case 3: {
                validationIcon = (Label)Label.class.cast(this.getControls().get(new SWTGridCell(0, 1, (AbstractSWTRenderer)this)));
                editControl = (Control)this.getControls().get(new SWTGridCell(0, 2, (AbstractSWTRenderer)this));
                break;
            }
            default: {
                this.getReportService().report(new AbstractReport("Wrong number of controls!"));
                return;
            }
        }
        if (validationIcon == null || editControl == null) {
            return;
        }
        if (validationIcon.isDisposed()) {
            return;
        }
        int highestSeverity = 0;
        if (((VControl)this.getVElement()).getDiagnostic() != null) {
            highestSeverity = ((VControl)this.getVElement()).getDiagnostic().getHighestSeverity();
        }
        validationIcon.setImage(this.getValidationIcon(highestSeverity));
        this.setValidationColor(editControl, this.getValidationBackgroundColor(highestSeverity));
        if (((VControl)this.getVElement()).getDiagnostic() == null) {
            validationIcon.setToolTipText(null);
        } else {
            validationIcon.setToolTipText(ECPTooltipModifierHelper.modifyString((String)((VControl)this.getVElement()).getDiagnostic().getMessage(), null));
        }
    }

    protected abstract Control createControl(Composite var1) throws DatabindingFailedException;

    @Override
    protected void dispose() {
        this.rendererGridDescription = null;
        if (this.unsetModelChangeListener != null) {
            this.getViewModelContext().unregisterDomainChangeListener((ModelChangeListener)this.unsetModelChangeListener);
            this.unsetModelChangeListener = null;
        }
        super.dispose();
    }

    private static final class UnsetModelChangeListener
    implements ModelChangeListener {
        private final EObject eObject;
        private final Button unsetButton;
        private final EStructuralFeature structuralFeature;
        private final Control createUnsetLabel;
        private final Composite controlComposite;
        private final StackLayout sl;
        private final Control baseControl;

        private UnsetModelChangeListener(EObject eObject, Button unsetButton, EStructuralFeature structuralFeature, Control createUnsetLabel, Composite controlComposite, StackLayout sl, Control baseControl) {
            this.eObject = eObject;
            this.unsetButton = unsetButton;
            this.structuralFeature = structuralFeature;
            this.createUnsetLabel = createUnsetLabel;
            this.controlComposite = controlComposite;
            this.sl = sl;
            this.baseControl = baseControl;
        }

        public void notifyChange(ModelChangeNotification notification) {
            if (this.eObject.eIsSet(this.structuralFeature)) {
                if (this.sl.topControl == this.baseControl) {
                    return;
                }
                this.sl.topControl = this.baseControl;
                this.unsetButton.setImage(Activator.getImage(SimpleControlSWTRenderer.ICONS_UNSET_FEATURE));
                this.controlComposite.layout(true);
            } else {
                if (this.sl.topControl == this.createUnsetLabel) {
                    return;
                }
                this.sl.topControl = this.createUnsetLabel;
                this.unsetButton.setImage(Activator.getImage(SimpleControlSWTRenderer.ICONS_SET_FEATURE));
                this.controlComposite.layout(true);
            }
        }
    }

    private final class UnsetSelectionAdapter
    extends SelectionAdapter {
        private final StackLayout sl;
        private final Button unsetButton;
        private final Control createUnsetLabel;
        private final Control baseControl;
        private final Composite controlComposite;

        private UnsetSelectionAdapter(StackLayout sl, Button unsetButton, Control createUnsetLabel, Control baseControl, Composite controlComposite) {
            this.sl = sl;
            this.unsetButton = unsetButton;
            this.createUnsetLabel = createUnsetLabel;
            this.baseControl = baseControl;
            this.controlComposite = controlComposite;
        }

        public void widgetSelected(SelectionEvent e) {
            IObservableValue observableValue;
            super.widgetSelected(e);
            try {
                observableValue = SimpleControlSWTRenderer.this.getEMFFormsDatabinding().getObservableValue(((VControl)SimpleControlSWTRenderer.this.getVElement()).getDomainModelReference(), SimpleControlSWTRenderer.this.getViewModelContext().getDomainModel());
            }
            catch (DatabindingFailedException ex) {
                SimpleControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                return;
            }
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            EObject eObject = (EObject)((IObserving)observableValue).getObserved();
            observableValue.dispose();
            Object value = null;
            if (!eObject.eIsSet(structuralFeature)) {
                this.sl.topControl = this.baseControl;
                this.unsetButton.setImage(Activator.getImage(SimpleControlSWTRenderer.ICONS_UNSET_FEATURE));
                value = structuralFeature.getDefaultValue();
            } else {
                this.sl.topControl = this.createUnsetLabel;
                this.unsetButton.setImage(Activator.getImage(SimpleControlSWTRenderer.ICONS_SET_FEATURE));
                value = SetCommand.UNSET_VALUE;
            }
            EditingDomain editingDomain = SimpleControlSWTRenderer.this.getEditingDomain(eObject);
            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)structuralFeature, (Object)value));
            this.controlComposite.layout();
        }
    }
}

