/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.edit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.edit.spi.ECPAbstractControl;
import org.eclipse.emf.ecp.edit.spi.ECPControlDescription;
import org.eclipse.emf.ecp.edit.spi.ECPControlFactory;
import org.eclipse.emf.ecp.edit.spi.util.ECPApplicableTester;
import org.eclipse.emf.ecp.edit.spi.util.ECPStaticApplicableTester;
import org.eclipse.emf.ecp.internal.edit.Activator;
import org.eclipse.emf.ecp.internal.edit.EditMessages;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.osgi.framework.Bundle;

@Deprecated
public final class ControlFactoryImpl
implements ECPControlFactory {
    private static final String CONTROL_EXTENSION = "org.eclipse.emf.ecp.edit.controls";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String CONTROL_ID = "id";
    private static final String LABEL_ATTRIBUTE = "showLabel";
    private static final String TEST_DYNAMIC = "dynamicTest";
    private static final String CONTROL_TESTER = "testClass";
    private static final String TEST_STATIC = "staticTest";
    private static final String TESTER_PRIORITY = "priority";
    private static final String TESTER_CLASSTYPE = "supportedClassType";
    private static final String TESTER_EOBJECT = "supportedEObject";
    private static final String TESTER_FEATURE = "supportedFeature";
    private static final String TESTER_SINGLEVALUE = "singleValue";
    private final Set<ECPControlDescription> controlDescriptors = new HashSet<ECPControlDescription>();
    public static final ControlFactoryImpl INSTANCE = new ControlFactoryImpl();

    public ControlFactoryImpl() {
        this.readExtensionPoint();
    }

    private void readExtensionPoint() {
        IConfigurationElement[] controls;
        IConfigurationElement[] iConfigurationElementArray = controls = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTROL_EXTENSION);
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String id = e.getAttribute(CONTROL_ID);
                String clazz = e.getAttribute(CLASS_ATTRIBUTE);
                Class resolvedClass = ControlFactoryImpl.loadClass(e.getContributor().getName(), clazz);
                boolean showLabel = Boolean.parseBoolean(e.getAttribute(LABEL_ATTRIBUTE));
                HashSet<ECPApplicableTester> tester = new HashSet<ECPApplicableTester>();
                IConfigurationElement[] iConfigurationElementArray2 = e.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement testerExtension = iConfigurationElementArray2[n4];
                    if (TEST_DYNAMIC.equals(testerExtension.getName())) {
                        tester.add((ECPApplicableTester)testerExtension.createExecutableExtension(CONTROL_TESTER));
                    } else if (TEST_STATIC.equals(testerExtension.getName())) {
                        boolean singleValue = Boolean.parseBoolean(testerExtension.getAttribute(TESTER_SINGLEVALUE));
                        int priority = Integer.parseInt(testerExtension.getAttribute(TESTER_PRIORITY));
                        String type = testerExtension.getAttribute(TESTER_CLASSTYPE);
                        Class supportedClassType = ControlFactoryImpl.loadClass(testerExtension.getContributor().getName(), type);
                        String eObject = testerExtension.getAttribute(TESTER_EOBJECT);
                        if (eObject == null) {
                            eObject = "org.eclipse.emf.ecore.EObject";
                        }
                        Class supportedEObject = ControlFactoryImpl.loadClass(testerExtension.getContributor().getName(), eObject);
                        String supportedFeature = testerExtension.getAttribute(TESTER_FEATURE);
                        tester.add(new ECPStaticApplicableTester(singleValue, priority, supportedClassType, supportedEObject, supportedFeature));
                    }
                    ++n4;
                }
                ECPControlDescription controlDescription = new ECPControlDescription(id, resolvedClass, showLabel, tester);
                this.controlDescriptors.add(controlDescription);
            }
            catch (ClassNotFoundException e1) {
                Activator.logException(e1);
            }
            catch (CoreException e1) {
                Activator.logException((Exception)((Object)e1));
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + EditMessages.CONTROLFACTROY_CANNOT_BE_LOADED + bundleName + EditMessages.CONTROLFACTORY_CANNOT_BE_RESOLVED);
        }
        return bundle.loadClass(clazz);
    }

    @Override
    public <T> T createControl(Class<T> controlType, VDomainModelReference domainModelReference) {
        ECPControlDescription controlDescription = this.getControlCandidate(controlType, domainModelReference);
        if (controlDescription == null) {
            return null;
        }
        T control = ControlFactoryImpl.getControlInstance(controlDescription);
        return control;
    }

    @Override
    public <T> T createControl(String controlId) {
        ECPControlDescription controlDescription = null;
        for (ECPControlDescription desc : this.controlDescriptors) {
            if (!desc.getId().equals(controlId)) continue;
            controlDescription = desc;
            break;
        }
        if (controlDescription == null) {
            return null;
        }
        T control = ControlFactoryImpl.getControlInstance(controlDescription);
        return control;
    }

    @Override
    public Set<ECPControlDescription> getControlDescriptors() {
        return new HashSet<ECPControlDescription>(this.controlDescriptors);
    }

    private static <T> T getControlInstance(ECPControlDescription controlDescription) {
        try {
            Constructor<? extends ECPAbstractControl> controlConstructor = controlDescription.getControlClass().getConstructor(new Class[0]);
            return (T)controlConstructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            Activator.logException(ex);
        }
        catch (InstantiationException ex) {
            Activator.logException(ex);
        }
        catch (IllegalAccessException ex) {
            Activator.logException(ex);
        }
        catch (InvocationTargetException ex) {
            Activator.logException(ex);
        }
        catch (SecurityException ex) {
            Activator.logException(ex);
        }
        catch (NoSuchMethodException ex) {
            Activator.logException(ex);
        }
        return null;
    }

    private ECPControlDescription getControlCandidate(Class<?> controlClass, VDomainModelReference domainModelReference) {
        int highestPriority = -1;
        ECPControlDescription bestCandidate = null;
        if (domainModelReference == null) {
            return bestCandidate;
        }
        for (ECPControlDescription description : this.controlDescriptors) {
            if (!controlClass.isAssignableFrom(description.getControlClass())) continue;
            int currentPriority = -1;
            for (ECPApplicableTester tester : description.getTester()) {
                int testerPriority = tester.isApplicable(domainModelReference);
                if (testerPriority <= currentPriority) continue;
                currentPriority = testerPriority;
            }
            if (currentPriority <= highestPriority) continue;
            highestPriority = currentPriority;
            bestCandidate = description;
        }
        return bestCandidate;
    }
}

