/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="moveFeature", label="Move Feature along Reference", description="In the metamodel, a feature is moved along a single-valued reference. In the model, values are moved accordingly.")
public class MoveFeature
extends OperationImplementation {
    @EdaptParameter(main=true, description="The feature to be moved")
    public EStructuralFeature feature;
    @EdaptParameter(description="The reference along which the feature is moved")
    public EReference reference;

    @EdaptConstraint(restricts="reference", description="The reference must be available in the same class as the feature")
    public boolean checkReferenceInSameClass(EReference reference) {
        EClass sourceClass = this.feature.getEContainingClass();
        return sourceClass.getEAllStructuralFeatures().contains((Object)reference);
    }

    @EdaptConstraint(description="The multiplicity of the reference must be single-valued and obligatory")
    public boolean checkReferenceSingleValued() {
        return this.reference.getLowerBound() == 1 && this.reference.getUpperBound() == 1;
    }

    @EdaptConstraint(description="The multiplicity of its opposite reference must be single-valued")
    public boolean checkReferenceOppositeSingleValued() {
        return this.reference.getEOpposite().getUpperBound() == 1;
    }

    @EdaptConstraint(description="A feature with that name already exists in the target class")
    public boolean checkFeatureNameUniqueInTargetClass() {
        EClass targetClass = this.reference.getEReferenceType();
        return targetClass.getEStructuralFeature(this.feature.getName()) == null;
    }

    public void execute(Metamodel metamodel, Model model) {
        EClass sourceClass = this.feature.getEContainingClass();
        EClass targetClass = this.reference.getEReferenceType();
        targetClass.getEStructuralFeatures().add((Object)this.feature);
        for (Instance instance : model.getAllInstances(sourceClass)) {
            Instance target = (Instance)instance.get((EStructuralFeature)this.reference);
            if (!instance.isSet(this.feature)) continue;
            Object value = instance.unset(this.feature);
            target.set(this.feature, value);
        }
    }
}

