/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.utilities;

import java.util.Arrays;

public enum DatabaseType {
    OTHER(Integer.MAX_VALUE),
    RELATIONAL(100),
    GRAPH(50),
    DOCUMENT(40),
    TIME_SERIES(30),
    COLUMN(20),
    KEY_VALUE(10);

    private int flexibility;

    private DatabaseType(int flexibility) {
        this.flexibility = flexibility;
    }

    public static DatabaseType valueOfIgnoreCase(String value) {
        return Arrays.stream(DatabaseType.values()).filter(type -> type.name().equalsIgnoreCase(value)).findAny().orElse(OTHER);
    }

    public boolean isKeywordSupportAtOrBelow(DatabaseType benchmark) {
        return this.flexibility <= benchmark.flexibility;
    }
}

