/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.MaterialStatement;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.Utils;

public class ClientStatement
implements Statement,
StatementCallbackInterface {
    private static long fetchedRowBase = 0L;
    private MaterialStatement materialStatement_ = null;
    ClientConnection connection_;
    private Section section_;
    Agent agent_;
    private Statement owner = null;
    ClientResultSet resultSet_;
    long updateCount_ = -1L;
    static final int executeQueryMethod__ = 1;
    static final int executeUpdateMethod__ = 2;
    static final int executeMethod__ = 3;
    protected int sqlMode_ = 0;
    static final int isQuery__ = 1;
    static final int isCall__ = 2;
    static final int isUpdate__ = 4;
    int sqlUpdateMode_ = 0;
    static final int isInsertSql__ = 32;
    static final int isDeleteSql__ = 64;
    static final int isUpdateSql__ = 128;
    ColumnMetaData resultSetMetaData_;
    public Cursor cachedCursor_ = null;
    public Cursor cachedSingletonRowData_ = null;
    boolean isPreparedStatement_ = false;
    String cursorName_ = null;
    boolean openOnClient_ = true;
    private int indexOfCurrentResultSet_ = -1;
    ClientResultSet[] resultSetList_ = null;
    protected static final String TIMEOUT_STATEMENT = "SET STATEMENT_TIMEOUT ";
    protected ArrayList<String> timeoutArrayList = new ArrayList(1);
    protected boolean doWriteTimeout = false;
    int timeout_ = 0;
    long maxRows_ = 0L;
    int maxFieldSize_ = 0;
    boolean isAutoCommittableStatement_ = true;
    boolean isCatalogQuery_ = false;
    final ArrayList<Object> batch_ = new ArrayList();
    public int resultSetType_ = 1003;
    public int resultSetConcurrency_ = 1007;
    int resultSetHoldability_;
    int fetchSize_ = 0;
    int fetchDirection_ = 1000;
    Cursor singletonRowData_ = null;
    public String cursorAttributesToSendOnPrepare_ = null;
    ClientPreparedStatement preparedStatementForAutoGeneratedKeys_;
    ClientResultSet generatedKeysResultSet_;
    String[] generatedKeysColumnNames_;
    int[] generatedKeysColumnIndexes_;
    int autoGeneratedKeys_ = 2;
    private SqlWarning warnings_ = null;
    protected boolean isPoolable = false;
    private boolean closeOnCompletion_ = false;
    private boolean closingResultSets_ = false;
    private Section setSpecialRegisterSection_ = null;
    private static final int OUTSIDE = 0;
    private static final int INSIDE_SIMPLECOMMENT = 1;
    private static final int INSIDE_BRACKETED_COMMENT = 2;

    public static void setFetchedRowBase(long l) {
    }

    public MaterialStatement getMaterialStatement() {
        return this.materialStatement_;
    }

    public void setMaterialStatement(MaterialStatement materialStatement) {
        this.materialStatement_ = materialStatement;
    }

    private ClientStatement() {
        this.initStatement();
    }

    private void resetStatement() {
        this.initStatement();
    }

    private void initStatement() {
        this.materialStatement_ = null;
        this.connection_ = null;
        this.agent_ = null;
        this.resultSetType_ = 1003;
        this.resultSetConcurrency_ = 1007;
        this.resultSetHoldability_ = 0;
        this.cursorAttributesToSendOnPrepare_ = null;
        if (this.timeoutArrayList.size() == 0) {
            this.timeoutArrayList.add(null);
        }
        this.initResetStatement();
    }

    private void initResetStatement() {
        this.initResetPreparedStatement();
        if (this.section_ != null) {
            this.section_.free();
        }
        if (this.setSpecialRegisterSection_ != null) {
            this.setSpecialRegisterSection_.free();
            this.setSpecialRegisterSection_ = null;
        }
        this.sqlMode_ = 0;
        this.sqlUpdateMode_ = 0;
        this.resultSetMetaData_ = null;
    }

    protected void initResetPreparedStatement() {
        this.warnings_ = null;
        this.resultSet_ = null;
        this.updateCount_ = -1L;
        this.openOnClient_ = true;
        this.indexOfCurrentResultSet_ = -1;
        this.resultSetList_ = null;
        this.isCatalogQuery_ = false;
        this.isAutoCommittableStatement_ = true;
        this.batch_.clear();
        this.singletonRowData_ = null;
        this.preparedStatementForAutoGeneratedKeys_ = null;
        this.generatedKeysResultSet_ = null;
        this.generatedKeysColumnNames_ = null;
        this.generatedKeysColumnIndexes_ = null;
        this.autoGeneratedKeys_ = 2;
        this.resetUserControllableAttributes();
    }

    private void resetUserControllableAttributes() {
        this.cursorName_ = null;
        this.timeout_ = 0;
        this.doWriteTimeout = false;
        this.maxRows_ = 0L;
        this.maxFieldSize_ = 0;
        this.fetchSize_ = 0;
        this.fetchDirection_ = 1000;
        this.isPoolable = this.isPreparedStatement_;
    }

    public void reset(boolean bl) throws SqlException {
        if (bl) {
            this.connection_.resetStatement(this);
        } else {
            this.initResetStatement();
            this.materialStatement_.reset_();
        }
    }

    void resetForReuse() throws SqlException {
        this.batch_.clear();
        this.clearWarningsX();
        int n = 0;
        if (this.resultSetList_ != null) {
            n = this.resultSetList_.length;
        }
        try {
            if (this.willTickleServer(n, this.connection_.autoCommit_)) {
                this.flowClose();
            } else {
                this.flowCloseOutsideUOW();
            }
        }
        finally {
            this.markResultSetsClosed(false);
            this.removeClientCursorNameFromCache();
            this.markPreparedStatementForAutoGeneratedKeysClosed();
            if (this.setSpecialRegisterSection_ != null) {
                this.setSpecialRegisterSection_.free();
                this.setSpecialRegisterSection_ = null;
            }
            this.resetUserControllableAttributes();
        }
    }

    public ClientStatement(Agent agent, ClientConnection clientConnection) throws SqlException {
        this();
        this.initStatement(agent, clientConnection);
    }

    void resetStatement(Agent agent, ClientConnection clientConnection) throws SqlException {
        this.resetStatement();
        this.initStatement(agent, clientConnection);
    }

    private void initStatement(Agent agent, ClientConnection clientConnection) {
        this.agent_ = agent;
        this.connection_ = clientConnection;
    }

    public ClientStatement(Agent agent, ClientConnection clientConnection, int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        this(agent, clientConnection);
        this.initStatement(n, n2, n3, n4, stringArray, nArray);
    }

    public void resetStatement(Agent agent, ClientConnection clientConnection, int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        this.resetStatement(agent, clientConnection);
        this.initStatement(n, n2, n3, n4, stringArray, nArray);
    }

    private void initStatement(int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                this.resultSetType_ = n;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), n, "type", "createStatement()");
            }
        }
        switch (n2) {
            case 1007: 
            case 1008: {
                this.resultSetConcurrency_ = n2;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), n2, "concurrency", "createStatement()");
            }
        }
        switch (n3) {
            case 1: 
            case 2: {
                this.resultSetHoldability_ = n3;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), n3, "holdability", "createStatement()");
            }
        }
        switch (n4) {
            case 1: 
            case 2: {
                this.autoGeneratedKeys_ = n4;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), n4, "autoGeneratedKeys", "createStatement");
            }
        }
        this.generatedKeysColumnNames_ = stringArray;
        this.generatedKeysColumnIndexes_ = nArray;
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize", new Object[0]);
        }
        if (this.openOnClient_) {
            this.markClosed();
        }
        super.finalize();
    }

    protected SqlWarning getSqlWarnings() {
        return this.warnings_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeQuery", string);
                }
                ClientResultSet clientResultSet = this.executeQueryX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeQuery", clientResultSet);
                }
                return clientResultSet;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private ClientResultSet executeQueryX(String string) throws SqlException {
        this.flowExecute(1, string);
        return this.resultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeUpdate", string);
                }
                int n = (int)this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n);
                }
                return n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeLargeUpdate", string);
                }
                long l = this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeLargeUpdate", l);
                }
                return l;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private long executeUpdateX(String string) throws SqlException {
        this.flowExecute(2, string);
        return this.updateCount_;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            this.checkForClosedStatement();
            try {
                return clazz.cast(this);
            }
            catch (ClassCastException classCastException) {
                throw new SqlException(null, new ClientMessageId("XJ128.S"), clazz);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "isClosed", !this.openOnClient_);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", !this.openOnClient_);
        }
        return !this.openOnClient_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "close", new Object[0]);
                }
                this.closeX();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void closeX() throws SqlException {
        if (!this.openOnClient_) {
            return;
        }
        int n = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        boolean bl = this.willTickleServer(n, true);
        try {
            if (bl) {
                this.flowClose();
            } else {
                this.flowCloseOutsideUOW();
            }
        }
        finally {
            this.markClosed(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPoolable() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "isPoolable", new Object[0]);
                }
                this.checkForClosedStatement();
                return this.isPoolable;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolable(boolean bl) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setPoolable", bl);
                }
                this.checkForClosedStatement();
                this.isPoolable = bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getMaxFieldSize", new Object[0]);
            }
            this.checkForClosedStatement();
            return this.maxFieldSize_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setMaxFieldSize", n);
                }
                this.checkForClosedStatement();
                if (n < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ066.S"), n);
                }
                this.maxFieldSize_ = n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getMaxRows", this.maxRows_);
        }
        return (int)this.getLargeMaxRows();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getLargeMaxRows", this.maxRows_);
            }
            return this.maxRows_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxRows(int n) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setMaxRows", n);
            }
            this.setLargeMaxRows(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLargeMaxRows(long l) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setLargeMaxRows", l);
                }
                this.checkForClosedStatement();
                if (l < 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ063.S"), l);
                }
                this.maxRows_ = l;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setEscapeProcessing", bl);
                }
                this.checkForClosedStatement();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getQueryTimeout", this.timeout_);
            }
            return this.timeout_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryTimeout(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setQueryTimeout", n);
                }
                this.checkForClosedStatement();
                if (n < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ074.S"), n);
                }
                if (n != this.timeout_) {
                    this.timeout_ = n;
                    this.doWriteTimeout = true;
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "cancel", new Object[0]);
            }
            this.checkForClosedStatement();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.4"), new Object[0]);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return this.warnings_ == null ? null : this.warnings_.getSQLWarning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings", new Object[0]);
            }
            try {
                this.checkForClosedStatement();
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
            this.clearWarningsX();
        }
    }

    final void clearWarningsX() {
        this.warnings_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String string) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setCursorName", string);
                }
                this.checkForClosedStatement();
                if (string == null || string.equals("")) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ202.S"), string);
                }
                if (this.resultSet_ != null && this.resultSet_.openOnClient_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X95.S"), "setCursorName()", "Statement");
                }
                this.cursorName_ = string;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "execute", string);
                }
                boolean bl = this.executeX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    boolean executeX(String string) throws SqlException {
        this.flowExecute(3, string);
        return this.resultSet_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getResultSet", new Object[0]);
                }
                this.checkForClosedStatement();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getResultSet", this.resultSet_);
                }
                return this.resultSet_;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getUpdateCount", new Object[0]);
                }
                this.checkForClosedStatement();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getUpdateCount", this.updateCount_);
                }
                return (int)this.updateCount_;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getUpdateCount", new Object[0]);
                }
                this.checkForClosedStatement();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getUpdateCount", this.updateCount_);
                }
                return this.updateCount_;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getMoreResults", new Object[0]);
                }
                boolean bl = this.getMoreResultsX(3);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getMoreResults", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setFetchDirection", n);
                }
                this.checkForClosedStatement();
                switch (n) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this.fetchDirection_ = n;
                        break;
                    }
                    default: {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ064.S"), n);
                    }
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchDirection", this.fetchDirection_);
            }
            return this.fetchDirection_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setFetchSize", n);
                }
                this.checkForClosedStatement();
                if (n < 0 || this.maxRows_ != 0L && (long)n > this.maxRows_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ065.S"), n).getSQLException();
                }
                this.fetchSize_ = n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchSize", this.fetchSize_);
            }
            return this.fetchSize_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getResultSetConcurrency", this.resultSetConcurrency_);
            }
            return this.resultSetConcurrency_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getResultSetType", this.resultSetType_);
            }
            return this.resultSetType_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String string) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "addBatch", string);
                }
                this.checkForClosedStatement();
                string = this.connection_.nativeSQLX(string);
                this.batch_.add(string);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "clearBatch", new Object[0]);
                }
                this.checkForClosedStatement();
                this.batch_.clear();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeBatch", new Object[0]);
                }
                long[] lArray = this.executeBatchX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeBatch", lArray);
                }
                return Utils.squashLongs(lArray);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeLargeBatch", new Object[0]);
                }
                long[] lArray = this.executeBatchX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeLargeBatch", lArray);
                }
                return lArray;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private long[] executeBatchX() throws SqlException, BatchUpdateException {
        this.checkForClosedStatement();
        this.clearWarningsX();
        this.resultSetList_ = null;
        long[] lArray = new long[this.batch_.size()];
        Arrays.fill(lArray, -3L);
        this.flowExecuteBatch(lArray);
        return lArray;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getConnection", this.connection_);
            }
            return this.connection_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getMoreResults", n);
                }
                boolean bl = this.getMoreResultsX(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getMoreResults", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean getMoreResultsX(int n) throws SqlException {
        boolean bl;
        this.checkForClosedStatement();
        this.updateCount_ = -1L;
        if (this.resultSetList_ == null) {
            if (this.resultSet_ != null) {
                if (n != 2) {
                    this.resultSet_.closeX();
                }
                this.resultSet_ = null;
            }
            bl = false;
        } else {
            if (n == 1 && this.resultSetList_[this.indexOfCurrentResultSet_] != null) {
                this.resultSetList_[this.indexOfCurrentResultSet_].closeX();
            }
            boolean bl2 = bl = this.indexOfCurrentResultSet_ + 1 < this.resultSetList_.length;
        }
        if (n == 3) {
            int n2 = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
            boolean bl3 = this.willTickleServer(n2, false);
            if (bl3) {
                this.flowCloseRetrievedResultSets();
            } else {
                this.flowCloseRetrievedResultSetsOutsideUOW();
            }
        }
        this.resultSet_ = bl ? this.resultSetList_[++this.indexOfCurrentResultSet_] : null;
        return bl;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getGeneratedKeys", new Object[0]);
            }
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getGeneratedKeys", this.generatedKeysResultSet_);
            }
            return this.generatedKeysResultSet_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeUpdate", string, n);
                }
                this.autoGeneratedKeys_ = n;
                int n2 = (int)this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n2);
                }
                return n2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeLargeUpdate", string, n);
                }
                this.autoGeneratedKeys_ = n;
                long l = this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeLargeUpdate", l);
                }
                return l;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeUpdate", string, nArray);
                }
                if (nArray != null && nArray.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnIndexes_ = (int[])nArray.clone();
                } else {
                    this.generatedKeysColumnIndexes_ = null;
                }
                int n = (int)this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n);
                }
                return n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeLargeUpdate", string, nArray);
                }
                if (nArray != null && nArray.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnIndexes_ = (int[])nArray.clone();
                } else {
                    this.generatedKeysColumnIndexes_ = null;
                }
                long l = this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeLargeUpdate", l);
                }
                return l;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeUpdate", string, stringArray);
                }
                if (stringArray != null && stringArray.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnNames_ = (String[])stringArray.clone();
                } else {
                    this.generatedKeysColumnNames_ = null;
                }
                int n = (int)this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n);
                }
                return n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeLargeUpdate", string, stringArray);
                }
                if (stringArray != null && stringArray.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnNames_ = (String[])stringArray.clone();
                } else {
                    this.generatedKeysColumnIndexes_ = null;
                }
                long l = this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeLargeUpdate", l);
                }
                return l;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "execute", string, n);
                }
                this.autoGeneratedKeys_ = n;
                boolean bl = this.executeX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "execute", string, nArray);
                }
                if (nArray != null && nArray.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnIndexes_ = (int[])nArray.clone();
                } else {
                    this.generatedKeysColumnIndexes_ = null;
                }
                boolean bl = this.executeX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "execute", string, stringArray);
                }
                if (stringArray != null && stringArray.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnNames_ = (String[])stringArray.clone();
                } else {
                    this.generatedKeysColumnNames_ = null;
                }
                boolean bl = this.executeX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getResultSetHoldability", new Object[0]);
            }
            this.checkForClosedStatement();
            return this.resultSetHoldability_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void writeSetSpecialRegister(ArrayList arrayList) throws SqlException {
        if (this.setSpecialRegisterSection_ == null) {
            this.setSpecialRegisterSection_ = this.agent_.sectionManager_.getDynamicSection(1);
        }
        this.materialStatement_.writeSetSpecialRegister_(this.setSpecialRegisterSection_, arrayList);
    }

    void readSetSpecialRegister() throws SqlException {
        this.materialStatement_.readSetSpecialRegister_();
    }

    private void writeExecuteImmediate(String string, Section section) throws SqlException {
        this.materialStatement_.writeExecuteImmediate_(string, section);
    }

    private void readExecuteImmediate() throws SqlException {
        this.materialStatement_.readExecuteImmediate_();
    }

    @Override
    public void completeExecuteImmediate(Sqlca sqlca) {
        int n = this.completeSqlca(sqlca);
        if (n < 0) {
            return;
        }
        if (sqlca != null) {
            this.updateCount_ = sqlca.getUpdateCount();
        }
    }

    private void readExecuteImmediateForBatch(String string) throws SqlException {
        this.materialStatement_.readExecuteImmediateForBatch_(string);
    }

    void writePrepareDescribeOutput(String string, Section section) throws SqlException {
        this.materialStatement_.writePrepareDescribeOutput_(string, section);
    }

    void readPrepareDescribeOutput() throws SqlException {
        this.materialStatement_.readPrepareDescribeOutput_();
    }

    @Override
    public void completePrepareDescribeOutput(ColumnMetaData columnMetaData, Sqlca sqlca) {
        this.completePrepare(sqlca);
        this.resultSetMetaData_ = columnMetaData;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceResultSetMetaData(this, this.resultSetMetaData_);
        }
    }

    void writePrepare(String string, Section section) throws SqlException {
        this.materialStatement_.writePrepare_(string, section);
    }

    void readPrepare() throws SqlException {
        this.materialStatement_.readPrepare_();
    }

    @Override
    public void completePrepare(Sqlca sqlca) {
        int n = this.completeSqlca(sqlca);
        if (n < 0) {
            return;
        }
        this.markPrepared();
    }

    void writeOpenQuery(Section section, int n, int n2) throws SqlException {
        this.materialStatement_.writeOpenQuery_(section, n, n2);
    }

    void readOpenQuery() throws SqlException {
        this.materialStatement_.readOpenQuery_();
    }

    @Override
    public void completeOpenQuery(Sqlca sqlca, ClientResultSet clientResultSet) {
        this.completeSqlca(sqlca);
        this.resultSet_ = clientResultSet;
        if (clientResultSet == null) {
            return;
        }
        clientResultSet.resultSetMetaData_ = this.resultSetMetaData_;
        clientResultSet.resultSetMetaData_.resultSetConcurrency_ = clientResultSet.resultSetConcurrency_;
        clientResultSet.createLOBColumnTracker();
        if (this.cachedCursor_ == null && this.isPreparedStatement_) {
            this.cachedCursor_ = this.resultSet_.cursor_;
        }
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            return;
        }
        clientResultSet.cursor_.rowsRead_ = fetchedRowBase;
        if (this.resultSet_.fetchSize_ == 0 && (this.resultSet_.resultSetType_ == 1004 || this.resultSet_.resultSetType_ == 1005)) {
            this.resultSet_.setFetchSize_(64);
        }
    }

    @Override
    public void completeExecuteCallOpenQuery(Sqlca sqlca, ClientResultSet clientResultSet, ColumnMetaData columnMetaData, Section section) {
        clientResultSet.completeSqlca(sqlca);
        clientResultSet.resultSetMetaData_ = columnMetaData;
        clientResultSet.createLOBColumnTracker();
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            return;
        }
        clientResultSet.cursor_.rowsRead_ = fetchedRowBase;
        clientResultSet.generatedSection_ = section;
        if (clientResultSet.fetchSize_ == 0) {
            clientResultSet.fetchSize_ = 64;
        }
    }

    void writeExecuteCall(boolean bl, String string, Section section, int n, boolean bl2, int n2, ColumnMetaData columnMetaData, Object[] objectArray) throws SqlException {
        this.materialStatement_.writeExecuteCall_(bl, string, section, n, bl2, n2, columnMetaData, objectArray);
    }

    void readExecuteCall() throws SqlException {
        this.materialStatement_.readExecuteCall_();
    }

    @Override
    public void completeExecuteCall(Sqlca sqlca, Cursor cursor, ClientResultSet[] clientResultSetArray) {
        this.completeExecuteCall(sqlca, cursor);
        this.resultSetList_ = (ClientResultSet[])clientResultSetArray.clone();
        if (clientResultSetArray != null) {
            this.resultSet_ = clientResultSetArray[0];
        }
        this.indexOfCurrentResultSet_ = 0;
    }

    @Override
    public void completeExecuteCall(Sqlca sqlca, Cursor cursor) {
        this.completeExecute(sqlca);
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            this.singletonRowData_ = null;
        } else {
            this.singletonRowData_ = cursor;
            if (this.cachedSingletonRowData_ == null && this.isPreparedStatement_) {
                this.cachedSingletonRowData_ = this.singletonRowData_;
            }
        }
    }

    @Override
    public void completeExecute(Sqlca sqlca) {
        if (sqlca == null) {
            return;
        }
        int n = sqlca.getSqlCode();
        if (n < 0) {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
        } else {
            this.updateCount_ = sqlca.getUpdateCount();
            if (this.sqlMode_ == 2) {
                this.updateCount_ = -1L;
            }
            if (n > 0 && n != 466 && n != 100) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            }
        }
    }

    public void setUpdateCount(long l) {
        this.updateCount_ = l;
    }

    protected final void setOwner(Statement statement) {
        this.owner = statement;
    }

    final Statement getOwner() {
        return this.owner;
    }

    private boolean willTickleServer(int n, boolean bl) throws SqlException {
        boolean bl2 = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < n; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    return true;
                }
                if (this.resultSetList_[i].autoCommitted_ || !bl) continue;
                bl2 = true;
            }
        } else if (this.generatedKeysResultSet_ != null && this.generatedKeysResultSet_.openOnServer_) {
            this.generatedKeysResultSet_.writeClose();
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                return true;
            }
            if (!this.resultSet_.autoCommitted_ && bl) {
                bl2 = true;
            }
        }
        if (this.connection_.autoCommit_ && bl2) {
            if (this.connection_.isXAConnection_) {
                return this.connection_.getXAState() == 0;
            }
            return true;
        }
        return false;
    }

    private void flowClose() throws SqlException {
        this.agent_.beginWriteChain(this);
        this.writeClose(true);
        this.agent_.flow(this);
        this.readClose(true);
        this.agent_.endReadChain();
    }

    private void flowCloseOutsideUOW() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeClose(true);
        this.agent_.flowOutsideUOW();
        this.readClose(true);
        this.agent_.endReadChain();
    }

    final void writeClose(boolean bl) throws SqlException {
        this.writeCloseResultSets(bl);
    }

    final void readClose(boolean bl) throws SqlException {
        this.readCloseResultSets(bl);
    }

    final boolean writeCloseResultSets(boolean bl) throws SqlException {
        int n = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        return this.writeCloseResultSets(n, bl);
    }

    private boolean writeCloseResultSets(int n, boolean bl) throws SqlException {
        boolean bl2 = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < n; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    this.resultSetList_[i].writeClose();
                }
                if (this.resultSetList_[i].autoCommitted_ || !bl) continue;
                bl2 = true;
            }
        } else if (this.generatedKeysResultSet_ != null && this.generatedKeysResultSet_.openOnServer_) {
            this.generatedKeysResultSet_.writeClose();
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                this.resultSet_.writeClose();
            }
            if (!this.resultSet_.autoCommitted_ && bl) {
                bl2 = true;
            }
        }
        if (this.connection_.autoCommit_ && bl2 && this.isAutoCommittableStatement_) {
            this.connection_.writeAutoCommit();
            if (this.connection_.isXAConnection_) {
                return this.connection_.getXAState() == 0;
            }
            return true;
        }
        return false;
    }

    final void readCloseResultSets(boolean bl) throws SqlException {
        int n = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        this.readCloseResultSets(n, bl);
    }

    private void readCloseResultSets(int n, boolean bl) throws SqlException {
        boolean bl2 = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < n; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    this.resultSetList_[i].readClose();
                } else {
                    this.resultSetList_[i].markClosed();
                }
                if (this.resultSetList_[i].autoCommitted_ || !bl) continue;
                bl2 = true;
            }
        } else if (this.generatedKeysResultSet_ != null) {
            if (this.generatedKeysResultSet_.openOnServer_) {
                this.generatedKeysResultSet_.readClose();
            } else {
                this.generatedKeysResultSet_.markClosed();
            }
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                this.resultSet_.readClose();
            } else {
                this.resultSet_.markClosed();
            }
            if (!this.resultSet_.autoCommitted_ && bl) {
                bl2 = true;
            }
        }
        if (this.connection_.autoCommit_ && bl2 && this.isAutoCommittableStatement_) {
            this.connection_.readAutoCommit();
        }
    }

    private void flowCloseRetrievedResultSets() throws SqlException {
        int n = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
        this.agent_.beginWriteChain(this);
        this.writeCloseResultSets(n, false);
        this.agent_.flow(this);
        this.readCloseResultSets(n, false);
        this.agent_.endReadChain();
    }

    private void flowCloseRetrievedResultSetsOutsideUOW() throws SqlException {
        int n = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
        this.agent_.beginWriteChainOutsideUOW();
        this.writeCloseResultSets(n, false);
        this.agent_.flowOutsideUOW();
        this.readCloseResultSets(n, false);
        this.agent_.endReadChain();
    }

    @Override
    public int completeSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        int n = sqlca.getSqlCode();
        if (n < 0) {
            this.connection_.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
        } else if (n > 0) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
        }
        return n;
    }

    @Override
    public void completeExecuteSetStatement(Sqlca sqlca) {
    }

    void markClosed() {
        this.markClosed(false);
    }

    void markClosed(boolean bl) {
        this.openOnClient_ = false;
        this.markResultSetsClosed(false);
        this.closeEverythingExceptResultSets(bl);
    }

    private void closeEverythingExceptResultSets(boolean bl) {
        this.removeClientCursorNameFromCache();
        this.markPreparedStatementForAutoGeneratedKeysClosed();
        this.setSection(null);
        if (this.resultSetMetaData_ != null) {
            this.resultSetMetaData_.markClosed();
            this.resultSetMetaData_ = null;
        }
        if (bl) {
            this.connection_.openStatements_.remove(this);
        }
        if (this.setSpecialRegisterSection_ != null) {
            this.setSpecialRegisterSection_.free();
            this.setSpecialRegisterSection_ = null;
        }
    }

    private void markPreparedStatementForAutoGeneratedKeysClosed() {
        if (this.preparedStatementForAutoGeneratedKeys_ != null) {
            this.preparedStatementForAutoGeneratedKeys_.markClosed();
        }
    }

    final void markResultSetsClosed(boolean bl) {
        try {
            this.closingResultSets_ = true;
            if (this.resultSetList_ != null) {
                for (int i = 0; i < this.resultSetList_.length; ++i) {
                    if (this.resultSetList_[i] != null) {
                        this.resultSetList_[i].markClosed(bl);
                    }
                    this.resultSetList_[i] = null;
                }
            }
            if (this.generatedKeysResultSet_ != null) {
                this.generatedKeysResultSet_.markClosed(bl);
            }
            if (this.resultSet_ != null) {
                this.resultSet_.markClosed(bl);
            }
            this.resultSet_ = null;
            this.resultSetList_ = null;
            this.generatedKeysResultSet_ = null;
        }
        finally {
            this.closingResultSets_ = false;
        }
    }

    private void flowExecute(int n, String string) throws SqlException {
        this.checkForClosedStatement();
        this.clearWarningsX();
        string = this.escape(string);
        this.sqlMode_ = n == 1 ? 1 : 4;
        this.parseSqlAndSetSqlModes(string);
        this.checkAutoGeneratedKeysParameters();
        this.updateCount_ = this.sqlMode_ == 4 ? 0L : -1L;
        this.checkForAppropriateSqlMode(n, this.sqlMode_);
        if (this.sqlMode_ == 1) {
            this.checkForDuplicateCursorName();
        }
        boolean bl = false;
        this.agent_.beginWriteChain(this);
        boolean bl2 = this.writeCloseResultSets(true);
        ClientResultSet clientResultSet = null;
        Section section = null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.doWriteTimeout && this.timeout_ > 0) {
            this.timeoutArrayList.set(0, TIMEOUT_STATEMENT + this.timeout_);
            this.writeSetSpecialRegister(this.timeoutArrayList);
            bl = true;
        }
        switch (this.sqlMode_) {
            case 1: {
                section = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
                this.writePrepareDescribeOutput(string, section);
                this.writeOpenQuery(section, this.fetchSize_, this.resultSetType_);
                break;
            }
            case 4: {
                String[] stringArray;
                String string2 = null;
                if ((this.sqlUpdateMode_ == 64 || this.sqlUpdateMode_ == 128) && (stringArray = this.extractCursorNameFromWhereCurrentOf(string)) != null) {
                    string2 = stringArray[0];
                    string = stringArray[1];
                }
                if (string2 != null) {
                    section = this.agent_.sectionManager_.getPositionedUpdateSection(string2, true);
                    if (section == null) {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("42X30"), string2);
                    }
                    clientResultSet = this.agent_.sectionManager_.getPositionedUpdateResultSet(string2);
                    if (clientResultSet != null && !clientResultSet.isRowsetCursor_ && !(bl3 = clientResultSet.repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete())) {
                        clientResultSet = null;
                    }
                    if (section.getClientCursorName() != null && string2.compareTo(section.getClientCursorName()) == 0) {
                        string = this.substituteClientCursorNameWithServerCursorName(string, section);
                    }
                    this.writeExecuteImmediate(string, section);
                } else {
                    section = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
                    this.writeExecuteImmediate(string, section);
                    if ((this.sqlUpdateMode_ == 32 || this.sqlUpdateMode_ == 128) && this.autoGeneratedKeys_ == 1) {
                        if (this.preparedStatementForAutoGeneratedKeys_ == null) {
                            this.preparedStatementForAutoGeneratedKeys_ = ClientStatement.prepareAutoGeneratedKeysStatement(this.connection_);
                            bl4 = true;
                        }
                        this.writeOpenQuery(this.preparedStatementForAutoGeneratedKeys_.getSection(), this.preparedStatementForAutoGeneratedKeys_.fetchSize_, this.preparedStatementForAutoGeneratedKeys_.resultSetType_);
                    }
                }
                if (!this.connection_.autoCommit_) break;
                this.connection_.writeAutoCommit();
                break;
            }
            case 2: {
                section = this.writeExecuteCall(string, false);
            }
        }
        this.agent_.flow(this);
        this.readCloseResultSets(true);
        if (bl) {
            this.readSetSpecialRegister();
        }
        if (bl2) {
            this.connection_.completeTransactionStart();
        }
        this.markResultSetsClosed(true);
        this.setSection(section);
        switch (this.sqlMode_) {
            case 1: {
                this.readPrepareDescribeOutput();
                this.readOpenQuery();
                if (this.resultSet_ == null) break;
                this.resultSet_.parseScrollableRowset();
                this.setupCursorNameCacheAndMappings();
                break;
            }
            case 4: {
                if (clientResultSet != null && !clientResultSet.isRowsetCursor_) {
                    clientResultSet.readPositioningFetch_();
                }
                this.readExecuteImmediate();
                if ((this.sqlUpdateMode_ == 32 || this.sqlUpdateMode_ == 128) && this.autoGeneratedKeys_ == 1) {
                    if (bl4) {
                        this.preparedStatementForAutoGeneratedKeys_.materialPreparedStatement_.readPrepareDescribeOutput_();
                    }
                    this.preparedStatementForAutoGeneratedKeys_.readOpenQuery();
                    this.generatedKeysResultSet_ = this.preparedStatementForAutoGeneratedKeys_.resultSet_;
                    this.preparedStatementForAutoGeneratedKeys_.resultSet_ = null;
                    this.generatedKeysResultSet_.outerStatement_ = this;
                }
                if (!this.connection_.autoCommit_) break;
                this.connection_.readAutoCommit();
                break;
            }
            case 2: {
                this.readPrepare();
                this.readExecuteCall();
            }
        }
        this.agent_.endReadChain();
        if (this.resultSet_ != null && this.resultSet_.resultSetHoldability_ != this.resultSetHoldability_ && this.sqlMode_ != 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ204.S"), this.resultSetHoldability_);
        }
        if (this.sqlMode_ == 2) {
            this.parseStorProcReturnedScrollableRowset();
            this.checkForStoredProcResultSetCount(n);
            if (this.connection_.autoCommit_ && this.resultSet_ == null && this.resultSetList_ == null) {
                this.connection_.flowAutoCommit();
            }
        }
        if (n == 2 && this.updateCount_ < 0L) {
            this.updateCount_ = 0L;
        }
    }

    private void flowExecuteBatch(long[] lArray) throws SqlException, BatchUpdateException {
        String string;
        int n;
        SqlException sqlException = null;
        boolean bl = true;
        this.agent_.beginBatchedWriteChain(this);
        for (n = 0; n < this.batch_.size(); ++n) {
            boolean bl2 = true;
            string = (String)this.batch_.get(n);
            this.parseSqlAndSetSqlModes(string);
            try {
                this.checkForInvalidBatchedSql(string);
            }
            catch (SqlException sqlException2) {
                bl2 = false;
            }
            if (!bl2) continue;
            if (this.sqlMode_ != 2) {
                this.setSection(this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_));
                this.writeExecuteImmediate(string, this.getSection());
                continue;
            }
            this.setSection(this.writeExecuteCall(string, true));
        }
        if (this.connection_.autoCommit_) {
            this.connection_.writeAutoCommit();
        }
        this.agent_.flowBatch(this, this.batch_.size());
        try {
            for (n = 0; n < this.batch_.size(); ++n) {
                this.agent_.setBatchedExceptionLabelIndex(n);
                SqlException sqlException3 = null;
                string = (String)this.batch_.get(n);
                this.parseSqlAndSetSqlModes(string);
                try {
                    this.checkForInvalidBatchedSql(string);
                }
                catch (SqlException sqlException4) {
                    sqlException3 = sqlException4;
                }
                if (sqlException3 == null) {
                    this.updateCount_ = -1L;
                    if (this.sqlMode_ != 2) {
                        this.readExecuteImmediateForBatch(string);
                    } else {
                        if (bl) {
                            this.readPrepare();
                        }
                        this.readExecuteCall();
                    }
                } else {
                    this.agent_.accumulateReadException(sqlException3);
                    this.updateCount_ = -3L;
                    sqlException3 = null;
                }
                lArray[n] = this.updateCount_;
                if (lArray[n] != -1L) continue;
                lArray[n] = 0L;
            }
            this.agent_.disableBatchedExceptionTracking();
            if (this.connection_.autoCommit_) {
                this.connection_.readAutoCommit();
            }
        }
        catch (SqlException sqlException5) {
            sqlException = sqlException5;
            sqlException.setNextException(new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ211.S"), new Object[0]));
        }
        this.batch_.clear();
        this.agent_.endBatchedReadChain(lArray, sqlException);
    }

    private Section writeExecuteCall(String string, boolean bl) throws SqlException {
        Section section = null;
        section = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
        this.writePrepare(string, section);
        this.writeExecuteCall(false, null, section, this.fetchSize_, bl, this.resultSetType_, null, null);
        return section;
    }

    @Override
    public void listenToUnitOfWork() {
    }

    @Override
    public void completeLocalCommit(Iterator iterator) {
    }

    @Override
    public void completeLocalRollback(Iterator iterator) {
    }

    @Override
    public void accumulateWarning(SqlWarning sqlWarning) {
        if (this.warnings_ == null) {
            this.warnings_ = sqlWarning;
        } else {
            this.warnings_.setNextWarning(sqlWarning);
        }
    }

    private void markPrepared() {
        this.listenToUnitOfWork();
    }

    protected String getJdbcStatementInterfaceName() {
        return "java.sql.Statement";
    }

    void parseSqlAndSetSqlModes(String string) throws SqlException {
        this.sqlUpdateMode_ = 0;
        String string2 = this.getStatementToken(string);
        if (string2 == null) {
            return;
        }
        if (string2.equalsIgnoreCase("select") || string2.equalsIgnoreCase("values")) {
            this.sqlMode_ = 1;
        } else if (string2.equalsIgnoreCase("call")) {
            this.sqlMode_ = 2;
        } else {
            this.parseUpdateSql(string2);
        }
    }

    private String isolateAnyInitialIdentifier(String string) {
        char c;
        int n;
        for (n = 0; n < string.length() && Character.isLetter(c = string.charAt(n)); ++n) {
        }
        return n > 0 ? string.substring(0, n) : string;
    }

    private String getStatementToken(String string) throws SqlException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = null;
        block17: while (n3 < string.length() && string2 == null) {
            char c = string.charAt(n3);
            switch (n2) {
                case 0: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case '(': 
                        case '=': 
                        case '?': 
                        case '{': {
                            ++n3;
                            continue block17;
                        }
                        case '/': {
                            if (n3 == string.length() - 1) {
                                string2 = "/";
                            } else if (string.charAt(n3 + 1) == '*') {
                                n2 = 2;
                                ++n;
                                ++n3;
                            }
                            ++n3;
                            continue block17;
                        }
                        case '-': {
                            if (n3 == string.length() - 1) {
                                string2 = "-";
                            } else if (string.charAt(n3 + 1) == '-') {
                                n2 = 1;
                                ++n3;
                            }
                            ++n3;
                            continue block17;
                        }
                    }
                    string2 = this.isolateAnyInitialIdentifier(string.substring(n3));
                    continue block17;
                }
                case 1: {
                    switch (c) {
                        case '\n': 
                        case '\f': 
                        case '\r': {
                            n2 = 0;
                            ++n3;
                            continue block17;
                        }
                    }
                    ++n3;
                    continue block17;
                }
                case 2: {
                    switch (c) {
                        case '/': {
                            if (n3 != string.length() - 1 && string.charAt(n3 + 1) == '*') {
                                ++n;
                                ++n3;
                            }
                            ++n3;
                            continue block17;
                        }
                        case '*': {
                            if (n3 != string.length() - 1 && string.charAt(n3 + 1) == '/' && --n == 0) {
                                n2 = 0;
                                ++n3;
                            }
                            ++n3;
                            continue block17;
                        }
                    }
                    ++n3;
                    continue block17;
                }
            }
        }
        return string2;
    }

    private void parseUpdateSql(String string) {
        this.sqlMode_ = 4;
        if (string.equalsIgnoreCase("insert")) {
            this.sqlUpdateMode_ = 32;
        }
        if (string.equalsIgnoreCase("delete")) {
            this.sqlUpdateMode_ = 64;
        }
        if (string.equalsIgnoreCase("update")) {
            this.sqlUpdateMode_ = 128;
        }
    }

    final void checkForAppropriateSqlMode(int n, int n2) throws SqlException {
        if (n == 1 && n2 == 4) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ207.S"), new Object[0]);
        }
        if (n == 2 && n2 == 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0Y79.S"), new Object[0]);
        }
    }

    private void checkResultSetCount(int n) throws SqlException {
        switch (n) {
            case 1: {
                if (this.resultSetList_ != null && this.resultSetList_.length > 1) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0Y78.S.1"), this.getJdbcStatementInterfaceName(), this.getJdbcStatementInterfaceName());
                }
                if (this.resultSet_ != null && this.resultSetList_.length != 0) break;
                ClientMessageId clientMessageId = new ClientMessageId("X0Y78.S.2");
                throw new SqlException(this.agent_.logWriter_, clientMessageId, this.getJdbcStatementInterfaceName(), this.getJdbcStatementInterfaceName());
            }
            case 2: {
                if (this.resultSet_ == null || this.resultSetList_.length <= 0) break;
                ClientMessageId clientMessageId = new ClientMessageId("X0Y79.S");
                throw new SqlException(this.agent_.logWriter_, clientMessageId, new Object[0]);
            }
        }
    }

    protected final void checkForStoredProcResultSetCount(int n) throws SqlException {
        try {
            this.checkResultSetCount(n);
        }
        catch (SqlException sqlException) {
            if (this.connection_.autoCommit_) {
                this.connection_.flowRollback();
            }
            throw sqlException;
        }
    }

    final void checkForClosedStatement() throws SqlException {
        if (this.connection_ == null || this.connection_.isClosed()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003"), new Object[0]);
        }
        if (!this.openOnClient_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ012.S"), "Statement");
        }
        this.agent_.checkForDeferredExceptions();
    }

    private void checkForInvalidBatchedSql(String string) throws SqlException {
        if (string == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ067.S"), new Object[0]);
        }
        if (this.sqlMode_ != 2 && (this.sqlMode_ != 4 || this.sqlUpdateMode_ != 32 && this.sqlUpdateMode_ != 64 && this.sqlUpdateMode_ != 128 && this.sqlUpdateMode_ != 0)) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("42ZA1"), string);
        }
    }

    protected void checkForDuplicateCursorName() throws SqlException {
        if (this.cursorName_ != null && this.connection_.clientCursorNameCache_.containsKey(this.cursorName_)) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ203.S"), this.cursorName_);
        }
    }

    protected void setupCursorNameCacheAndMappings() {
        if (this.cursorName_ != null) {
            this.agent_.sectionManager_.mapCursorNameToQuerySection(this.cursorName_, this.getSection());
            this.getSection().setClientCursorName(this.cursorName_);
            this.connection_.clientCursorNameCache_.put(this.cursorName_, this.cursorName_);
        } else {
            this.agent_.sectionManager_.mapCursorNameToQuerySection(this.getSection().getServerCursorName(), this.getSection());
        }
        this.mapCursorNameToResultSet();
    }

    String[] extractCursorNameFromWhereCurrentOf(String object) {
        int n;
        String string = ((String)object).toLowerCase();
        int n2 = string.lastIndexOf("current");
        if (n2 != -1 && (n = string.lastIndexOf("where")) != -1) {
            String[] stringArray = new String[]{"where", "current", "of"};
            StringTokenizer stringTokenizer = new StringTokenizer(((String)object).substring(n));
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                if (!stringTokenizer.nextToken().equalsIgnoreCase(stringArray[0]) || !stringTokenizer.nextToken().equalsIgnoreCase(stringArray[1]) || !stringTokenizer.nextToken().equalsIgnoreCase(stringArray[2])) continue;
                String string3 = string2 = stringTokenizer.nextToken();
                int n3 = string2.length();
                int n4 = ((String)object).lastIndexOf(string2);
                string2 = string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"' ? string2.substring(1, string2.length() - 1) : string2.toUpperCase();
                object = ((String)object).length() > n4 + n3 ? ((String)object).substring(0, n4) + string2 + ((String)object).substring(n4 + string3.length(), ((String)object).length()) : ((String)object).substring(0, n4) + string2;
                return new String[]{string2, object};
            }
        }
        return null;
    }

    protected String substituteClientCursorNameWithServerCursorName(String string, Section section) throws SqlException {
        String string2 = section.getClientCursorName();
        int n = string.lastIndexOf(string2);
        if (string.length() > n + string2.length()) {
            return string.substring(0, n) + section.getServerCursorNameForPositionedUpdate() + string.substring(n + string2.length(), string.length());
        }
        return string.substring(0, n) + section.getServerCursorNameForPositionedUpdate();
    }

    @Override
    public ConnectionCallbackInterface getConnectionCallbackInterface() {
        return this.connection_;
    }

    void resetCursorNameAndRemoveFromWhereCurrentOfMappings() {
        if (this.section_ != null) {
            this.agent_.sectionManager_.removeCursorNameToResultSetMapping(this.cursorName_, this.getSection().getServerCursorNameForPositionedUpdate());
            this.agent_.sectionManager_.removeCursorNameToResultSetMapping(this.cursorName_, this.getSection().getServerCursorName());
            this.agent_.sectionManager_.removeCursorNameToQuerySectionMapping(this.cursorName_, this.getSection().getServerCursorNameForPositionedUpdate());
        }
    }

    private void mapCursorNameToResultSet() {
        if (this.cursorName_ != null) {
            this.agent_.sectionManager_.mapCursorNameToResultSet(this.cursorName_, this.resultSet_);
        } else {
            this.agent_.sectionManager_.mapCursorNameToResultSet(this.getSection().getServerCursorName(), this.resultSet_);
        }
    }

    void parseStorProcReturnedScrollableRowset() throws SqlException {
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                if (!this.resultSetList_[i].scrollable_ || !this.resultSetList_[i].cursor_.dataBufferHasUnprocessedData()) continue;
                this.resultSetList_[i].parseScrollableRowset();
                if (!this.resultSetList_[i].rowCountIsUnknown()) continue;
                this.resultSetList_[i].getRowCount();
            }
        }
    }

    String escape(String string) throws SqlException {
        String string2 = string;
        string2 = this.connection_.nativeSQLX(string);
        return string2;
    }

    String cacheCursorAttributesToSendOnPrepare() throws SqlException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.resultSetType_ == 1005) {
            stringBuffer.append("SENSITIVE STATIC SCROLL ");
        } else if (this.resultSetType_ == 1004) {
            stringBuffer.append("INSENSITIVE SCROLL ");
        }
        if (this.resultSetConcurrency_ == 1008) {
            stringBuffer.append("FOR UPDATE ");
        }
        if (this.resultSetHoldability_ == 1) {
            stringBuffer.append("WITH HOLD ");
        }
        return stringBuffer == null || stringBuffer.toString().equals("") ? null : stringBuffer.toString();
    }

    protected static ClientPreparedStatement prepareAutoGeneratedKeysStatement(ClientConnection clientConnection) throws SqlException {
        String string = "select IDENTITY_VAL_LOCAL() from SYSIBM.SYSDUMMY1";
        ClientPreparedStatement clientPreparedStatement = clientConnection.newPreparedStatement_(string, 1003, 1007, 1, 2, null, null);
        clientPreparedStatement.cursorAttributesToSendOnPrepare_ = "WITH HOLD ";
        clientPreparedStatement.materialPreparedStatement_.writePrepareDescribeOutput_(clientPreparedStatement.sql_, clientPreparedStatement.getSection());
        return clientPreparedStatement;
    }

    void checkAutoGeneratedKeysParameters() throws SqlException {
        if (this.autoGeneratedKeys_ != 2 && this.autoGeneratedKeys_ != 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), this.autoGeneratedKeys_, "autoGeneratedKeys", "Statement.execute()/executeQuery()");
        }
        if (this.sqlUpdateMode_ == 32) {
            if (this.generatedKeysColumnNames_ != null && this.generatedKeysColumnNames_.length > 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X0D.S"), this.generatedKeysColumnNames_.length);
            }
            if (this.generatedKeysColumnIndexes_ != null && this.generatedKeysColumnIndexes_.length > 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X0D.S"), this.generatedKeysColumnIndexes_.length);
            }
        }
    }

    @Override
    public ColumnMetaData getGuessedResultSetMetaData() {
        return this.resultSetMetaData_;
    }

    public boolean isQueryMode() {
        return this.sqlMode_ == 1;
    }

    protected void removeClientCursorNameFromCache() {
        if (this.cursorName_ != null && this.connection_.clientCursorNameCache_.containsKey(this.cursorName_)) {
            this.connection_.clientCursorNameCache_.remove(this.cursorName_);
        }
    }

    void resultSetCommitting(ClientResultSet clientResultSet) throws SqlException {
        this.resultSetCommitting(clientResultSet, false);
    }

    boolean resultSetCommitting(ClientResultSet clientResultSet, boolean bl) throws SqlException {
        if (!this.connection_.autoCommit_ || clientResultSet.autoCommitted_) {
            return false;
        }
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                ClientResultSet clientResultSet2 = this.resultSetList_[i];
                if (clientResultSet2 == null || !clientResultSet2.openOnClient_ || clientResultSet2 == clientResultSet) continue;
                return false;
            }
        }
        if (bl) {
            this.connection_.writeAutoCommit();
            return true;
        }
        if (this.connection_.flowAutoCommit()) {
            this.markAutoCommitted();
            return true;
        }
        return false;
    }

    private void markAutoCommitted() {
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                if (this.resultSetList_[i] == null) continue;
                this.resultSetList_[i].markAutoCommitted();
            }
        } else if (this.resultSet_ != null) {
            this.resultSet_.markAutoCommitted();
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        this.closeOnCompletion_ = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return this.closeOnCompletion_;
    }

    void closeMeOnCompletion() {
        boolean bl;
        boolean bl2 = bl = this.connection_ != null && !this.connection_.isClosed();
        if (bl && !this.closingResultSets_ && this.closeOnCompletion_) {
            try {
                if (this.isOpen(this.resultSet_)) {
                    return;
                }
                if (this.isOpen(this.generatedKeysResultSet_)) {
                    return;
                }
                if (this.resultSetList_ != null) {
                    int n = this.resultSetList_.length;
                    for (int i = 0; i < n; ++i) {
                        if (!this.isOpen(this.resultSetList_[i])) continue;
                        return;
                    }
                }
                this.openOnClient_ = false;
                this.closeEverythingExceptResultSets(true);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(this.agent_.getLogWriter());
            }
        }
    }

    private boolean isOpen(ClientResultSet clientResultSet) throws SQLException {
        return clientResultSet != null && !clientResultSet.isClosed();
    }

    void resetResultSetList() {
        this.indexOfCurrentResultSet_ = -1;
    }

    public Section getSection() {
        return this.section_;
    }

    protected void setSection(Section section) {
        if (this.section_ != null) {
            this.section_.free();
        }
        this.section_ = section;
    }
}

