/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class IMQIPServiceFactory
extends ServiceFactory {
    public static final String PROTOCOL_PREFIX = "imq.protocol.";
    private BrokerConfig props = Globals.getConfig();
    private int DEFAULT_DESTROY_TIMEOUT = 30;

    protected Map getProtocolParams(String protoname, String prefix) {
        List proto_props = this.getProtocolNames(protoname);
        if (proto_props == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < proto_props.size(); ++i) {
            String name = (String)proto_props.get(i);
            String value = Globals.getConfig().getProperty(prefix + "." + name);
            if (value == null) continue;
            map.put(name, value);
        }
        return map;
    }

    protected List getProtocolNames(String protoname) {
        return Globals.getConfig().getList(PROTOCOL_PREFIX + protoname + ".propertylist");
    }

    @Override
    public void updateService(Service s) throws BrokerException {
        IMQService ss = (IMQService)s;
        String name = s.getName();
        String protoname = "imq." + name + ".protocoltype";
        String protocol = this.props.getProperty(protoname);
        String prefix = "imq." + name + "." + protocol;
        Protocol p = ss.getProtocol();
        Map params = this.getProtocolParams(protocol, prefix);
        p.checkParameters(params);
        try {
            p.setParameters(params);
        }
        catch (IOException ex) {
            Object[] args = new String[]{protocol, p.toString(), name};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4001", args), ex);
        }
        int newmin = this.getThreadMin(name);
        int newmax = this.getThreadMax(name);
        try {
            ss.setMinMaxThreadpool(newmin, newmax);
        }
        catch (IllegalArgumentException e) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4115", String.valueOf(newmin), String.valueOf(newmax)), e);
        }
        Globals.getPortMapper().addService(name, protocol, this.props.getProperty("imq." + name + ".servicetype"), p.getLocalPort(), ss.getServiceProperties());
    }

    @Override
    public void startMonitoringService(Service s) throws BrokerException {
        String name = s.getName();
        String protoname = "imq." + name + ".protocoltype";
        String protocol = this.props.getProperty(protoname);
        List params = this.getProtocolNames(protocol);
        for (int i = 0; params != null && i < params.size(); ++i) {
            String prop = (String)params.get(i);
            this.props.addListener(prop, this);
        }
        String bstr = "imq." + name + ".min_threads";
        this.props.addListener(bstr, this);
        bstr = "imq." + name + ".max_threads";
        this.props.addListener(bstr, this);
    }

    @Override
    public void stopMonitoringService(Service s) throws BrokerException {
        String name = s.getName();
        String protoname = "imq." + name + ".protocoltype";
        String protocol = this.props.getProperty(protoname);
        List params = this.getProtocolNames(protocol);
        for (int i = 0; params != null && i < params.size(); ++i) {
            String prop = (String)params.get(i);
            this.props.removeListener(prop, this);
        }
        String bstr = "imq." + name + ".min";
        this.props.removeListener(bstr, this);
        bstr = "imq." + name + ".max";
        this.props.removeListener(bstr, this);
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
    }

    @Override
    public boolean update(String name, String value) {
        return true;
    }

    protected int getThreadMin(String instancename) {
        String bstr = "imq." + instancename + ".min_threads";
        return this.props.getIntProperty(bstr);
    }

    protected int getPoolTimeout(String instancename) {
        String bstr = "imq." + instancename + ".destroy_timeout";
        return this.props.getIntProperty(bstr, this.DEFAULT_DESTROY_TIMEOUT) * 1000;
    }

    protected int getThreadMax(String instancename) {
        String bstr = "imq." + instancename + ".max_threads";
        return this.props.getIntProperty(bstr);
    }

    @Override
    public Service createService(String instancename, int type) throws BrokerException {
        String protocol_type_string = "imq." + instancename + ".protocoltype";
        String protocol = this.props.getProperty(protocol_type_string);
        if (protocol == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4003", instancename, protocol_type_string));
        }
        String pclass_type_string = PROTOCOL_PREFIX + protocol + ".class";
        String pclass = this.props.getProperty(pclass_type_string);
        if (pclass == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4003", instancename, pclass_type_string));
        }
        if (DEBUG) {
            this.logger.log(4, " Creating new Service(" + instancename + ":" + pclass + ")");
        }
        Protocol proto = null;
        try {
            proto = (Protocol)Class.forName(pclass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            Object[] args = new String[]{protocol, instancename};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4002", args), ex);
        }
        String prefix = PROTOCOL_PREFIX + protocol;
        boolean nodelay = Globals.getConfig().getBooleanProperty(prefix + ".nodelay", true);
        proto.setNoDelay(nodelay);
        int inputBufferSize = Globals.getConfig().getIntProperty(prefix + ".inbufsz", 0);
        int outputBufferSize = Globals.getConfig().getIntProperty(prefix + ".outbufsz", 0);
        proto.setInputBufferSize(inputBufferSize);
        proto.setOutputBufferSize(outputBufferSize);
        String serviceprefix = "imq." + instancename + "." + protocol;
        Map params = this.getProtocolParams(protocol, serviceprefix);
        params.put("serviceFactoryHandlerName", this.getFactoryHandlerName());
        proto.checkParameters(params);
        try {
            proto.setParameters(params);
            proto.open();
        }
        catch (IOException ex) {
            Object[] args = new String[]{pclass, protocol, instancename};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4001", args), ex);
        }
        try {
            IMQService svc = this.createService(instancename, proto, Globals.getPacketRouter(type), type, this.getThreadMin(instancename), this.getThreadMax(instancename));
            long timeout = this.getPoolTimeout(instancename);
            if (timeout > 0L) {
                svc.setDestroyWaitTime(timeout);
            }
            return svc;
        }
        catch (IOException ex) {
            try {
                proto.close();
            }
            catch (Exception ex1) {
                this.logger.log(1, "Error closing protocol", ex1);
            }
            throw new BrokerException(Globals.getBrokerResources().getKString("B3009", instancename), ex);
        }
    }

    protected abstract IMQService createService(String var1, Protocol var2, PacketRouter var3, int var4, int var5, int var6) throws IOException;
}

