/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

public class DynamicConfigListener
implements ConfigListener {
    private static final String ADMIN_LISTENER = "admin-listener";
    private GrizzlyService grizzlyService;
    private Config config;
    private final Logger logger;
    private static final int RECONFIG_LOCK_TIMEOUT_SEC = 30;
    private static final ReentrantLock reconfigLock = new ReentrantLock();
    private static final Map<Integer, FutureImpl> reconfigByPortLock = new HashMap<Integer, FutureImpl>();

    public DynamicConfigListener(Config parent, Logger logger) {
        this.config = parent;
        this.logger = logger;
    }

    public synchronized UnprocessedChangeEvents changed(final PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (DynamicConfigListener.this.logger.isLoggable(Level.FINE)) {
                    DynamicConfigListener.this.logger.log(Level.FINE, "NetworkConfig changed {0} {1} {2}", new Object[]{type, tClass, t});
                }
                if (tClass == NetworkListener.class && t instanceof NetworkListener) {
                    return DynamicConfigListener.this.processNetworkListener(type, (NetworkListener)t, events);
                }
                if (tClass == Http.class && t instanceof Http) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)t.getParent(), events);
                }
                if (tClass == FileCache.class && t instanceof FileCache) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)t.getParent().getParent(), null);
                }
                if (tClass == Ssl.class && t instanceof Ssl) {
                    ConfigBeanProxy parent = t.getParent();
                    if (parent instanceof Protocol) {
                        return DynamicConfigListener.this.processProtocol(type, (Protocol)parent, null);
                    }
                } else {
                    if (tClass == Protocol.class && t instanceof Protocol) {
                        return DynamicConfigListener.this.processProtocol(type, (Protocol)t, null);
                    }
                    if (tClass == ThreadPool.class && t instanceof ThreadPool) {
                        NotProcessed notProcessed = null;
                        for (NetworkListener listener : ((ThreadPool)t).findNetworkListeners()) {
                            notProcessed = DynamicConfigListener.this.processNetworkListener(type, listener, null);
                        }
                        return notProcessed;
                    }
                    if (tClass == Transport.class && t instanceof Transport) {
                        NotProcessed notProcessed = null;
                        for (NetworkListener listener : ((Transport)t).findNetworkListeners()) {
                            notProcessed = DynamicConfigListener.this.processNetworkListener(type, listener, null);
                        }
                        return notProcessed;
                    }
                    if (tClass == VirtualServer.class && t instanceof VirtualServer && !DynamicConfigListener.this.grizzlyService.hasMapperUpdateListener()) {
                        return DynamicConfigListener.this.processVirtualServer(type, (VirtualServer)t);
                    }
                    if (tClass == SystemProperty.class && t instanceof SystemProperty) {
                        NetworkConfig networkConfig = DynamicConfigListener.this.config.getNetworkConfig();
                        if (networkConfig != null && ((SystemProperty)t).getName().endsWith("LISTENER_PORT")) {
                            for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
                                if (!listener.getPort().equals(((SystemProperty)t).getValue())) continue;
                                return DynamicConfigListener.this.processNetworkListener(Changed.TYPE.CHANGE, listener, events);
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
        }, (Logger)this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ConfigBeanProxy> NotProcessed processNetworkListener(Changed.TYPE type, NetworkListener listener, PropertyChangeEvent[] changedProperties) {
        if (this.findConfigName((ConfigBeanProxy)listener).equals(this.findConfigName((ConfigBeanProxy)this.config))) {
            boolean isAdminListener = ADMIN_LISTENER.equals(listener.getName());
            Lock portLock = null;
            try {
                portLock = this.acquirePortLock(listener);
                if (type == Changed.TYPE.ADD) {
                    int[] ports = portLock.getPorts();
                    if (isAdminListener && ports[ports.length - 1] == -1) {
                        NotProcessed notProcessed = null;
                        return notProcessed;
                    }
                    Future<Result<Thread>> future = this.grizzlyService.createNetworkProxy(listener);
                    if (future != null) {
                        future.get(30L, TimeUnit.SECONDS);
                        this.grizzlyService.registerContainerAdapters();
                    } else {
                        this.logger.log(Level.FINE, "Skipping proxy registration for the listener {0}", listener.getName());
                    }
                } else if (type == Changed.TYPE.REMOVE) {
                    if (!isAdminListener) {
                        this.grizzlyService.removeNetworkProxy(listener);
                    }
                } else if (type == Changed.TYPE.CHANGE) {
                    if (isAdminListener) {
                        GrizzlyProxy proxy;
                        boolean dynamic = this.isAdminDynamic(changedProperties);
                        if (dynamic && (proxy = (GrizzlyProxy)this.grizzlyService.lookupNetworkProxy(listener)) != null) {
                            GrizzlyListener netListener = proxy.getUnderlyingListener();
                            netListener.processDynamicConfigurationChange(this.grizzlyService.getServiceLocator(), changedProperties);
                            NotProcessed notProcessed = null;
                            return notProcessed;
                        }
                        NotProcessed notProcessed = null;
                        return notProcessed;
                    }
                    this.grizzlyService.restartNetworkListener(listener, 30L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Network listener configuration error. Type: " + String.valueOf(type), e);
            }
            finally {
                if (portLock != null) {
                    this.releaseListenerLock(portLock);
                }
            }
        }
        return null;
    }

    private String findConfigName(ConfigBeanProxy child) {
        ConfigBeanProxy bean;
        for (bean = child; bean != null && !(bean instanceof Config); bean = bean.getParent()) {
        }
        return bean != null ? ((Config)bean).getName() : "";
    }

    private boolean isAdminDynamic(PropertyChangeEvent[] events) {
        if (events == null || events.length == 0) {
            return false;
        }
        for (PropertyChangeEvent e : events) {
            if (!"comet-support-enabled".equals(e.getPropertyName())) continue;
            return true;
        }
        return false;
    }

    private NotProcessed processProtocol(Changed.TYPE type, Protocol protocol, PropertyChangeEvent[] events) {
        NotProcessed notProcessed = null;
        for (NetworkListener listener : protocol.findNetworkListeners()) {
            notProcessed = this.processNetworkListener(type, listener, events);
        }
        return notProcessed;
    }

    private NotProcessed processVirtualServer(Changed.TYPE type, VirtualServer vs) {
        NotProcessed notProcessed = null;
        for (NetworkListener n : vs.findNetworkListeners()) {
            notProcessed = this.processNetworkListener(type, n, null);
        }
        return notProcessed;
    }

    public void setGrizzlyService(GrizzlyService grizzlyService) {
        this.grizzlyService = grizzlyService;
    }

    public Logger getLogger() {
        return this.logger;
    }

    private Lock acquirePortLock(NetworkListener listener) throws InterruptedException, TimeoutException {
        boolean isLoggingFinest = this.logger.isLoggable(Level.FINEST);
        int port = this.getPort(listener);
        try {
            while (true) {
                NetworkProxy runningProxy;
                this.logger.finest("Aquire reconfig lock");
                if (!reconfigLock.tryLock(30L, TimeUnit.SECONDS)) break;
                Future lock = (Future)reconfigByPortLock.get(port);
                if (isLoggingFinest) {
                    this.logger.log(Level.FINEST, "Reconfig lock for port: {0} is {1}", new Object[]{port, lock});
                }
                int proxyPort = -1;
                if (lock == null && (runningProxy = this.grizzlyService.lookupNetworkProxy(listener)) != null) {
                    proxyPort = runningProxy.getPort();
                    if (port != proxyPort) {
                        lock = (Future)reconfigByPortLock.get(proxyPort);
                        if (isLoggingFinest) {
                            this.logger.log(Level.FINEST, "Reconfig lock for proxyport: {0} is {1}", new Object[]{proxyPort, lock});
                        }
                    } else {
                        proxyPort = -1;
                    }
                }
                if (lock != null) {
                    reconfigLock.unlock();
                    try {
                        this.logger.finest("Waiting on reconfig lock");
                        lock.get(30L, TimeUnit.SECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new IllegalStateException(e);
                    }
                } else {
                    SafeFutureImpl future = SafeFutureImpl.create();
                    if (isLoggingFinest) {
                        this.logger.log(Level.FINEST, "Set reconfig lock for ports: {0} and {1}: {2}", new Object[]{port, proxyPort, future});
                    }
                    reconfigByPortLock.put(port, (FutureImpl)future);
                    if (proxyPort != -1) {
                        reconfigByPortLock.put(proxyPort, (FutureImpl)future);
                    }
                    Lock lock2 = new Lock(port, proxyPort);
                    return lock2;
                }
            }
            throw new TimeoutException("Lock timeout");
        }
        finally {
            if (reconfigLock.isHeldByCurrentThread()) {
                reconfigLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseListenerLock(Lock lock) {
        boolean isLoggingFinest = this.logger.isLoggable(Level.FINEST);
        reconfigLock.lock();
        try {
            int[] ports = lock.getPorts();
            if (isLoggingFinest) {
                this.logger.log(Level.FINEST, "Release reconfig lock for ports: {0}", Arrays.toString(ports));
            }
            FutureImpl future = null;
            for (int port : ports) {
                if (port == -1) continue;
                future = reconfigByPortLock.remove(port);
            }
            if (future != null) {
                if (isLoggingFinest) {
                    this.logger.log(Level.FINEST, "Release reconfig lock, set result: {0}", future);
                }
                future.result((Object)new Result((Object)Thread.currentThread()));
            }
        }
        finally {
            reconfigLock.unlock();
        }
    }

    private int getPort(NetworkListener listener) {
        int listenerPort;
        block2: {
            listenerPort = -1;
            try {
                listenerPort = Integer.parseInt(listener.getPort());
            }
            catch (NumberFormatException e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block2;
                this.logger.log(Level.WARNING, "Can not parse network-listener port number: {0}", listener.getPort());
            }
        }
        return listenerPort;
    }

    private static final class Lock {
        private final int[] ports;

        public Lock(int ... ports) {
            this.ports = ports;
        }

        public int[] getPorts() {
            return this.ports;
        }
    }
}

