/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.operation.internal;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.operation.OperationHandle;
import org.glassfish.hk2.extras.operation.OperationIdentifier;
import org.glassfish.hk2.extras.operation.OperationState;
import org.glassfish.hk2.extras.operation.internal.SingleOperationManager;

public class OperationHandleImpl<T extends Annotation>
implements OperationHandle<T> {
    private final SingleOperationManager<T> parent;
    private final OperationIdentifier<T> identifier;
    private final ReentrantLock lock = new ReentrantLock();
    private final ReentrantLock operationLock;
    private OperationState state;
    private final HashSet<Long> activeThreads = new HashSet();
    private Object userData;

    OperationHandleImpl(SingleOperationManager<T> parent, OperationIdentifier<T> identifier, ReentrantLock operationLock, ServiceLocator locator) {
        this.parent = parent;
        this.identifier = identifier;
        this.operationLock = operationLock;
        this.state = OperationState.SUSPENDED;
    }

    @Override
    public OperationIdentifier<T> getIdentifier() {
        return this.identifier;
    }

    @Override
    public OperationState getState() {
        this.operationLock.lock();
        try {
            OperationState operationState = this.state;
            return operationState;
        }
        finally {
            this.operationLock.unlock();
        }
    }

    void shutdownByFiat() {
        this.state = OperationState.CLOSED;
    }

    private void checkState() {
        this.operationLock.lock();
        try {
            if (OperationState.CLOSED.equals((Object)this.state)) {
                throw new IllegalStateException(this + " is closed");
            }
        }
        finally {
            this.operationLock.unlock();
        }
    }

    @Override
    public Set<Long> getActiveThreads() {
        this.operationLock.lock();
        try {
            Set<Long> set = Collections.unmodifiableSet(this.activeThreads);
            return set;
        }
        finally {
            this.operationLock.unlock();
        }
    }

    @Override
    public void suspend(long threadId) {
        this.operationLock.lock();
        try {
            if (OperationState.CLOSED.equals((Object)this.state)) {
                return;
            }
            this.parent.disassociateThread(threadId, this);
            if (this.activeThreads.remove(threadId) && this.activeThreads.isEmpty()) {
                this.state = OperationState.SUSPENDED;
            }
        }
        finally {
            this.operationLock.unlock();
        }
    }

    @Override
    public void suspend() {
        this.suspend(Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(long threadId) throws IllegalStateException {
        this.operationLock.lock();
        try {
            this.checkState();
            if (this.activeThreads.contains(threadId)) {
                return;
            }
            OperationHandleImpl<T> existing = this.parent.getCurrentOperationOnThisThread(threadId);
            if (existing != null) {
                throw new IllegalStateException("The operation " + existing + " is active on " + threadId);
            }
            if (this.activeThreads.isEmpty()) {
                this.state = OperationState.ACTIVE;
            }
            this.activeThreads.add(threadId);
            this.parent.associateWithThread(threadId, this);
        }
        finally {
            this.operationLock.unlock();
        }
    }

    @Override
    public void resume() throws IllegalStateException {
        this.resume(Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.parent.disposeAllOperationServices(this);
        this.operationLock.lock();
        try {
            for (long threadId : this.activeThreads) {
                this.parent.disassociateThread(threadId, this);
            }
            this.activeThreads.clear();
            this.state = OperationState.CLOSED;
            this.parent.closeOperation(this);
        }
        finally {
            this.operationLock.unlock();
        }
    }

    @Override
    public void closeOperation() {
        this.close();
    }

    @Override
    public Object getOperationData() {
        this.lock.lock();
        try {
            Object object = this.userData;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setOperationData(Object data) {
        this.lock.lock();
        try {
            this.userData = data;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof OperationHandleImpl)) {
            return false;
        }
        return this.identifier.equals(((OperationHandleImpl)o).identifier);
    }

    public String toString() {
        return "OperationHandleImpl(" + this.identifier + "," + System.identityHashCode(this) + ")";
    }
}

