/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.authorize;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.ee.authorize.PolicyContextDelegate;
import com.sun.enterprise.security.ee.authorize.cache.PermissionCacheFactory;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.internal.api.Globals;

public class HandlerData {
    private HttpServletRequest httpReq = null;
    private ComponentInvocation inv = null;
    private PolicyContextDelegate ejbDelegate = (PolicyContextDelegate)Globals.getDefaultHabitat().getService(PolicyContextDelegate.class, "EJB", new Annotation[0]);

    private HandlerData() {
    }

    public static HandlerData getInstance() {
        return new HandlerData();
    }

    public void setHttpServletRequest(HttpServletRequest httpReq) {
        this.httpReq = httpReq;
    }

    public void setInvocation(ComponentInvocation inv) {
        this.inv = inv;
    }

    public Object get(String key) {
        if ("jakarta.servlet.http.HttpServletRequest".equalsIgnoreCase(key)) {
            return this.httpReq;
        }
        if ("javax.security.auth.Subject.container".equalsIgnoreCase(key)) {
            return SecurityContext.getCurrent().getSubject();
        }
        if ("java.security.Policy.supportsReuse".equalsIgnoreCase(key)) {
            PermissionCacheFactory.resetCaches();
            return 0;
        }
        if (this.inv == null) {
            return null;
        }
        if ("jakarta.xml.soap.SOAPMessage".equalsIgnoreCase(key)) {
            return this.ejbDelegate != null ? this.ejbDelegate.getSOAPMessage(this.inv) : null;
        }
        if ("jakarta.ejb.EnterpriseBean".equalsIgnoreCase(key)) {
            return this.ejbDelegate != null ? this.ejbDelegate.getEnterpriseBean(this.inv) : null;
        }
        if ("jakarta.ejb.arguments".equalsIgnoreCase(key)) {
            return this.ejbDelegate != null ? this.ejbDelegate.getEJbArguments(this.inv) : null;
        }
        return null;
    }

    void reset() {
        this.httpReq = null;
        this.inv = null;
        this.ejbDelegate = null;
    }
}

