/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.logging.LogDomains;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;

public class ConnectorRegistry {
    static final Logger _logger = LogDomains.getLogger(ConnectorRegistry.class, (String)"jakarta.enterprise.resource.resourceadapter");
    protected static final ConnectorRegistry connectorRegistryInstance = new ConnectorRegistry();
    protected final Map<String, ActiveResourceAdapter> resourceAdapters = Collections.synchronizedMap(new HashMap());
    protected final Map<PoolInfo, PoolMetaData> factories = Collections.synchronizedMap(new HashMap());
    protected final Map<String, ResourceAdapterConfig> resourceAdapterConfig = Collections.synchronizedMap(new HashMap());
    protected final Map<String, ConnectorApplication> rarModules = Collections.synchronizedMap(new HashMap());
    protected final Map<String, Validator> beanValidators = Collections.synchronizedMap(new HashMap());
    protected final ConcurrentMap<ResourceInfo, AtomicLong> resourceInfoVersion = new ConcurrentHashMap<ResourceInfo, AtomicLong>();
    protected final Set<ResourceInfo> resourceInfos = new HashSet<ResourceInfo>();
    protected final Set<PoolInfo> transparentDynamicReconfigPools = new HashSet<PoolInfo>();
    protected final Map<String, Object> locks = new HashMap<String, Object>();

    public static ConnectorRegistry getInstance() {
        return connectorRegistryInstance;
    }

    protected ConnectorRegistry() {
        _logger.log(Level.FINE, "Initialized the connector registry");
    }

    public void addActiveResourceAdapter(String rarModuleName, ActiveResourceAdapter rar) {
        this.resourceAdapters.put(rarModuleName, rar);
        _logger.log(Level.FINE, "Added the active resource adapter {0} to connector registry", rarModuleName);
    }

    public long getResourceInfoVersion(ResourceInfo resourceInfo) {
        AtomicLong version = (AtomicLong)this.resourceInfoVersion.get(resourceInfo);
        if (version == null) {
            return -1L;
        }
        return version.get();
    }

    public long updateResourceInfoVersion(ResourceInfo resourceInfo) {
        AtomicLong newVersion;
        AtomicLong version = (AtomicLong)this.resourceInfoVersion.get(resourceInfo);
        if (version == null && (version = this.resourceInfoVersion.putIfAbsent(resourceInfo, newVersion = new AtomicLong())) == null) {
            version = newVersion;
        }
        return version.incrementAndGet();
    }

    public boolean removeResourceFactories(ResourceInfo resourceInfo) {
        this.resourceInfoVersion.remove(resourceInfo);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceInfo(ResourceInfo resourceInfo) {
        if (resourceInfo != null) {
            Set<ResourceInfo> set = this.resourceInfos;
            synchronized (set) {
                this.resourceInfos.add(resourceInfo);
            }
            this.updateResourceInfoVersion(resourceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeResourceInfo(ResourceInfo resourceInfo) {
        boolean removed = false;
        if (resourceInfo != null) {
            Set<ResourceInfo> set = this.resourceInfos;
            synchronized (set) {
                removed = this.resourceInfos.remove(resourceInfo);
            }
            this.resourceInfoVersion.remove(resourceInfo);
        }
        return removed;
    }

    public boolean isResourceDeployed(ResourceInfo resourceInfo) {
        if (resourceInfo != null) {
            return this.resourceInfos.contains(resourceInfo);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransparentDynamicReconfigPool(PoolInfo poolInfo) {
        if (poolInfo != null) {
            Set<PoolInfo> set = this.transparentDynamicReconfigPools;
            synchronized (set) {
                this.transparentDynamicReconfigPools.add(poolInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTransparentDynamicReconfigPool(PoolInfo poolInfo) {
        if (poolInfo != null) {
            Set<PoolInfo> set = this.transparentDynamicReconfigPools;
            synchronized (set) {
                return this.transparentDynamicReconfigPools.remove(poolInfo);
            }
        }
        return false;
    }

    public boolean isTransparentDynamicReconfigPool(PoolInfo poolInfo) {
        if (poolInfo != null) {
            return this.transparentDynamicReconfigPools.contains(poolInfo);
        }
        return false;
    }

    public boolean removeActiveResourceAdapter(String rarModuleName) {
        ActiveResourceAdapter o = this.resourceAdapters.remove(rarModuleName);
        if (o == null) {
            _logger.log(Level.FINE, "Failed to remove the resource adapter {0} from connector registry.", rarModuleName);
            return false;
        }
        _logger.log(Level.FINE, "Removed the active resource adapter {0} from connector registry", rarModuleName);
        return true;
    }

    public ActiveResourceAdapter getActiveResourceAdapter(String rarModuleName) {
        _logger.log(Level.FINEST, "getActiveResourceAdapter(rarModuleName={0})", rarModuleName);
        if (rarModuleName == null) {
            return null;
        }
        return this.resourceAdapters.get(rarModuleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLockObject(String rarName) {
        Object lock;
        if (rarName == null) {
            return null;
        }
        Map<String, Object> map = this.locks;
        synchronized (map) {
            lock = this.locks.get(rarName);
            if (lock == null) {
                lock = new Object();
                this.locks.put(rarName, lock);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("added lock-object [ " + String.valueOf(lock) + " ] for rar : " + rarName);
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLockObject(String rarName) {
        if (rarName == null) {
            return;
        }
        Map<String, Object> map = this.locks;
        synchronized (map) {
            Object lock = this.locks.remove(rarName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("removed lock-object [ " + String.valueOf(lock) + " ] for rar : " + rarName);
            }
        }
    }

    public void addBeanValidator(String rarModuleName, Validator validator) {
        this.beanValidators.put(rarModuleName, validator);
        _logger.log(Level.FINE, "Added the bean validator for RAR [{0}] to connector registry", rarModuleName);
    }

    public Validator getBeanValidator(String rarModuleName) {
        _logger.log(Level.FINE, "getBeanValidator(rarModuleName={0})", rarModuleName);
        if (rarModuleName == null) {
            return null;
        }
        return this.beanValidators.get(rarModuleName);
    }

    public boolean removeBeanValidator(String rarModuleName) {
        _logger.log(Level.FINE, "removeBeanValidator(rarModuleName={0})", rarModuleName);
        Validator o = this.beanValidators.remove(rarModuleName);
        if (o == null) {
            _logger.log(Level.FINE, "Failed to remove the bean validator for RAR [{0}] from connector registry", rarModuleName);
            return false;
        }
        _logger.log(Level.FINE, "Removed the active bean validator for RAR [{0}] from connector registry", rarModuleName);
        return true;
    }

    public boolean isMCFCreated(PoolInfo poolInfo) {
        return this.factories.containsKey(poolInfo);
    }

    public boolean removeManagedConnectionFactory(PoolInfo poolInfo) {
        _logger.log(Level.FINE, "removeManagedConnectionFactory(poolInfo={0})", poolInfo);
        if (this.factories.remove(poolInfo) == null) {
            _logger.log(Level.FINE, "Failed to remove the MCF from connector registry for {0}.", poolInfo);
            return false;
        }
        _logger.log(Level.FINE, "Removed MCF from connector registry for {0}.", poolInfo);
        return true;
    }

    public void addManagedConnectionFactory(PoolInfo poolInfo, PoolMetaData pmd) {
        this.factories.put(poolInfo, pmd);
        _logger.log(Level.FINE, "Added MCF to connector registry for {0}", poolInfo);
    }

    public ManagedConnectionFactory getManagedConnectionFactory(PoolInfo poolInfo) {
        PoolMetaData pmd;
        _logger.log(Level.FINE, "getManagedConnectionFactory(poolInfo={0})", poolInfo);
        if (poolInfo != null && (pmd = this.factories.get(poolInfo)) != null) {
            return pmd.getMCF();
        }
        return null;
    }

    public boolean isRegistered(String rarModuleName) {
        _logger.log(Level.FINE, "isRegistered(rarModuleName={0})", rarModuleName);
        return this.resourceAdapters.containsKey(rarModuleName);
    }

    public ConnectorDescriptor getDescriptor(String rarModuleName) {
        _logger.log(Level.FINE, "getDescriptor(rarModuleName={0})", rarModuleName);
        ActiveResourceAdapter ar = null;
        if (rarModuleName != null) {
            ar = this.resourceAdapters.get(rarModuleName);
        }
        if (ar == null) {
            _logger.log(Level.FINE, "Could not find Connector descriptor in connector registry for {0}", rarModuleName);
            return null;
        }
        return ar.getDescriptor();
    }

    public RuntimeSecurityMap getRuntimeSecurityMap(PoolInfo poolInfo) {
        _logger.log(Level.FINE, "getRuntimeSecurityMap(poolInfo={0})", poolInfo);
        if (poolInfo == null) {
            return null;
        }
        PoolMetaData pmd = this.factories.get(poolInfo);
        return pmd.getRuntimeSecurityMap();
    }

    public ResourceAdapterConfig getResourceAdapterConfig(String rarName) {
        _logger.log(Level.FINE, "getResourceAdapterConfig(rarName={0})", rarName);
        if (rarName == null) {
            return null;
        }
        return this.resourceAdapterConfig.get(rarName);
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) {
        if (rarName != null) {
            _logger.log(Level.FINE, "Adding the resourceAdapter Config to connector registry for {0}", rarName);
            this.resourceAdapterConfig.put(rarName, raConfig);
        }
    }

    public boolean removeResourceAdapterConfig(String rarName) {
        _logger.log(Level.FINE, "removeResourceAdapterConfig(rarName={0})", rarName);
        if (this.resourceAdapterConfig.remove(rarName) == null) {
            _logger.log(Level.FINE, "Failed to remove the resourceAdapter config from registry for {0}.", rarName);
            return false;
        }
        _logger.log(Level.FINE, "Removed the resourceAdapter config map from registry for {0}.", rarName);
        return true;
    }

    public ActiveResourceAdapter[] getAllActiveResourceAdapters() {
        ActiveResourceAdapter[] araArray = new ActiveResourceAdapter[this.resourceAdapters.size()];
        return this.resourceAdapters.values().toArray(araArray);
    }

    public PoolMetaData getPoolMetaData(PoolInfo poolInfo) {
        return this.factories.get(poolInfo);
    }

    public void addConnectorApplication(ConnectorApplication rarModule) {
        this.rarModules.put(rarModule.getModuleName(), rarModule);
    }

    public ConnectorApplication getConnectorApplication(String rarName) {
        return this.rarModules.get(rarName);
    }

    public void removeConnectorApplication(String rarName) {
        this.rarModules.remove(rarName);
    }

    public List<String> getConnectorsSupportingMessageListener(String messageListener) {
        ArrayList<String> rars = new ArrayList<String>();
        for (ActiveResourceAdapter ara : this.resourceAdapters.values()) {
            ConnectorDescriptor desc = ara.getDescriptor();
            if (!desc.getInBoundDefined() || desc.getInboundResourceAdapter().getMessageListener(messageListener) == null) continue;
            rars.add(ara.getModuleName());
        }
        return rars;
    }
}

