/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.migrate.ldapjdk.IterableEnumeration;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class LDAPUrl
implements Serializable {
    private static final long serialVersionUID = -1716384037873600695L;
    private final LDAPURL ldapURL;

    public LDAPUrl(String url) throws MalformedURLException {
        try {
            this.ldapURL = new LDAPURL(url);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new MalformedURLException(le.getMessage());
        }
    }

    public LDAPUrl(String host, int port, String dn) throws RuntimeException {
        try {
            DN dnObject = dn == null ? null : new DN(dn);
            this.ldapURL = new LDAPURL("ldap", host, port, dnObject, null, null, null);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new RuntimeException(e);
        }
    }

    public LDAPUrl(String host, int port, String dn, String[] attributes, int scope, String filter) throws RuntimeException {
        try {
            DN dnObject = dn == null ? null : new DN(dn);
            SearchScope scopeObject = SearchScope.valueOf(scope);
            Filter filterObject = Filter.create(filter);
            this.ldapURL = new LDAPURL("ldap", host, port, dnObject, attributes, scopeObject, filterObject);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new RuntimeException(e);
        }
    }

    public LDAPUrl(String host, int port, String dn, Enumeration<String> attributes, int scope, String filter) throws RuntimeException {
        try {
            String[] attrs;
            DN dnObject = dn == null ? null : new DN(dn);
            SearchScope scopeObject = SearchScope.valueOf(scope);
            Filter filterObject = Filter.create(filter);
            if (attributes == null) {
                attrs = null;
            } else {
                ArrayList<String> attrList = new ArrayList<String>();
                while (attributes.hasMoreElements()) {
                    attrList.add(attributes.nextElement());
                }
                attrs = new String[attrList.size()];
                attrList.toArray(attrs);
            }
            this.ldapURL = new LDAPURL("ldap", host, port, dnObject, attrs, scopeObject, filterObject);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new RuntimeException(e);
        }
    }

    public LDAPUrl(LDAPURL ldapURL) {
        this.ldapURL = ldapURL;
    }

    public String getHost() {
        return this.ldapURL.getHost();
    }

    public int getPort() {
        return this.ldapURL.getPort();
    }

    public String getDN() {
        if (this.ldapURL.baseDNProvided()) {
            return this.ldapURL.getBaseDN().toString();
        }
        return null;
    }

    public Enumeration<String> getAttributes() {
        String[] attributes = this.ldapURL.getAttributes();
        if (attributes.length == 0) {
            return null;
        }
        return new IterableEnumeration<String>(Arrays.asList(attributes));
    }

    public String[] getAttributeArray() {
        String[] attributes = this.ldapURL.getAttributes();
        if (attributes.length == 0) {
            return null;
        }
        return attributes;
    }

    public int getScope() {
        return this.ldapURL.getScope().intValue();
    }

    public String getFilter() {
        return this.ldapURL.getFilter().toString();
    }

    public int hashCode() {
        return this.ldapURL.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof LDAPUrl) {
            return this.ldapURL.equals(((LDAPUrl)o).ldapURL);
        }
        return false;
    }

    public String getUrl() {
        return this.ldapURL.toString();
    }

    public final LDAPURL toLDAPURL() {
        return this.ldapURL;
    }

    public String toString() {
        return this.ldapURL.toString();
    }
}

