/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.api.jsonbadapter;

import ee.jakarta.tck.json.bind.api.model.SimpleContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleContainerContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleStringAdapter;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.adapter.JsonbAdapter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class JsonbAdapterTest {
    @Test
    public void testAdaptFromJson() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withAdapters(new JsonbAdapter[]{new SimpleStringAdapter()}));
        SimpleContainerContainer unmarshalledObject = (SimpleContainerContainer)jsonb.fromJson("{ \"instance\" : { \"instance\" : \"Test String Adapted\" } }", SimpleContainerContainer.class);
        MatcherAssert.assertThat((String)"Failed to use JsonbAdapter.adaptFromJson method to provide conversion logic from adapted object to original during object deserialization.", (Object)unmarshalledObject.getInstance().getInstance(), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testAdaptToJson() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withAdapters(new JsonbAdapter[]{new SimpleStringAdapter()}));
        String jsonString = jsonb.toJson((Object)new SimpleContainerContainer(){
            {
                this.setInstance(new SimpleContainer(){
                    {
                        this.setInstance("Test String");
                    }
                });
            }
        });
        MatcherAssert.assertThat((String)"Failed to use JsonbAdapter.adaptToJson method to provide conversion logic from original object to adapted during object serialization.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String Adapted\"\\s*}\\s*}"));
    }
}

