/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.mergetests;

import ee.jakarta.tck.jsonp.api.common.SimpleValues;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.mergetests.MergeCommon;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.logging.Logger;

public class MergeAddValue
extends MergeCommon {
    private static final Logger LOGGER = Logger.getLogger(MergeAddValue.class.getName());

    MergeAddValue() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 7396: Add non existing values");
        LOGGER.info("Testing RFC 7396: Add non existing values");
        this.testStringOnEmptyObject(result);
        this.testStringOnsimpleObject(result);
        this.testIntOnEmptyObject(result);
        this.testIntOnsimpleObject(result);
        this.testBoolOnEmptyObject(result);
        this.testBoolOnsimpleObject(result);
        this.testObjectOnEmptyObject(result);
        this.testObjectOnsimpleObject(result);
        return result;
    }

    private void testStringOnEmptyObject(TestResult result) {
        LOGGER.info(" - for String on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject patch = SimpleValues.createSimpleObjectStr();
        JsonObject check = SimpleValues.createSimpleObjectStr();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testStringOnsimpleObject(TestResult result) {
        LOGGER.info(" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject patch = SimpleValues.createSimpleObjectStr();
        JsonObject check = SimpleValues.createSimpleObjectWithStr();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnEmptyObject(TestResult result) {
        LOGGER.info(" - for int on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject patch = SimpleValues.createSimpleObjectInt();
        JsonObject check = SimpleValues.createSimpleObjectInt();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnsimpleObject(TestResult result) {
        LOGGER.info(" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject patch = SimpleValues.createSimpleObjectInt();
        JsonObject check = SimpleValues.createSimpleObjectWithInt();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testBoolOnEmptyObject(TestResult result) {
        LOGGER.info(" - for boolean on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject patch = SimpleValues.createSimpleObjectBool();
        JsonObject check = SimpleValues.createSimpleObjectBool();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testBoolOnsimpleObject(TestResult result) {
        LOGGER.info(" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject patch = SimpleValues.createSimpleObjectBool();
        JsonObject check = SimpleValues.createSimpleObjectWithBool();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testObjectOnEmptyObject(TestResult result) {
        LOGGER.info(" - for JsonObject on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject patch = SimpleValues.createSimpleObjectObject();
        JsonObject check = SimpleValues.createSimpleObjectObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testObjectOnsimpleObject(TestResult result) {
        LOGGER.info(" - for JsonObject on compound JSON object");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonObject patch = SimpleValues.createSimpleObjectObject();
        JsonObject check = SimpleValues.createCompoundObjectWithObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }
}

