/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.matrixparam;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.JaxrsParamClient;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityPrototype;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingExceptionGivenByName;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingWebApplicationException;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithConstructor;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithFromString;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithValueOf;
import ee.jakarta.tck.ws.rs.ee.rs.ParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.RuntimeExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.WebApplicationExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.matrixparam.MatrixParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.matrixparam.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsParamClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_matrixparam_web/MatrixParamTest");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false, name="jaxrs_ee_rs_matrixparam_deployment")
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/matrixparam/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_matrixparam_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, MatrixParamTest.class, MatrixParamTest.class, ParamEntityPrototype.class, ParamEntityWithConstructor.class, ParamEntityWithValueOf.class, ParamEntityWithFromString.class, ParamTest.class, JaxrsParamClient.CollectionName.class, ParamEntityThrowingWebApplicationException.class, ParamEntityThrowingExceptionGivenByName.class, RuntimeExceptionMapper.class, WebApplicationExceptionMapper.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void matrixParamStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("stringtest=cts"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest=cts");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("stringtest1=cts;stringtest=ri_impl"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest=ri_impl|stringtest1=cts");
        this.invoke();
    }

    @Test
    public void matrixParamIntTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("inttest1=2147483647"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "inttest1=2147483647");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("inttest1=2147483647;inttest2=-2147483648"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "inttest1=2147483647|inttest2=-2147483648");
        this.invoke();
    }

    @Test
    public void matrixParamDoubleTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("doubletest1=123"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "doubletest1=123.0");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("doubletest1=12.345;doubletest2=34.567"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "doubletest1=12.345|doubletest2=34.567");
        this.invoke();
    }

    @Test
    public void matrixParamFloatTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("floattest1=123"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "floattest1=123.0");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("floattest1=12.345;floattest2=34.567"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "floattest1=12.345|floattest2=34.567");
        this.invoke();
    }

    @Test
    public void matrixParamLongTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("longtest=-9223372036854775808"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "longtest=-9223372036854775808");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("longtest1=-9223372036854775808;longtest2=9223372036854775807"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "longtest1=-9223372036854775808|longtest2=9223372036854775807");
        this.invoke();
    }

    @Test
    public void matrixParamShortTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("shorttest=-32768"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "shorttest=-32768");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("shorttest1=32767;shorttest2=-32768"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "shorttest1=32767|shorttest2=-32768");
        this.invoke();
    }

    @Test
    public void matrixParamByteTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("bytetest=127"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "bytetest=127");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("bytetest1=123;bytetest2=-128"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "bytetest1=123|bytetest2=-128");
        this.invoke();
    }

    @Test
    public void matrixParamBooleanTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("booleantest=true"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "booleantest=true");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("booleantest1=false;booleantest2=true"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "booleantest1=false|booleantest2=true");
        this.invoke();
    }

    @Test
    public void matrixParamEntityWithConstructorTest() throws JAXRSCommonClient.Fault {
        this.paramEntityWithConstructorTest();
    }

    @Test
    public void matrixParamEntityWithValueOfTest() throws JAXRSCommonClient.Fault {
        this.paramEntityWithValueOfTest();
    }

    @Test
    public void matrixParamEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        this.paramEntityWithFromStringTest();
    }

    @Test
    public void matrixParamSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        this.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SET);
    }

    @Test
    public void matrixParamSortedSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        this.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SORTED_SET);
    }

    @Test
    public void matrixParamListEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        this.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.LIST);
    }

    @Test
    public void matrixFieldParamEntityWithConstructorTest() throws JAXRSCommonClient.Fault {
        this.fieldEntityWithConstructorTest();
    }

    @Test
    public void matrixFieldParamEntityWithValueOfTest() throws JAXRSCommonClient.Fault {
        this.fieldEntityWithValueOfTest();
    }

    @Test
    public void matrixFieldParamEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        this.fieldEntityWithFromStringTest();
    }

    @Test
    public void matrixFieldParamSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        this.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SET);
    }

    @Test
    public void matrixFieldParamSortedSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        this.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SORTED_SET);
    }

    @Test
    public void matrixFieldParamListEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        this.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.LIST);
    }

    @Test
    public void matrixParamEntityWithEncodedTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithEncodedTest();
    }

    @Test
    public void matrixFieldParamEntityWithEncodedTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithEncodedTest();
    }

    @Test
    public void matrixParamThrowingWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        super.paramThrowingWebApplicationExceptionTest();
    }

    @Test
    public void matrixFieldThrowingWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        super.fieldThrowingWebApplicationExceptionTest();
    }

    @Test
    public void matrixParamThrowingIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Response.Status.NOT_FOUND.name());
        super.paramThrowingIllegalArgumentExceptionTest();
    }

    @Test
    public void matrixFieldThrowingIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Response.Status.NOT_FOUND.name());
        super.fieldThrowingIllegalArgumentExceptionTest();
    }

    @Override
    protected String buildRequest(String param) {
        StringBuilder sb = new StringBuilder();
        sb.append(JAXRSCommonClient.Request.GET.name()).append(" ").append(this._contextRoot);
        sb.append(";").append(param).append(" HTTP/1.1");
        return sb.toString();
    }

    @Override
    protected String getDefaultValueOfParam(String param) {
        StringBuilder sb = new StringBuilder();
        sb.append(param).append("=");
        sb.append(MatrixParamTest.class.getSimpleName());
        return sb.toString();
    }
}

