/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.unsignedbyte.maxinclusive.maxinclusive_1;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxInclusive1_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxInclusive1_ValidateCTTests test = new maxInclusive1_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final short[] invalidValues = {(short)1, (short)255, (short)400, (short)-1, (short)-400};
    final short[] validValues = {(short)0};
    
    JAXBElement<Short> elemObj;

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    public Status Validate001( ) {
        String xmlDocName = "maxInclusive-1-1.xml";
        elemObj = (JAXBElement<Short>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "maxInclusive-1-1.xml";
        elemObj = (JAXBElement<Short>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Short>)(new ObjectFactory()).createNISTSchemaUnsignedByteMaxInclusive1((short)0);
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<Short>)(new ObjectFactory()).createNISTSchemaUnsignedByteMaxInclusive1((short)0);
        
        return testInvalid();
    }


}

