/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.localaccess.mdbqaccesstest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.Client;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import java.util.Properties;

public class MDBClient
extends Client {
    private Queue queueS = null;
    private QueueSender qSender = null;
    private String generateSQL;
    private static final String myMessage = "mdb local access tests for ejb";
    private static final String testQF = "java:comp/env/jms/MyQueueConnectionFactory";
    private static final String testSQ = "java:comp/env/jms/MDB_QUEUE";

    public static void main(String[] args) {
        MDBClient theTests = new MDBClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            super.setup(args, p);
            this.queueS = (Queue)this.context.lookup(testSQ);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        String TestCase = "local_access_from_mdb_queue_to_entity_bean_test1";
        this.logTrace("local_access_from_mdb_queue_to_entity_bean_test1");
        boolean pass = false;
        int TestNum = 1;
        try {
            pass = this.doTest(TestNum, TestCase);
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test2() throws EETest.Fault {
        String TestCase = "local_access_from_mdb_queue_to_session_bean_test2";
        boolean pass = false;
        int TestNum = 2;
        try {
            pass = this.doTest(TestNum, TestCase);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught running test2", (Throwable)e);
        }
        finally {
            try {
                this.createTestMessage("remove_stateful_bean", 0);
                this.qSender.send((Message)this.msg);
            }
            catch (Exception ee) {
                TestUtil.logTrace((String)"Exception caught removing SSF bean", (Throwable)ee);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void test3() throws EETest.Fault {
        String TestCase = "local_access_from_mdb_queue_to_session_bean_test3";
        boolean pass = false;
        int TestNum = 3;
        try {
            pass = this.doTest(TestNum, TestCase);
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test3 failed");
        }
    }

    public void test4() throws EETest.Fault {
        String TestCase = "local_access_from_mdb_queue_to_session_bean_test4";
        boolean pass = false;
        int TestNum = 4;
        try {
            pass = this.doTest(TestNum, TestCase);
        }
        catch (Exception e) {
            throw new EETest.Fault("test4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    private boolean doTest(int TestNum, String TestCase) throws Exception {
        this.logTrace(TestCase);
        boolean result = false;
        this.qSender = this.session.createSender(this.queueS);
        this.createTestMessage(TestCase, TestNum);
        TestUtil.logTrace((String)"MDBClient - sending msg to mdb");
        TestUtil.logTrace((String)"MDBClient - ");
        this.qSender.send((Message)this.msg);
        if (!this.checkOnResponse(TestCase)) {
            throw new Exception("Error: Did not get expected response from mdb!");
        }
        result = true;
        return result;
    }

    private void cleanTheQueue() {
        Message m = null;
        try {
            QueueReceiver rcvr = this.session.createReceiver(this.rcvrQueue);
            m = rcvr.receive(this.timeout);
            while (m != null) {
                m = rcvr.receive(this.timeout);
                TestUtil.logTrace((String)"Cleaning a message in the queue");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logTrace((String)"Error in cleanTheQueue");
        }
    }
}

