/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.ejbql.from_clause;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AliasHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Customer;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.ProductHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Schema;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Util;
import java.util.Collection;
import java.util.Properties;

public class Client
extends EETest {
    private CustomerHome customerHome = null;
    private OrderHome orderHome = null;
    private AliasHome aliasHome = null;
    private ProductHome productHome = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            this.props = p;
            Schema.setup(p);
            this.customerHome = Schema.customerHome;
            this.orderHome = Schema.orderHome;
            this.aliasHome = Schema.aliasHome;
            this.productHome = Schema.productHome;
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void fromTest1() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find All Orders for Customer: Robert E. Bissett");
            o = this.orderHome.findAllOrdersByCustomerName("Robert E. Bissett");
            expectedPKs = new String[]{"4", "9"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders for Robert E. Bissett");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders for Robert E. Bissett");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception fromTest1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("fromTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("fromTest1 failed");
        }
    }

    public void fromTest2() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find All Customers");
            c = this.customerHome.findAllCustomers();
            expectedPKs = new String[14];
            for (int i = 0; i < 14; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers in CustomerEJB");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers in CustomerEJB");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception fromTest2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("fromTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("fromTest2 failed");
        }
    }

    public void fromTest3() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find All Customers with Alias: imc");
            c = this.customerHome.findAllCustomersByAliasName("imc");
            expectedPKs = new String[]{"8"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers with Alias: imc");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers with Alias: imc");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception fromTest3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("fromTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("fromTest3 failed");
        }
    }

    public void fromTest4() throws EETest.Fault {
        boolean pass = true;
        Customer c = null;
        try {
            TestUtil.logMsg((String)"Find Customer with Home Address in Swansea");
            c = this.customerHome.findCustomerByHomeAddress("125 Moxy Lane", "Swansea", "MA", "11345");
            if (!Util.checkEJB(c, "3")) {
                TestUtil.logErr((String)"UnSuccessfully found customer Shelly D. Mcgowan");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customer Shelly D. Mcgowan");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception fromTest4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("fromTest4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("fromTest4 failed");
        }
    }

    public void fromTest5() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all Customers with AXP Credit Cards");
            c = this.customerHome.findCustomersByCreditCardType("AXP");
            expectedPKs = new String[]{"1", "4", "5", "8", "9", "12"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers with AXP Credit Cards");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers with AXP Credit Cards");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception fromTest4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("fromTest5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("fromTest5 failed");
        }
    }

    public void fromTest6() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find Customers with Home Address Information");
            c = this.customerHome.findCustomersByHomeInfo("47 Skyline Drive", "Chelmsford", "VT", "02155");
            expectedPKs = new String[]{"1", "10", "11", "13"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found expected customers");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found expected customers");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception fromTest6: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("fromTest6 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("fromTest6 failed");
        }
    }

    public void fromTest7() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection p = null;
        try {
            TestUtil.logMsg((String)"Find All Products");
            p = this.productHome.findProductsByQuery9();
            expectedPKs = new String[18];
            for (int i = 0; i < 18; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!Util.checkEJBs(p, 4, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all products");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all products");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception fromTest7: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("fromTest7 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("fromTest7 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }
}

