/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;

public class StepLevelPropertiesTests
extends ServiceEETest {
    private JobOperatorBridge jobOp = null;
    private int PROPERTIES_COUNT = 3;
    private String FOO_VALUE = "bar";

    public void testStepLevelPropertiesCount() throws EETest.Fault {
        String METHOD = "testStepLevelPropertiesCount";
        TestUtil.logTrace((String)METHOD);
        String SHOULD_BE_UNAVAILABLE_PROP_PREFIX = "com.ibm.jbatch.tck.tests.jslxml.StepLevelPropertiesTests";
        Properties jobParams = new Properties();
        jobParams.put(SHOULD_BE_UNAVAILABLE_PROP_PREFIX + ".parm1", "should.not.appear.in.step.context.properties");
        try {
            TestUtil.logMsg((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("step_level_properties_count");
            TestUtil.logMsg((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Job completed", "VERY GOOD INVOCATION", jobExec.getExitStatus());
            TestUtil.logMsg((String)"job completed");
        }
        catch (Exception e) {
            StepLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    public void testStepLevelPropertiesPropertyValue() throws EETest.Fault {
        String METHOD = "testStepLevelPropertiesPropertyValue";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("step_level_properties_value");
            TestUtil.logMsg((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            TestUtil.logMsg((String)"job completed");
            AssertionUtils.assertWithMessage("Property value", this.FOO_VALUE, jobExec.getExitStatus());
            TestUtil.logMsg((String)("Job batchlet return code is the step property foo value " + this.FOO_VALUE));
        }
        catch (Exception e) {
            StepLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    public void testStepLevelPropertiesShouldNotBeAvailableThroughJobContext() throws EETest.Fault {
        String METHOD = "testStepLevelPropertiesShouldNotBeAvailableThroughJobContext";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("step_level_properties_scope");
            TestUtil.logMsg((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            TestUtil.logMsg((String)"job completed");
            AssertionUtils.assertWithMessage("Step Level Property is not available through job context", BatchStatus.COMPLETED.name(), jobExec.getExitStatus());
            TestUtil.logMsg((String)("Job batchlet return code is the step.property read through job context (expected value=COMPLETED) " + jobExec.getExitStatus()));
        }
        catch (Exception e) {
            StepLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            this.jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            StepLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
    }

    public void beforeTest() throws ClassNotFoundException {
        this.jobOp = new JobOperatorBridge();
    }

    public void afterTest() {
        this.jobOp = null;
    }
}

