/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.identifiers;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.MappingTester;
import com.sun.ts.tests.jsonb.defaultmapping.identifiers.model.StringContainer;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.JsonbException;
import java.util.Properties;

public class NamesAndIdentifiersMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;

    public static void main(String[] args) {
        NamesAndIdentifiersMappingTest t = new NamesAndIdentifiersMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testSimpleMapping() throws EETest.Fault {
        return new MappingTester<String>(StringContainer.class).test("Test String", "\"Test String\"");
    }

    public Status testSimpleMappingNoCorrespondingIdentifierWithFailOnUnknownProperties() throws EETest.Fault {
        try {
            JsonbBuilder.create((JsonbConfig)new JsonbConfig().setProperty("jsonb.fail-on-unknown-properties", (Object)true)).fromJson("{ \"data\" : \"Test String\" }", StringContainer.class);
            throw new EETest.Fault("A JsonbException is expected if a Java identifier with corresponding name as in json document cannot be found.");
        }
        catch (JsonbException x) {
            return Status.passed((String)"OK");
        }
    }
}

