/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonreaderfactorytests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonReaderFactoryTest1() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader1 = null;
        JsonReader reader2 = null;
        JsonObject jsonObject = null;
        String jsonObjectText = "{\"foo\":\"bar\"}";
        try {
            this.logMsg("Create JsonReaderFactory with Map<String, ?> with EMPTY config");
            JsonReaderFactory readerFactory = Json.createReaderFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = readerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("--------------------------------------------------");
            this.logMsg("TEST CASE [JsonReaderFactory.createReader(Reader)]");
            this.logMsg("--------------------------------------------------");
            this.logMsg("Create 1st JsonReader using JsonReaderFactory");
            reader1 = readerFactory.createReader((Reader)new StringReader(jsonObjectText));
            if (reader1 == null) {
                this.logErr("ReaderFactory failed to create reader1");
                pass = false;
            } else {
                jsonObject = reader1.readObject();
                reader1.close();
                if (!JSONP_Util.assertEquals(jsonObject.size(), 1) || !JSONP_Util.assertEquals(jsonObject.getString("foo"), "bar")) {
                    pass = false;
                }
            }
            this.logMsg("Create 2nd JsonReader using JsonReaderFactory");
            reader2 = readerFactory.createReader((Reader)new StringReader(jsonObjectText));
            if (reader2 == null) {
                this.logErr("ReaderFactory failed to create reader2");
                pass = false;
            } else {
                jsonObject = reader2.readObject();
                reader2.close();
                if (!JSONP_Util.assertEquals(jsonObject.size(), 1) || !JSONP_Util.assertEquals(jsonObject.getString("foo"), "bar")) {
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonReaderFactoryTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonReaderFactoryTest1 Failed");
        }
    }

    public void jsonReaderFactoryTest2() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader1 = null;
        JsonReader reader2 = null;
        JsonObject jsonObject = null;
        String jsonObjectText = "{\"foo\":\"bar\"}";
        try {
            this.logMsg("Create JsonReaderFactory with Map<String, ?> with EMPTY config");
            JsonReaderFactory readerFactory = Json.createReaderFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = readerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("----------------------------------------------------------------");
            this.logMsg("TEST CASE [JsonReaderFactory.createReader(InputStream, Charset)]");
            this.logMsg("----------------------------------------------------------------");
            this.logMsg("Create 1st JsonReader using JsonReaderFactory with UTF-8 encoding");
            InputStream is1 = JSONP_Util.getInputStreamFromString(jsonObjectText);
            reader1 = readerFactory.createReader(is1, JSONP_Util.UTF_8);
            if (reader1 == null) {
                this.logErr("ReaderFactory failed to create reader1");
                pass = false;
            } else {
                jsonObject = reader1.readObject();
                reader1.close();
                if (!JSONP_Util.assertEquals(jsonObject.size(), 1) || !JSONP_Util.assertEquals(jsonObject.getString("foo"), "bar")) {
                    pass = false;
                }
            }
            this.logMsg("Create 2nd JsonReader using JsonReaderFactory with UTF-8 encoding");
            InputStream is2 = JSONP_Util.getInputStreamFromString(jsonObjectText);
            reader2 = readerFactory.createReader(is2, JSONP_Util.UTF_8);
            if (reader2 == null) {
                this.logErr("ReaderFactory failed to create reader2");
                pass = false;
            } else {
                jsonObject = reader2.readObject();
                reader2.close();
                if (!JSONP_Util.assertEquals(jsonObject.size(), 1) || !JSONP_Util.assertEquals(jsonObject.getString("foo"), "bar")) {
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonReaderFactoryTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonReaderFactoryTest2 Failed");
        }
    }

    public void jsonReaderFactoryTest3() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader1 = null;
        JsonReader reader2 = null;
        JsonObject jsonObject = null;
        String jsonObjectText = "{\"foo\":\"bar\"}";
        try {
            this.logMsg("Create JsonReaderFactory with Map<String, ?> with EMPTY config");
            JsonReaderFactory readerFactory = Json.createReaderFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = readerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("-------------------------------------------------------");
            this.logMsg("TEST CASE [JsonReaderFactory.createReader(InputStream)]");
            this.logMsg("-------------------------------------------------------");
            this.logMsg("Create 1st JsonReader using JsonReaderFactory");
            InputStream is1 = JSONP_Util.getInputStreamFromString(jsonObjectText);
            reader1 = readerFactory.createReader(is1);
            if (reader1 == null) {
                this.logErr("ReaderFactory failed to create reader1");
                pass = false;
            } else {
                jsonObject = reader1.readObject();
                reader1.close();
                if (!JSONP_Util.assertEquals(jsonObject.size(), 1) || !JSONP_Util.assertEquals(jsonObject.getString("foo"), "bar")) {
                    pass = false;
                }
            }
            this.logMsg("Create 2nd JsonReader using JsonReaderFactory");
            InputStream is2 = JSONP_Util.getInputStreamFromString(jsonObjectText);
            reader2 = readerFactory.createReader(is2);
            if (reader2 == null) {
                this.logErr("ReaderFactory failed to create reader2");
                pass = false;
            } else {
                jsonObject = reader2.readObject();
                reader2.close();
                if (!JSONP_Util.assertEquals(jsonObject.size(), 1) || !JSONP_Util.assertEquals(jsonObject.getString("foo"), "bar")) {
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonReaderFactoryTest3 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonReaderFactoryTest3 Failed");
        }
    }

    public void jsonReaderFactoryTest4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("----------------------------------------------");
            this.logMsg("Test scenario1: no supported provider property");
            this.logMsg("----------------------------------------------");
            this.logMsg("Create JsonReaderFactory with Map<String, ?> with EMPTY config");
            JsonReaderFactory readerFactory = Json.createReaderFactory(JSONP_Util.getEmptyConfig());
            Map config = readerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("-----------------------------------------------");
            this.logMsg("Test scenario2: non supported provider property");
            this.logMsg("-----------------------------------------------");
            this.logMsg("Create JsonReaderFactory with Map<String, ?> with FOO config");
            readerFactory = Json.createReaderFactory(JSONP_Util.getFooConfig());
            config = readerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonReaderFactoryTest4 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonReaderFactoryTest4 Failed");
        }
    }
}

