/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonarraytests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsonarraytests.ArrayBuildAdd;
import com.sun.ts.tests.jsonp.api.jsonarraytests.ArrayBuildRemove;
import com.sun.ts.tests.jsonp.api.jsonarraytests.ArrayBuildSet;
import com.sun.ts.tests.jsonp.api.jsonarraytests.ArrayBuilders;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonArrayTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            JsonArray myJsonArray;
            this.logMsg("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create the expected list of JsonArray values");
            ArrayList<JsonValue> expList = new ArrayList<JsonValue>();
            expList.add(JsonValue.FALSE);
            expList.add(JsonValue.TRUE);
            expList.add(JsonValue.NULL);
            expList.add((JsonValue)JSONP_Util.createJsonNumber(Double.MIN_VALUE));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(Double.MAX_VALUE));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(Integer.MIN_VALUE));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(Integer.MAX_VALUE));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(Long.MIN_VALUE));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(Long.MAX_VALUE));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(BigDecimal.valueOf(1.2345678912345679E8)));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(new BigInteger("123456789")));
            expList.add((JsonValue)JSONP_Util.createJsonString("string1"));
            expList.add((JsonValue)object);
            expList.add((JsonValue)array);
            JSONP_Util.dumpList(expList, "Expected List");
            this.logMsg("Create JsonArray using all JsonArrayBuilder API's");
            JsonArray actualList = myJsonArray = Json.createArrayBuilder().add(JsonValue.FALSE).add(JsonValue.TRUE).add(JsonValue.NULL).add(Double.MIN_VALUE).add(Double.MAX_VALUE).add(Integer.MIN_VALUE).add(Integer.MAX_VALUE).add(Long.MIN_VALUE).add(Long.MAX_VALUE).add(BigDecimal.valueOf(1.2345678912345679E8)).add(new BigInteger("123456789")).add("string1").add((JsonValue)object).add((JsonValue)array).build();
            JSONP_Util.dumpList((List<JsonValue>)actualList, "Actual List");
            this.logMsg("Compare actual list of JsonArray values with expected list of JsonArray values");
            pass = JSONP_Util.assertEqualsList(expList, (List<JsonValue>)actualList);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonArrayTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonArrayTest1 Failed");
        }
    }

    public void jsonArrayTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            JsonArray myJsonArray2;
            this.logMsg("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create JsonArray 'myJsonArray1' using all JsonArrayBuilder API's");
            JsonArray myJsonArray1 = Json.createArrayBuilder().add(JsonValue.FALSE).add(JsonValue.TRUE).add(JsonValue.NULL).add(Double.MIN_VALUE).add(Double.MAX_VALUE).add(Integer.MIN_VALUE).add(Integer.MAX_VALUE).add(Long.MIN_VALUE).add(Long.MAX_VALUE).add(BigDecimal.valueOf(1.2345678912345679E8)).add(new BigInteger("123456789")).add("string1").add((JsonValue)object).add((JsonValue)array).build();
            this.logMsg("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            StringWriter sw = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sw);){
                writer.writeArray(myJsonArray1);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String contents = sw.toString();
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + contents);
            this.logMsg("Read the JsonArray back into 'myJsonArray2' using a JsonReader");
            try (JsonReader reader = Json.createReader((Reader)new StringReader(contents));){
                myJsonArray2 = reader.readArray();
            }
            this.logMsg("Dump contents of JsonArray read from String Contents");
            JSONP_Util.dumpJsonValue((JsonValue)myJsonArray2);
            this.logMsg("Compare myJsonArray1 and myJsonArray2 for equality");
            pass = JSONP_Util.assertEqualsJsonArrays(myJsonArray1, myJsonArray2);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonArrayTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonArrayTest2 Failed");
        }
    }

    public void jsonArrayTest3() throws EETest.Fault {
        boolean pass = true;
        try {
            int i;
            this.logMsg("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            int[] expInt = new int[]{-1, 1, 1, -1000, 1000, 1000, -2000, 2000, 2000, Integer.MAX_VALUE, Integer.MIN_VALUE};
            long[] expLong = new long[]{Long.MAX_VALUE, Long.MIN_VALUE};
            double[] expDouble = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
            this.logMsg("Create myArray Jsonarray of 23 elements");
            JsonArray myArray = Json.createArrayBuilder().add(-1).add(1).add(1).add(-1000.0).add(1000.0).add(1000.0).add(-2000.0).add(2000.0).add(2000.0).add(Integer.MAX_VALUE).add(Integer.MIN_VALUE).add(Long.MAX_VALUE).add(Long.MIN_VALUE).add(Double.MAX_VALUE).add(Double.MIN_VALUE).add(BigDecimal.valueOf(1.2345678912345679E8)).add(new BigInteger("123456789")).add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").add((JsonValue)object).add((JsonValue)array).build();
            TestUtil.logMsg((String)("Array size=" + myArray.size()));
            boolean[] expectedIntTypes = new boolean[]{true, false};
            for (i = 0; i < 11; ++i) {
                this.logMsg("Checking getValue(" + i + ") for correctness");
                this.logMsg("Retrieve and verify (JsonValueType=NUMBER)");
                if (!JSONP_Util.assertEqualsJsonValueType(JsonValue.ValueType.NUMBER, myArray.getJsonNumber(i).getValueType())) {
                    pass = false;
                }
                this.logMsg("Retrieve and (expect JsonNumber NumberType be one of " + JSONP_Util.toStringJsonNumberTypes(expectedIntTypes) + ")");
                if (!JSONP_Util.assertEqualsJsonNumberTypes(expectedIntTypes, myArray.getJsonNumber(i).isIntegral())) {
                    pass = false;
                }
                this.logMsg("Retrieve and verify integer value via JsonNumber.intValue()");
                if (!JSONP_Util.assertEquals(expInt[i], myArray.getJsonNumber(i).intValue())) {
                    pass = false;
                }
                this.logMsg("Retrieve and verify integer value via JsonArray.getInt");
                if (!JSONP_Util.assertEquals(expInt[i], myArray.getInt(i))) {
                    pass = false;
                }
                this.logMsg("Retrieve and verify integer value via JsonNumber.intValueExact()");
                if (JSONP_Util.assertEquals(expInt[i], myArray.getJsonNumber(i).intValueExact())) continue;
                pass = false;
            }
            i = 11;
            int j = 0;
            while (i < 13) {
                this.logMsg("Checking getValue(" + i + ") for correctness");
                this.logMsg("Retrieve and verify (JsonValueType=NUMBER)");
                if (!JSONP_Util.assertEqualsJsonValueType(JsonValue.ValueType.NUMBER, myArray.getJsonNumber(i).getValueType())) {
                    pass = false;
                }
                this.logMsg("Retrieve and (expect JsonNumber NumberType be INTEGRAL)");
                if (!JSONP_Util.assertEqualsJsonNumberType(true, myArray.getJsonNumber(i).isIntegral())) {
                    pass = false;
                }
                this.logMsg("Retrieve and verify long value via JsonNumber.longValue()");
                if (!JSONP_Util.assertEquals(expLong[j], myArray.getJsonNumber(i).longValue())) {
                    pass = false;
                }
                this.logMsg("Retrieve and verify long value via JsonNumber.longValueExact()");
                if (!JSONP_Util.assertEquals(expLong[j], myArray.getJsonNumber(i).longValueExact())) {
                    pass = false;
                }
                ++i;
                ++j;
            }
            boolean[] expectedDoubleTypes = new boolean[]{true, false};
            int i2 = 13;
            int j2 = 0;
            while (i2 < 15) {
                this.logMsg("Checking getValue(" + i2 + ") for correctness");
                this.logMsg("Retrieve and verify (JsonValueType=NUMBER)");
                if (!JSONP_Util.assertEqualsJsonValueType(JsonValue.ValueType.NUMBER, myArray.getJsonNumber(i2).getValueType())) {
                    pass = false;
                }
                this.logMsg("Retrieve and (expect JsonNumber NumberType be one of " + JSONP_Util.toStringJsonNumberTypes(expectedDoubleTypes) + ")");
                if (!JSONP_Util.assertEqualsJsonNumberTypes(expectedDoubleTypes, myArray.getJsonNumber(i2).isIntegral())) {
                    pass = false;
                }
                this.logMsg("Retrieve and verify double value via JsonNumber.doubleValue()");
                if (!JSONP_Util.assertEquals(expDouble[j2], myArray.getJsonNumber(i2).doubleValue())) {
                    pass = false;
                }
                ++i2;
                ++j2;
            }
            this.logMsg("Checking getValue(15) for correctness");
            this.logMsg("Retrieve and verify (JsonValueType=NUMBER)");
            if (!JSONP_Util.assertEqualsJsonValueType(JsonValue.ValueType.NUMBER, myArray.getJsonNumber(15).getValueType())) {
                pass = false;
            }
            this.logMsg("Retrieve and (expect JsonNumber NumberType be one of " + JSONP_Util.toStringJsonNumberTypes(expectedDoubleTypes) + ")");
            if (!JSONP_Util.assertEqualsJsonNumberTypes(expectedDoubleTypes, myArray.getJsonNumber(15).isIntegral())) {
                pass = false;
            }
            this.logMsg("Retrieve and verify BigDecimal value via JsonNumber.bigDecimalValue()");
            if (!JSONP_Util.assertEquals(BigDecimal.valueOf(1.2345678912345679E8), myArray.getJsonNumber(15).bigDecimalValue())) {
                pass = false;
            }
            this.logMsg("Checking getValue(16) for correctness");
            this.logMsg("Retrieve and verify (JsonValueType=NUMBER)");
            if (!JSONP_Util.assertEqualsJsonValueType(JsonValue.ValueType.NUMBER, myArray.getJsonNumber(16).getValueType())) {
                pass = false;
            }
            this.logMsg("Retrieve and (expect JsonNumber NumberType be INTEGRAL)");
            if (!JSONP_Util.assertEqualsJsonNumberType(true, myArray.getJsonNumber(16).isIntegral())) {
                pass = false;
            }
            this.logMsg("Retrieve and verify BigInteger value via JsonNumber.bigIntegerValue()");
            if (!JSONP_Util.assertEquals(new BigInteger("123456789"), myArray.getJsonNumber(16).bigIntegerValue())) {
                pass = false;
            }
            this.logMsg("Retrieve and verify BigInteger value via JsonNumber.bigIntegerValueExact()");
            if (!JSONP_Util.assertEquals(new BigInteger("123456789"), myArray.getJsonNumber(16).bigIntegerValueExact())) {
                pass = false;
            }
            this.logMsg("Retrieve and verify true value via JsonArray.getBoolean(int)");
            if (!JSONP_Util.assertEquals(true, myArray.getBoolean(17))) {
                pass = false;
            }
            this.logMsg("Retrieve and verify false value via JsonArray.getBoolean(int)");
            if (!JSONP_Util.assertEquals(false, myArray.getBoolean(18))) {
                pass = false;
            }
            this.logMsg("Retrieve and verify null value via JsonArray.isNull(int)");
            if (!JSONP_Util.assertEquals(true, myArray.isNull(19))) {
                pass = false;
            }
            this.logMsg("Retrieve and verify non-null value via JsonArray.isNull(int)");
            if (!JSONP_Util.assertEquals(false, myArray.isNull(20))) {
                pass = false;
            }
            this.logMsg("Checking getValue(20) for correctness");
            this.logMsg("Retrieve and (expect JsonValueType=STRING)");
            if (!JSONP_Util.assertEqualsJsonValueType(JsonValue.ValueType.STRING, myArray.getJsonString(20).getValueType())) {
                pass = false;
            }
            this.logMsg("Retrieve and verify string value via JsonString.getString()");
            if (!JSONP_Util.assertEquals("!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", myArray.getJsonString(20).getString())) {
                pass = false;
            }
            this.logMsg("Retrieve and verify string value via JsonArray.getString()");
            if (!JSONP_Util.assertEquals("!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", myArray.getString(20))) {
                pass = false;
            }
            this.logMsg("Checking getJsonObject(21) for correctness");
            this.logMsg("Retrieve and (expect JsonValueType=OBJECT)");
            if (!JSONP_Util.assertEqualsJsonValueType(JsonValue.ValueType.OBJECT, myArray.getJsonObject(21).getValueType())) {
                pass = false;
            }
            this.logMsg("Retrieve and verify object value via JsonArray.getJsonObject(int)");
            if (!JSONP_Util.assertEqualsJsonObjects(object, myArray.getJsonObject(21))) {
                pass = false;
            }
            this.logMsg("Checking getJsonArray(22) for correctness");
            this.logMsg("Retrieve and (expect JsonValueType=ARRAY)");
            if (!JSONP_Util.assertEqualsJsonValueType(JsonValue.ValueType.ARRAY, myArray.getJsonArray(22).getValueType())) {
                pass = false;
            }
            this.logMsg("Retrieve and verify array value via JsonArray.getJsonArray(int)");
            if (!JSONP_Util.assertEqualsJsonArrays(array, myArray.getJsonArray(22))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(true, myArray.getBoolean(17))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(false, myArray.getBoolean(18))) {
                pass = false;
            }
            this.logMsg("Testing JsonArray.getBoolean(int, boolean) with/without default value setting.");
            if (!JSONP_Util.assertEquals(true, myArray.getBoolean(17, false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(false, myArray.getBoolean(0, false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(false, myArray.getBoolean(19, false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(false, myArray.getBoolean(20, false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(false, myArray.getBoolean(21, false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(false, myArray.getBoolean(22, false))) {
                pass = false;
            }
            this.logMsg("Testing JsonArray.getInt(int, int) with/without default value setting.");
            if (!JSONP_Util.assertEquals(-1, myArray.getInt(0, 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(10, myArray.getInt(17, 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(10, myArray.getInt(19, 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(10, myArray.getInt(20, 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(10, myArray.getInt(21, 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(10, myArray.getInt(22, 10))) {
                pass = false;
            }
            this.logMsg("Testing JsonArray.getString(int, String) with/without default value setting.");
            if (!JSONP_Util.assertEquals("!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", myArray.getString(20, "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals("foo", myArray.getString(17, "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals("foo", myArray.getString(19, "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals("foo", myArray.getString(2, "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals("foo", myArray.getString(21, "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals("foo", myArray.getString(22, "foo"))) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonArrayTest3 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonArrayTest3 Failed");
        }
    }

    public void jsonArrayTest4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            this.logMsg("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            StringWriter sw = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sw);){
                writer.writeArray(myJsonArray1);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String contents = sw.toString();
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + contents);
            this.logMsg("Remove whitespace from contents.");
            String actJsonText = JSONP_Util.removeWhitespace(contents);
            this.logMsg("Compare expected JsonArray text with actual JsonArray text for equality");
            pass = JSONP_Util.assertEqualsJsonText("[{\"name1\":\"value1\",\"name2\":\"value2\"},true,false,null,100,200,\"string\",123456789,123456789,{\"name3\":\"value3\",\"name4\":\"value4\"},true,false,null,[2,4],{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]]", actJsonText);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonArrayTest4 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonArrayTest4 Failed");
        }
    }

    public void jsonArrayGetValuesAsTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonArray of JsonNumber types for testing");
            JsonArray jsonArr = Json.createArrayBuilder().add(100).add(500).build();
            this.logMsg("Create the expected list of JsonArray values");
            ArrayList<JsonValue> expList = new ArrayList<JsonValue>();
            expList.add((JsonValue)JSONP_Util.createJsonNumber(100));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(500));
            JSONP_Util.dumpList(expList, "Expected List");
            this.logMsg("Create the JsonNumber list of JsonArray values");
            List numList = jsonArr.getValuesAs(JsonNumber.class);
            this.logMsg("Create the actual list of JsonArray values");
            ArrayList<JsonValue> actList = new ArrayList<JsonValue>();
            for (JsonNumber num : numList) {
                actList.add((JsonValue)num);
            }
            this.logMsg("Compare actual list with expected list for equality");
            pass = JSONP_Util.assertEqualsList(expList, actList);
            this.logMsg("Create sample JsonArray of JsonString types for testing");
            jsonArr = Json.createArrayBuilder().add("hello").add("world").build();
            this.logMsg("Create the list of JsonString values");
            List strList = jsonArr.getValuesAs(JsonString.class);
            this.logMsg("Comparing JsonString list elements to expected values.");
            if (!JSONP_Util.assertEquals(jsonArr.getString(0), ((JsonString)strList.get(0)).getString())) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(jsonArr.getString(1), ((JsonString)strList.get(1)).getString())) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonArrayGetValuesAsTest Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonArrayGetValuesAsTest Failed");
        }
    }

    public void jsonArrayExceptionTests() throws EETest.Fault {
        JsonArray array;
        String myString;
        JsonNumber myJsonValue;
        String value;
        JsonNumber value2;
        boolean pass = true;
        JsonObject testObject = null;
        JsonArray testArray = null;
        try {
            this.logMsg("Create sample JsonObject for testing");
            testObject = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create sample JsonArray for testing");
            testArray = JSONP_Util.createSampleJsonArray();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonObject to JsonNumber via getJsonNumber(int)");
            value2 = testArray.getJsonNumber(0);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonArray to JsonNumber via getJsonNumber(int)");
            value2 = testArray.getJsonNumber(15);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonNumber to JsonString via getJsonString(int)");
            value2 = testArray.getJsonString(4);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonString to JsonNumber via getJsonNumber(int)");
            value2 = testArray.getJsonNumber(6);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonValue.TRUE to JsonNumber via getJsonNumber(int)");
            value2 = testArray.getJsonNumber(1);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonObject to JsonArray via getJsonArray(int)");
            value2 = testArray.getJsonArray(0);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonArray to JsonObject via getJsonObject(int)");
            value2 = testArray.getJsonObject(15);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonObject to JsonNumber via getInt(int)");
            int value3 = testArray.getInt(0);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonObject to JsonString via getString(int)");
            value = testArray.getString(0);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonArray to JsonString via getString(int)");
            value = testArray.getString(15);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonObject to boolean via getBoolean(int)");
            boolean value4 = testArray.getBoolean(0);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonArray to boolean via getBoolean(int)");
            boolean value5 = testArray.getBoolean(13);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonString to boolean via getBoolean(int)");
            boolean value6 = testArray.getBoolean(6);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonNumber to boolean via getBoolean(int)");
            boolean value7 = testArray.getBoolean(4);
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing -1 as index to getJsonNumber(int)");
            int myInt = testArray.getJsonNumber(-1).intValue();
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing 10000 as index to getJsonNumber(int)");
            myJsonValue = testArray.getJsonNumber(10000);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing -1 as index to getJsonArray(int)");
            myJsonValue = testArray.getJsonArray(-1);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing 10000 as index to getJsonArray(int)");
            myJsonValue = testArray.getJsonArray(10000);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing -1 as index to getJsonObject(int)");
            myJsonValue = testArray.getJsonObject(-1);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing 10000 as index to getJsonObject(int)");
            myJsonValue = testArray.getJsonObject(10000);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing -1 as index to getJsonString(int)");
            myJsonValue = testArray.getJsonString(-1);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing 10000 as index to getJsonString(int)");
            myJsonValue = testArray.getJsonString(10000);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing -1 as index to getInt(int)");
            int myInt = testArray.getInt(-1);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing 10000 as index to getInt(int)");
            int myInt = testArray.getInt(10000);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing -1 as index to getString(int)");
            myString = testArray.getString(-1);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing 10000 as index to getString(int)");
            myString = testArray.getString(10000);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing -1 as index to getBoolean(int)");
            boolean myBoolean = testArray.getBoolean(-1);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing 10000 as index to getBoolean(int)");
            boolean myBoolean = testArray.getBoolean(10000);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing -1 as index to isNull(int)");
            boolean myBoolean = testArray.isNull(-1);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip IndexOutOfBoundsException passing 10000 as index to isNull(int)");
            boolean myBoolean = testArray.isNull(10000);
            pass = false;
            this.logErr("Failed to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            this.logMsg("Got expected IndexOutOfBoundsException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException calling add(Double.NaN)");
            array = Json.createArrayBuilder().add(Double.NaN).build();
            pass = false;
            this.logErr("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            this.logMsg("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException calling add(Double.NEGATIVE_INFINITY)");
            array = Json.createArrayBuilder().add(Double.NEGATIVE_INFINITY).build();
            pass = false;
            this.logErr("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            this.logMsg("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException calling add(Double.POSITIVE_INFINITY)");
            array = Json.createArrayBuilder().add(Double.POSITIVE_INFINITY).build();
            pass = false;
            this.logErr("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            this.logMsg("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ArithmeticException calling add(12345.12345) and attempting to extract as an exact integer value");
            array = Json.createArrayBuilder().add(12345.12345).build();
            this.logMsg("Call JsonArray.getJsonNumber(0).intValueExact()");
            int value8 = array.getJsonNumber(0).intValueExact();
            pass = false;
            this.logErr("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            this.logMsg("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ArithmeticException calling add(12345.12345) and attempting to extract as an exact long value");
            array = Json.createArrayBuilder().add(12345.12345).build();
            this.logMsg("Call JsonArray.getJsonNumber(0).longValueExact()");
            long value9 = array.getJsonNumber(0).longValueExact();
            pass = false;
            this.logErr("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            this.logMsg("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ArithmeticException calling add(12345.12345) and attempting to extract as an exact biginteger value");
            array = Json.createArrayBuilder().add(12345.12345).build();
            this.logMsg("Call JsonArray.getJsonNumber(0).bigIntegerValueExact()");
            BigInteger value10 = array.getJsonNumber(0).bigIntegerValueExact();
            pass = false;
            this.logErr("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            this.logMsg("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonArray.add(E) trying to modify JsonArray list which should be immutable");
            testArray.add((Object)JsonValue.FALSE);
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonArray.add(int,E) trying to modify JsonArray list which should be immutable");
            testArray.add(0, (Object)JsonValue.FALSE);
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonArray.addAll(C) trying to modify JsonArray list which should be immutable");
            testArray.addAll((Collection)testArray);
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonArray.addAll(int, C) trying to modify JsonArray list which should be immutable");
            testArray.addAll(0, (Collection)testArray);
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonArray.clear() trying to modify JsonArray list which should be immutable");
            testArray.clear();
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonArray.remove(int) trying to modify JsonArray list which should be immutable");
            testArray.remove(0);
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonArray.removeAll(C) trying to modify JsonArray list which should be immutable");
            testArray.removeAll((Collection)testArray);
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException trying to modify JsonArray list which should be immutable");
            testArray.remove((Object)JsonValue.TRUE);
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonArrayExceptionTests Failed");
        }
    }

    public void jsonArrayNullValueExceptionTests() throws EETest.Fault {
        boolean pass = true;
        JsonArrayBuilder jab = Json.createArrayBuilder();
        try {
            this.logMsg("Trip NullPointerException for JsonArrayBuilder.add(JsonValue) when JsonValue is null.");
            jab.add((JsonValue)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonArrayBuilder.add(BigInteger) when BigInteger is null.");
            jab.add((BigInteger)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonArrayBuilder.add(JsonArrayBuilder) when JsonArrayBuilder is null.");
            jab.add((JsonArrayBuilder)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonArrayBuilder.add(JsonObjectBuilder) when JsonObjectBuilder is null.");
            jab.add((JsonObjectBuilder)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonArrayBuilder.add(BigDecimal) when BigDecimal is null.");
            jab.add((BigDecimal)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonArrayBuilder.add(String) when String is null.");
            jab.add((String)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonArrayNullValueExceptionTests Failed");
        }
    }

    public void jsonCreateArrayBuilder11Test() throws EETest.Fault {
        ArrayBuilders createTest = new ArrayBuilders();
        TestResult result = createTest.test();
        result.eval();
    }

    public void jsonArrayBuilder11AddTest() throws EETest.Fault {
        ArrayBuildAdd addTest = new ArrayBuildAdd();
        TestResult result = addTest.test();
        result.eval();
    }

    public void jsonArrayBuilder11SetTest() throws EETest.Fault {
        ArrayBuildSet setTest = new ArrayBuildSet();
        TestResult result = setTest.test();
        result.eval();
    }

    public void jsonArrayBuilder11RemoveTest() throws EETest.Fault {
        ArrayBuildRemove removeTest = new ArrayBuildRemove();
        TestResult result = removeTest.test();
        result.eval();
    }
}

