/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.mergetests;

import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonValue;

public abstract class MergeCommon {
    private static final String MERGE_STR = "MERGE";
    private static final String DIFF_STR = "DIFF";
    private static final String TEST_FAIL_PATCH = "Patch ";
    private static final String TEST_FAIL_ON = " failed on ";
    private static final String TEST_FAIL_VAL = " value";
    private static final String TEST_FAIL_FROM = "Diff from ";
    private static final String TEST_FAIL_TO = " to ";
    private static final String TEST_FAIL_FAIL = " failed";

    protected boolean operationFailed(JsonValue check, JsonValue out, String message) {
        return out == null || !JsonAssert.assertEquals(check, out, message);
    }

    protected void simpleMerge(TestResult result, JsonValue in, JsonValue patch, JsonValue check) {
        JsonValue out = Json.createMergePatch((JsonValue)patch).apply(in);
        if (this.operationFailed(check, out, "MERGE mismatch")) {
            String targetClassName = in.getValueType().name().toLowerCase();
            result.fail(this.testName(MERGE_STR, targetClassName), this.testMergeMessage(JsonAssert.valueToString(in), JsonAssert.valueToString(patch)));
        }
    }

    protected void simpleDiff(TestResult result, JsonValue src, JsonValue target, JsonValue diff) {
        JsonValue out = Json.createMergeDiff((JsonValue)src, (JsonValue)target).toJsonValue();
        if (this.operationFailed(diff, out, "DIFF mismatch")) {
            String srcClassName = src.getValueType().name().toLowerCase();
            String targetClassName = target.getValueType().name().toLowerCase();
            result.fail(this.testName(DIFF_STR, srcClassName, targetClassName), this.testDiffMessage(JsonAssert.valueToString(src), JsonAssert.valueToString(target)));
        }
    }

    protected String testName(String operation, String targetType) {
        StringBuilder sb = new StringBuilder(operation.length() + targetType.length() + 1);
        sb.append(operation);
        sb.append(' ');
        sb.append(targetType);
        return sb.toString();
    }

    protected String testName(String operation, String srcType, String targetType) {
        StringBuilder sb = new StringBuilder(operation.length() + srcType.length() + targetType.length() + 2);
        sb.append(operation);
        sb.append(' ');
        sb.append(srcType);
        sb.append(',');
        sb.append(targetType);
        return sb.toString();
    }

    protected String testMergeMessage(String in, String patch) {
        StringBuilder sb = new StringBuilder(TEST_FAIL_PATCH.length() + TEST_FAIL_ON.length() + TEST_FAIL_VAL.length() + patch.length() + in.length());
        sb.append(TEST_FAIL_PATCH);
        sb.append(patch);
        sb.append(TEST_FAIL_ON);
        sb.append(in);
        sb.append(TEST_FAIL_VAL);
        return sb.toString();
    }

    protected String testDiffMessage(String src, String target) {
        StringBuilder sb = new StringBuilder(TEST_FAIL_FROM.length() + TEST_FAIL_TO.length() + TEST_FAIL_FAIL.length() + src.length() + target.length());
        sb.append(TEST_FAIL_FROM);
        sb.append(src);
        sb.append(TEST_FAIL_TO);
        sb.append(target);
        sb.append(TEST_FAIL_FAIL);
        return sb.toString();
    }
}

