/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.api.jsonb;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.api.model.SimpleContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class JsonbTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        JsonbTest t = new JsonbTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testFromJsonStringClass() throws EETest.Fault {
        SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", SimpleContainer.class);
        if (!"Test String".equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to unmarshal using Jsonb.fromJson method with String and Class arguments.");
        }
        return Status.passed((String)"OK");
    }

    public Status testFromJsonStringType() throws EETest.Fault {
        SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", new SimpleContainer(){}.getClass().getGenericSuperclass());
        if (!"Test String".equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to unmarshal using Jsonb.fromJson method with String and Type arguments.");
        }
        return Status.passed((String)"OK");
    }

    public Status testFromJsonReaderClass() throws EETest.Fault {
        try (ByteArrayInputStream stream = new ByteArrayInputStream("{ \"instance\" : \"Test String\" }".getBytes(StandardCharsets.UTF_8));
             InputStreamReader reader = new InputStreamReader(stream);){
            SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson((Reader)reader, SimpleContainer.class);
            if (!"Test String".equals(unmarshalledObject.getInstance())) {
                throw new EETest.Fault("Failed to unmarshal using Jsonb.fromJson method with Reader and Class arguments.");
            }
        }
        catch (IOException e) {
            throw new EETest.Fault(e);
        }
        return Status.passed((String)"OK");
    }

    public Status testFromJsonReaderType() throws EETest.Fault {
        try (ByteArrayInputStream stream = new ByteArrayInputStream("{ \"instance\" : \"Test String\" }".getBytes(StandardCharsets.UTF_8));
             InputStreamReader reader = new InputStreamReader(stream);){
            SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson((Reader)reader, new SimpleContainer(){}.getClass().getGenericSuperclass());
            if (!"Test String".equals(unmarshalledObject.getInstance())) {
                throw new EETest.Fault("Failed to unmarshal using Jsonb.fromJson method with Reader and Type arguments.");
            }
        }
        catch (IOException e) {
            throw new EETest.Fault(e);
        }
        return Status.passed((String)"OK");
    }

    public Status testFromJsonStreamClass() throws EETest.Fault {
        try (ByteArrayInputStream stream = new ByteArrayInputStream("{ \"instance\" : \"Test String\" }".getBytes(StandardCharsets.UTF_8));){
            SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson((InputStream)stream, SimpleContainer.class);
            if (!"Test String".equals(unmarshalledObject.getInstance())) {
                throw new EETest.Fault("Failed to unmarshal using Jsonb.fromJson method with InputStream and Class arguments.");
            }
        }
        catch (IOException e) {
            throw new EETest.Fault(e);
        }
        return Status.passed((String)"OK");
    }

    public Status testFromJsonStreamType() throws EETest.Fault {
        try (ByteArrayInputStream stream = new ByteArrayInputStream("{ \"instance\" : \"Test String\" }".getBytes(StandardCharsets.UTF_8));){
            SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson((InputStream)stream, new SimpleContainer(){}.getClass().getGenericSuperclass());
            if (!"Test String".equals(unmarshalledObject.getInstance())) {
                throw new EETest.Fault("Failed to unmarshal using Jsonb.fromJson method with InputStream and Type arguments.");
            }
        }
        catch (IOException e) {
            throw new EETest.Fault(e);
        }
        return Status.passed((String)"OK");
    }

    public Status testToJsonObject() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new SimpleContainer());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test\"\\s*}")) {
            throw new EETest.Fault("Failed to marshal using Jsonb.toJson method with Object argument.");
        }
        return Status.passed((String)"OK");
    }

    public Status testToJsonObjectType() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new SimpleContainer(), new SimpleContainer(){}.getClass().getGenericSuperclass());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test\"\\s*}")) {
            throw new EETest.Fault("Failed to marshal using Jsonb.toJson method with Object and Type arguments.");
        }
        return Status.passed((String)"OK");
    }

    public Status testToJsonObjectWriter() throws EETest.Fault {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(stream);){
            this.jsonb.toJson((Object)new SimpleContainer(), (Writer)writer);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test\"\\s*}")) {
                throw new EETest.Fault("Failed to marshal using Jsonb.toJson method with Object and Writer arguments.");
            }
        }
        catch (IOException e) {
            throw new EETest.Fault(e);
        }
        return Status.passed((String)"OK");
    }

    public Status testToJsonObjectTypeWriter() throws EETest.Fault {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(stream);){
            this.jsonb.toJson((Object)new SimpleContainer(), new SimpleContainer(){}.getClass().getGenericSuperclass(), (Writer)writer);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test\"\\s*}")) {
                throw new EETest.Fault("Failed to marshal using Jsonb.toJson method with Object, Type and Writer arguments.");
            }
        }
        catch (IOException e) {
            throw new EETest.Fault(e);
        }
        return Status.passed((String)"OK");
    }

    public Status testToJsonObjectStream() throws EETest.Fault {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson((Object)new SimpleContainer(), (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test\"\\s*}")) {
                throw new EETest.Fault("Failed to marshal using Jsonb.toJson method with Object and OutputStream arguments.");
            }
        }
        catch (IOException e) {
            throw new EETest.Fault(e);
        }
        return Status.passed((String)"OK");
    }

    public Status testToJsonObjectTypeStream() throws EETest.Fault {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson((Object)new SimpleContainer(), new SimpleContainer(){}.getClass().getGenericSuperclass(), (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test\"\\s*}")) {
                throw new EETest.Fault("Failed to marshal using Jsonb.toJson method with Object, Type and OutputStream arguments.");
            }
        }
        catch (IOException e) {
            throw new EETest.Fault(e);
        }
        return Status.passed((String)"OK");
    }
}

