/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.ra.common.messaging;

import com.sun.ts.tests.jms.ee20.ra.common.messaging.Constants;
import com.sun.ts.tests.jms.ee20.ra.common.messaging.TLogger;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;

public class StatusReporter
implements Constants {
    private static StatusReporter reporter = new StatusReporter();

    private static StatusReporter getInstance() {
        return reporter;
    }

    public static void report(String testname, boolean result, String reason, QueueConnectionFactory qFactory, Queue replyQueue) {
        StatusReporter reporter = StatusReporter.getInstance();
        reporter.report0(testname, result, reason, qFactory, replyQueue);
    }

    public static void report(String testname, boolean result, QueueConnectionFactory qFactory, Queue queueR) {
        StatusReporter.report(testname, result, null, qFactory, queueR);
    }

    private void report0(String testname, boolean result, String reason, QueueConnectionFactory qFactory, Queue queueR) {
        QueueConnection qConnection = null;
        QueueSession qSession = null;
        try {
            qConnection = qFactory.createQueueConnection();
            qSession = qConnection.createQueueSession(false, 1);
            StatusReporter.sendTestResults(testname, result, reason, qSession, queueR);
        }
        catch (JMSException e) {
            String description = null;
            description = result ? "The test " + testname + " passed in the bean." : "The test " + testname + " failed in the bean: " + reason;
            throw new IllegalStateException(description + " Failed to create connection/session in StatusReporter:", e);
        }
        finally {
            if (qConnection != null) {
                try {
                    qConnection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void sendTestResults(String testCase, boolean results, String reason, QueueSession qSession, Queue queueR) {
        TextMessage msg = null;
        QueueSender mSender = null;
        try {
            mSender = qSession.createSender(queueR);
            msg = qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            mSender.send((Message)msg);
            TLogger.log("Status message (" + results + ") sent for test " + testCase + ". Reason:" + reason);
        }
        catch (JMSException e) {
            TLogger.log("Failed to send back status:", e);
        }
        catch (Exception e) {
            TLogger.log("Failed to send back status:", e);
        }
    }
}

