/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.lob;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.lob.DataTypes;
import java.util.Arrays;
import java.util.Properties;

public class Client
extends PMClientBase {
    private DataTypes dataTypes;
    private Byte[] smallByteArray = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lobTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        Object[] largeByteArray = null;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"FIND DataTypes and verify initial value");
            this.dataTypes = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.dataTypes && Arrays.equals((Object[])this.smallByteArray, (Object[])this.dataTypes.getByteArrayData())) {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
                TestUtil.logTrace((String)"DataType Entity is not null, setting byteData ");
                largeByteArray = this.createLargeByteArray();
                this.dataTypes.setByteArrayData((Byte[])largeByteArray);
                this.getEntityManager().merge((Object)this.dataTypes);
                this.getEntityManager().flush();
                TestUtil.logMsg((String)"FIND DataTypes again and verify updated value");
                this.dataTypes = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
                TestUtil.logTrace((String)"Check results");
                if (null != this.dataTypes && Arrays.equals(largeByteArray, (Object[])this.dataTypes.getByteArrayData())) {
                    TestUtil.logTrace((String)"Expected results received");
                    pass2 = true;
                } else {
                    TestUtil.logErr((String)"Unexpected result in array comparison.");
                }
            } else {
                TestUtil.logErr((String)"Unexpected result in array comparison.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("lobTest failed");
        }
    }

    public void createTestData() {
        TestUtil.logTrace((String)"createTestData");
        try {
            this.getEntityTransaction().begin();
            this.smallByteArray = this.createSmallByteArray();
            this.dataTypes = new DataTypes(1, this.smallByteArray);
            this.getEntityManager().persist((Object)this.dataTypes);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    private Byte[] createSmallByteArray() {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < 1024; ++i) {
            strbuf.append(i);
        }
        String value = strbuf.toString();
        System.out.println("String Buffer :" + value);
        byte[] myByte = value.getBytes();
        Byte[] convertedByte = new Byte[myByte.length];
        for (int i = 0; i < myByte.length; ++i) {
            convertedByte[i] = myByte[i];
        }
        return convertedByte;
    }

    private Byte[] createLargeByteArray() {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < 4096; ++i) {
            strbuf.append(i);
        }
        String value = strbuf.toString();
        System.out.println("String Buffer :" + value);
        byte[] myByte = value.getBytes();
        Byte[] convertedByte = new Byte[myByte.length];
        for (int i = 0; i < myByte.length; ++i) {
            convertedByte[i] = myByte[i];
        }
        return convertedByte;
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

