/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.override.embeddable;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.override.embeddable.Applicant;
import com.sun.ts.tests.jpa.core.override.embeddable.Book;
import com.sun.ts.tests.jpa.core.override.embeddable.BookStore;
import com.sun.ts.tests.jpa.core.override.embeddable.Complaint;
import com.sun.ts.tests.jpa.core.override.embeddable.Film;
import com.sun.ts.tests.jpa.core.override.embeddable.MovieTicket;
import com.sun.ts.tests.jpa.core.override.embeddable.Publisher;
import com.sun.ts.tests.jpa.core.override.embeddable.Publisher1;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final Integer BOOKSTORE_ID = 12345;
    private static final String PUBLISHER_NAME = "Sun";
    private static final String PUBLISHER_LOCATION = "Santa Clara";
    private static final int COMPLAINT_NUMBER = 24680;
    private static final String APPLICANT_NAME = "Sunny";
    private static final String APPLICANT_ADDRESS = "Menlo Park";
    private static final Integer COMPLAINT_ID = 9;
    private static final Integer MOVIETICKET_ID = 6;
    private static final String FILM_CODE = "007";
    private static final String FILM_NAME = "Network is Computer";
    private static final Integer BOOK_ID = 5;
    private static final String PUBLISHER1_NAME = "Penguin";
    private static final String PUBLISHER1_STATE = "California";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception:test failed ", (Throwable)e);
        }
    }

    public void testOverrideTransient() throws EETest.Fault {
        block7: {
            this.getEntityTransaction().begin();
            Publisher publisher = new Publisher();
            publisher.setName(PUBLISHER_NAME);
            publisher.setLocation(PUBLISHER_LOCATION);
            BookStore bookstore = new BookStore();
            bookstore.setId(BOOKSTORE_ID);
            bookstore.setPublisher(publisher);
            this.getEntityManager().persist((Object)bookstore);
            this.getEntityManager().flush();
            try {
                BookStore retrieveBook = (BookStore)this.getEntityManager().find(BookStore.class, (Object)BOOKSTORE_ID);
                retrieveBook.setPublisher(new Publisher());
                this.getEntityManager().refresh((Object)retrieveBook);
                Publisher retrievePublisher = retrieveBook.getPublisher();
                if (retrievePublisher.getName().equals(PUBLISHER_NAME)) {
                    if (retrievePublisher.getLocation() == null) {
                        TestUtil.logTrace((String)"Test Passed");
                        break block7;
                    }
                    throw new EETest.Fault("The Location fields was expected to be empty, expected Length - null, actual - " + retrievePublisher.getLocation());
                }
                throw new EETest.Fault("Incorrect BookStore object obtained from the database");
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testOverrideTransient" + e);
            }
            finally {
                this.getEntityManager().remove((Object)bookstore);
                this.getEntityTransaction().commit();
            }
        }
    }

    public void testOverrideEmbeddable() throws EETest.Fault {
        block6: {
            this.getEntityTransaction().begin();
            Applicant applicant = new Applicant();
            applicant.setName(APPLICANT_NAME);
            applicant.setAddress(APPLICANT_ADDRESS);
            Complaint complaint = new Complaint();
            complaint.setId(COMPLAINT_ID);
            complaint.setComplaintNumber(24680);
            complaint.setApplicant(applicant);
            this.getEntityManager().persist((Object)complaint);
            this.getEntityManager().flush();
            try {
                Complaint retrieveComplaint = (Complaint)this.getEntityManager().find(Complaint.class, (Object)COMPLAINT_ID);
                Applicant retrieveApplicant = retrieveComplaint.getApplicant();
                if (retrieveComplaint.getComplaintNumber() == 24680 && retrieveApplicant.getName().equals(APPLICANT_NAME) && retrieveApplicant.getAddress().equals(APPLICANT_ADDRESS)) {
                    TestUtil.logTrace((String)"Test Passed");
                    break block6;
                }
                throw new EETest.Fault("Expected Complaint Number COMPLAINT_NUMBER to be retrieved; complaint in DB - " + retrieveComplaint.getComplaintNumber());
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testOverrideEmbeddable" + e);
            }
            finally {
                this.getEntityManager().remove((Object)complaint);
                this.getEntityTransaction().commit();
            }
        }
    }

    public void testOverrideEmbedded() throws EETest.Fault {
        block6: {
            this.getEntityTransaction().begin();
            Film film = new Film();
            film.setFilmCode(FILM_CODE);
            film.setFilmName(FILM_NAME);
            MovieTicket ticket = new MovieTicket();
            ticket.setId(MOVIETICKET_ID);
            ticket.setFilm(film);
            this.getEntityManager().persist((Object)ticket);
            this.getEntityManager().flush();
            try {
                MovieTicket retrieveTicket = (MovieTicket)this.getEntityManager().find(MovieTicket.class, (Object)MOVIETICKET_ID);
                Film retrieveFilm = retrieveTicket.getFilm();
                if (retrieveFilm.getFilmName().equals(FILM_NAME) && retrieveFilm.getFilmCode().equals(FILM_CODE)) {
                    TestUtil.logTrace((String)"Test Passed");
                    break block6;
                }
                throw new EETest.Fault("Expected MovieTicket(FILM_NAME) to be retrieved; film in DB - " + retrieveFilm.getFilmName());
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testOverrideEmbedded" + e);
            }
            finally {
                this.getEntityManager().remove((Object)ticket);
                this.getEntityTransaction().commit();
            }
        }
    }

    public void testMetadataCompleteness() throws EETest.Fault {
        block6: {
            this.getEntityTransaction().begin();
            Book book = new Book();
            Publisher1 publisher1 = new Publisher1();
            book.setId(BOOK_ID);
            publisher1.setName(PUBLISHER1_NAME);
            publisher1.setState(PUBLISHER1_STATE);
            book.setPublisher1(publisher1);
            this.getEntityManager().persist((Object)book);
            this.getEntityManager().flush();
            try {
                Book retrieveBook = (Book)this.getEntityManager().find(Book.class, (Object)BOOK_ID);
                retrieveBook.setPublisher1(new Publisher1());
                this.getEntityManager().refresh((Object)retrieveBook);
                Publisher1 retrievePublisher1 = retrieveBook.getPublisher1();
                if (retrievePublisher1.getName().equals(PUBLISHER1_NAME) && retrievePublisher1.getState().equals(PUBLISHER1_STATE)) {
                    TestUtil.logTrace((String)"Test Passed");
                    break block6;
                }
                throw new EETest.Fault("Publisher1's name and state were not persisted as expected -- metadata-complete=true is not read from orm.xml");
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testMetadataCompleteness" + e);
            }
            finally {
                this.getEntityManager().remove((Object)book);
                this.getEntityTransaction().commit();
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BOOK").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM COMPLAINT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM MOVIETICKET").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BOOKSTORE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

