/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.FormChild;
import org.xml.sax.helpers.AttributesImpl;

@JsxClass(domClass=HtmlOption.class)
public class HTMLOptionElement
extends FormChild {
    @JsxConstructor
    public void jsConstructor(String newText, String newValue, boolean defaultSelected, boolean selected) {
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        AttributesImpl attributes = null;
        if (defaultSelected) {
            attributes = new AttributesImpl();
            attributes.addAttribute(null, "selected", "selected", null, "selected");
        }
        HtmlOption htmlOption = (HtmlOption)HTMLParser.getFactory("option").createElement(page, "option", attributes);
        htmlOption.setSelected(selected);
        this.setDomNode(htmlOption);
        if (!"undefined".equals(newText)) {
            htmlOption.appendChild(new DomText(page, newText));
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OPTION_CONSTRUCTOR_IGNORES_LABEL)) {
                htmlOption.setLabelAttribute(newText);
            }
        }
        if (!"undefined".equals(newValue)) {
            htmlOption.setValueAttribute(newValue);
        }
    }

    @JsxGetter
    public String getValue() {
        String value = this.getDomNodeOrNull().getAttribute("value");
        if (value == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OPTION_USE_TEXT_AS_VALUE_IF_NOT_DEFINED)) {
            value = this.getDomNodeOrNull().getText();
        }
        return value;
    }

    @JsxSetter
    public void setValue(String newValue) {
        this.getDomNodeOrNull().setValueAttribute(newValue);
    }

    @Override
    @JsxGetter
    public String getText() {
        return this.getDomNodeOrNull().getText();
    }

    @Override
    public HtmlOption getDomNodeOrNull() {
        return (HtmlOption)super.getDomNodeOrNull();
    }

    @JsxSetter
    public void setText(String newText) {
        this.getDomNodeOrNull().setText(newText);
    }

    @JsxGetter
    public boolean getSelected() {
        return this.getDomNodeOrNull().isSelected();
    }

    @JsxSetter
    public void setSelected(boolean selected) {
        HtmlOption optionNode = this.getDomNodeOrNull();
        HtmlSelect enclosingSelect = optionNode.getEnclosingSelect();
        if (!selected && optionNode.isSelected() && enclosingSelect != null && !enclosingSelect.isMultipleSelectEnabled()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLOPTION_UNSELECT_SELECTS_FIRST)) {
                enclosingSelect.getOption(0).setSelected(true, false);
            }
        } else {
            optionNode.setSelected(selected, false);
        }
    }

    @JsxGetter
    public boolean getDefaultSelected() {
        return this.getDomNodeOrNull().isDefaultSelected();
    }

    @JsxGetter
    public String getLabel() {
        return this.getDomNodeOrNull().getLabelAttribute();
    }

    @JsxSetter
    public void setLabel(String label) {
        this.getDomNodeOrNull().setLabelAttribute(label);
    }

    @Override
    @JsxGetter
    public boolean getDisabled() {
        return super.getDisabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }
}

