/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Debug;
import java.util.Arrays;

final class ProxySearchResultListener
implements SearchResultListener {
    private static final long serialVersionUID = -1581507251328572490L;
    private final int messageID;
    private final LDAPListenerClientConnection clientConnection;

    ProxySearchResultListener(LDAPListenerClientConnection clientConnection, int messageID) {
        this.clientConnection = clientConnection;
        this.messageID = messageID;
    }

    @Override
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        try {
            this.clientConnection.sendSearchResultEntry(this.messageID, searchEntry, searchEntry.getControls());
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    @Override
    public void searchReferenceReturned(SearchResultReference searchReference) {
        try {
            SearchResultReferenceProtocolOp searchResultReferenceProtocolOp = new SearchResultReferenceProtocolOp(Arrays.asList(searchReference.getReferralURLs()));
            this.clientConnection.sendSearchResultReference(this.messageID, searchResultReferenceProtocolOp, searchReference.getControls());
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }
}

