/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum DisconnectType {
    UNBIND(LDAPMessages.INFO_DISCONNECT_TYPE_UNBIND.get(), ResultCode.LOCAL_ERROR),
    BIND_FAILED(LDAPMessages.INFO_DISCONNECT_TYPE_BIND_FAILED.get(), ResultCode.CONNECT_ERROR),
    RECONNECT(LDAPMessages.INFO_DISCONNECT_TYPE_RECONNECT.get(), ResultCode.SERVER_DOWN),
    REFERRAL(LDAPMessages.INFO_DISCONNECT_TYPE_REFERRAL.get(), ResultCode.LOCAL_ERROR),
    SERVER_CLOSED_WITH_NOTICE(LDAPMessages.INFO_DISCONNECT_TYPE_SERVER_CLOSED_WITH_NOTICE.get(), ResultCode.SERVER_DOWN),
    SERVER_CLOSED_WITHOUT_NOTICE(LDAPMessages.INFO_DISCONNECT_TYPE_SERVER_CLOSED_WITHOUT_NOTICE.get(), ResultCode.SERVER_DOWN),
    IO_ERROR(LDAPMessages.INFO_DISCONNECT_TYPE_IO_ERROR.get(), ResultCode.SERVER_DOWN),
    DECODE_ERROR(LDAPMessages.INFO_DISCONNECT_TYPE_DECODE_ERROR.get(), ResultCode.DECODING_ERROR),
    LOCAL_ERROR(LDAPMessages.INFO_DISCONNECT_TYPE_LOCAL_ERROR.get(), ResultCode.LOCAL_ERROR),
    SECURITY_PROBLEM(LDAPMessages.INFO_DISCONNECT_TYPE_SECURITY_PROBLEM.get(), ResultCode.LOCAL_ERROR),
    POOL_CLOSED(LDAPMessages.INFO_DISCONNECT_TYPE_POOL_CLOSED.get(), ResultCode.LOCAL_ERROR),
    POOL_CREATION_FAILURE(LDAPMessages.INFO_DISCONNECT_TYPE_POOL_CREATION_FAILURE.get(), ResultCode.CONNECT_ERROR),
    POOLED_CONNECTION_DEFUNCT(LDAPMessages.INFO_DISCONNECT_TYPE_POOLED_CONNECTION_DEFUNCT.get(), ResultCode.SERVER_DOWN),
    POOLED_CONNECTION_EXPIRED(LDAPMessages.INFO_DISCONNECT_TYPE_POOLED_CONNECTION_EXPIRED.get(), ResultCode.LOCAL_ERROR),
    POOLED_CONNECTION_UNNEEDED(LDAPMessages.INFO_DISCONNECT_TYPE_POOLED_CONNECTION_UNNEEDED.get(), ResultCode.LOCAL_ERROR),
    UNKNOWN(LDAPMessages.INFO_DISCONNECT_TYPE_UNKNOWN.get(), ResultCode.LOCAL_ERROR),
    CLOSED_BY_FINALIZER(LDAPMessages.INFO_DISCONNECT_TYPE_CLOSED_BY_FINALIZER.get(), ResultCode.LOCAL_ERROR),
    OTHER(LDAPMessages.INFO_DISCONNECT_TYPE_OTHER.get(), ResultCode.LOCAL_ERROR);

    private final ResultCode resultCode;
    private final String description;

    private DisconnectType(String description, ResultCode resultCode) {
        this.description = description;
        this.resultCode = resultCode;
    }

    public String getDescription() {
        return this.description;
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public static DisconnectType forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        if (lowerName.equals("unbind")) {
            return UNBIND;
        }
        if (lowerName.equals("bind_failed")) {
            return BIND_FAILED;
        }
        if (lowerName.equals("reconnect")) {
            return RECONNECT;
        }
        if (lowerName.equals("referral")) {
            return REFERRAL;
        }
        if (lowerName.equals("server_closed_with_notice")) {
            return SERVER_CLOSED_WITH_NOTICE;
        }
        if (lowerName.equals("server_closed_without_notice")) {
            return SERVER_CLOSED_WITHOUT_NOTICE;
        }
        if (lowerName.equals("io_error")) {
            return IO_ERROR;
        }
        if (lowerName.equals("decode_error")) {
            return DECODE_ERROR;
        }
        if (lowerName.equals("local_error")) {
            return LOCAL_ERROR;
        }
        if (lowerName.equals("security_problem")) {
            return SECURITY_PROBLEM;
        }
        if (lowerName.equals("pool_closed")) {
            return POOL_CLOSED;
        }
        if (lowerName.equals("pool_creation_failure")) {
            return POOL_CREATION_FAILURE;
        }
        if (lowerName.equals("pooled_connection_defunct")) {
            return POOLED_CONNECTION_DEFUNCT;
        }
        if (lowerName.equals("pooled_connection_expired")) {
            return POOLED_CONNECTION_EXPIRED;
        }
        if (lowerName.equals("pooled_connection_unneeded")) {
            return POOLED_CONNECTION_UNNEEDED;
        }
        if (lowerName.equals("unknown")) {
            return UNKNOWN;
        }
        if (lowerName.equals("closed_by_finalizer")) {
            return CLOSED_BY_FINALIZER;
        }
        if (lowerName.equals("other")) {
            return OTHER;
        }
        return null;
    }

    public static boolean isExpected(DisconnectType disconnectType) {
        switch (disconnectType) {
            case UNBIND: 
            case RECONNECT: 
            case REFERRAL: 
            case POOL_CLOSED: 
            case POOLED_CONNECTION_DEFUNCT: 
            case POOLED_CONNECTION_EXPIRED: 
            case POOLED_CONNECTION_UNNEEDED: 
            case CLOSED_BY_FINALIZER: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("DisconnectType(name='");
        buffer.append(this.name());
        buffer.append("', resultCode='");
        buffer.append(this.resultCode);
        buffer.append("', description='");
        buffer.append(this.description);
        buffer.append("')");
    }
}

