/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FixedRateBarrier
implements Serializable {
    private static final long serialVersionUID = -3490156685189909611L;
    private static final long minSleepMillis;
    private volatile boolean shutdownRequested = false;
    private long intervalDurationNanos;
    private double millisBetweenIterations;
    private int perInterval;
    private long countInThisInterval;
    private long intervalStartNanos;
    private long intervalEndNanos;

    public FixedRateBarrier(long intervalDurationMs, int perInterval) {
        this.setRate(intervalDurationMs, perInterval);
    }

    public synchronized void setRate(long intervalDurationMs, int perInterval) {
        Validator.ensureTrue(intervalDurationMs > 0L, "FixedRateBarrier.intervalDurationMs must be at least 1.");
        Validator.ensureTrue(perInterval > 0, "FixedRateBarrier.perInterval must be at least 1.");
        this.perInterval = perInterval;
        this.intervalDurationNanos = 1000000L * intervalDurationMs;
        this.millisBetweenIterations = (double)intervalDurationMs / (double)perInterval;
        this.countInThisInterval = 0L;
        this.intervalStartNanos = 0L;
        this.intervalEndNanos = 0L;
    }

    public synchronized boolean await() {
        while (!this.shutdownRequested) {
            long intervalRemaining;
            long now = System.nanoTime();
            if (this.intervalStartNanos == 0L || now < this.intervalStartNanos) {
                this.intervalStartNanos = now;
                this.intervalEndNanos = this.intervalStartNanos + this.intervalDurationNanos;
            } else if (now >= this.intervalEndNanos) {
                this.countInThisInterval = 0L;
                this.intervalStartNanos = now < this.intervalEndNanos + this.intervalDurationNanos ? now : this.intervalEndNanos;
                this.intervalEndNanos = this.intervalStartNanos + this.intervalDurationNanos;
            }
            if ((intervalRemaining = this.intervalEndNanos - now) <= 0L) continue;
            long actualRemaining = (long)this.perInterval - this.countInThisInterval;
            double intervalFractionRemaining = (double)intervalRemaining / (double)this.intervalDurationNanos;
            double expectedRemaining = intervalFractionRemaining * (double)this.perInterval;
            if ((double)actualRemaining >= expectedRemaining) {
                ++this.countInThisInterval;
                break;
            }
            double gapIterations = expectedRemaining - (double)actualRemaining;
            long remainingMillis = (long)Math.floor(this.millisBetweenIterations * gapIterations);
            if (remainingMillis >= minSleepMillis) {
                long waitTime = Math.min(remainingMillis, 10L);
                try {
                    this.wait(waitTime);
                    continue;
                }
                catch (InterruptedException e) {
                    Debug.debugException(e);
                    Thread.currentThread().interrupt();
                    return this.shutdownRequested;
                }
            }
            Thread.yield();
        }
        return this.shutdownRequested;
    }

    public synchronized ObjectPair<Long, Integer> getTargetRate() {
        return new ObjectPair<Long, Integer>(this.intervalDurationNanos / 1000000L, this.perInterval);
    }

    public void shutdownRequested() {
        this.shutdownRequested = true;
    }

    public boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    static {
        ArrayList<Long> minSleepMillisMeasurements = new ArrayList<Long>();
        for (int i = 0; i < 11; ++i) {
            long timeBefore = System.currentTimeMillis();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Debug.debugException(e);
            }
            long sleepMillis = System.currentTimeMillis() - timeBefore;
            minSleepMillisMeasurements.add(sleepMillis);
        }
        Collections.sort(minSleepMillisMeasurements);
        long medianSleepMillis = (Long)minSleepMillisMeasurements.get(minSleepMillisMeasurements.size() / 2);
        minSleepMillis = Math.max(medianSleepMillis, 1L);
        String message = "Calibrated FixedRateBarrier to use minSleepMillis=" + minSleepMillis + ".  " + "Minimum sleep measurements = " + minSleepMillisMeasurements;
        Debug.debug(Level.INFO, DebugType.OTHER, message);
    }
}

