/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.client;

import com.sun.ant.taskdefs.common.DescriptorHandler;
import java.io.File;
import org.apache.tools.ant.Task;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class ClientDescriptorHandler
extends DescriptorHandler {
    private static final String APP_CLIENT = "application-client";
    private static final String EJB_REF = "ejb-ref";
    private static final String BEAN_CLASS = "ejb-class";
    private static final String HOME_INTERFACE = "home";
    private static final String REMOTE_INTERFACE = "remote";
    protected boolean inEJBRef = false;

    public ClientDescriptorHandler(Task task, File srcDir) {
        super(task, srcDir);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.inEJBRef = false;
    }

    public void startElement(String name, AttributeList attrs) throws SAXException {
        super.startElement(name, attrs);
        if (name.equals(EJB_REF)) {
            this.inEJBRef = true;
        }
    }

    public void endElement(String name) throws SAXException {
        this.processElement();
        this.currentText = "";
        this.currentElement = "";
        if (name.equals(EJB_REF)) {
            this.inEJBRef = false;
        }
    }

    protected void processElement() {
        if (this.currentElement.equals(REMOTE_INTERFACE) || this.currentElement.equals(HOME_INTERFACE)) {
            File classFile = null;
            String className = this.currentText.trim();
            if (!className.startsWith("java.") && !className.startsWith("javax.")) {
                className = className.replace('.', File.separatorChar);
                className = className + ".class";
                classFile = new File(this.srcDir, className);
                this.files.put(className, classFile);
            }
        }
    }
}

