/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.services.Message;
import com.sun.javatest.services.ServiceExecutor;
import com.sun.javatest.services.StoppableRunnable;
import java.io.InputStream;
import java.io.Serializable;

public class ThreadExecutor
implements ServiceExecutor {
    private StoppableRunnable runner;
    private Thread worker;

    public ThreadExecutor(StoppableRunnable r) {
        if (r == null) {
            throw new NullPointerException("Service executor cannot be attached to null runnable.");
        }
        this.runner = r;
    }

    @Override
    public synchronized Message startService(Message startMsg) {
        if (startMsg.getType() != Message.MessageType.START) {
            return new Message(Message.MessageType.ERROR, (Serializable)((Object)"Bad Start Message"));
        }
        if (this.runner != null && this.worker != null && this.worker.isAlive()) {
            this.runner.stop();
        }
        this.worker = new Thread(this.runner);
        this.worker.setDaemon(true);
        this.worker.start();
        return new Message(Message.MessageType.STARTED, (Serializable)((Object)"Execution Thread Started"));
    }

    @Override
    public synchronized Message stopService(Message stopMsg) {
        if (stopMsg.getType() != Message.MessageType.STOP) {
            return new Message(Message.MessageType.ERROR, (Serializable)((Object)"Bad stop Message"));
        }
        this.runner.stop();
        if (this.worker == null || this.worker.isAlive()) {
            return new Message(Message.MessageType.ERROR, (Serializable)((Object)"Thread Wasn't Stopped"));
        }
        return new Message(Message.MessageType.STOPPED, (Serializable)((Object)"Thread Was Stopped Successfully"));
    }

    @Override
    public synchronized Message isAlive(Message isAlive) {
        if (isAlive.getType() != Message.MessageType.IS_ALIVE) {
            return new Message(Message.MessageType.ERROR, (Serializable)((Object)"Bad isAlive Message"));
        }
        if (this.worker != null && this.worker.isAlive()) {
            return new Message(Message.MessageType.ALIVE, (Serializable)((Object)"Service is alive"));
        }
        return new Message(Message.MessageType.NOT_ALIVE, (Serializable)((Object)"Service is not alive"));
    }

    @Override
    public InputStream getServiceErrorStream() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InputStream getServiceOutputStream() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

