/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.TSBuildListener;
import com.sun.ant.taskdefs.common.DescriptorHandler;
import com.sun.ant.taskdefs.common.Packager;
import com.sun.ant.taskdefs.common.TaskUtil;
import com.sun.ant.types.Support;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class GenericDeploymentTool {
    boolean recompiled;
    protected File destDir;
    protected Path classpath;
    protected Task task;
    protected Project project;
    protected ClassLoader classpathLoader = null;
    protected List addedfiles;
    protected DescriptorHandler handler;
    protected Packager.Config config;

    public void setDestdir(File inDir) {
        this.destDir = inDir;
    }

    protected File getDestDir() {
        return this.destDir;
    }

    public void setTask(Task task) {
        this.task = task;
        this.project = task.getProject();
    }

    protected Task getTask() {
        return this.task;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.task.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    protected Path getCombinedClasspath() {
        Path combinedPath = this.classpath;
        if (this.config.classpath != null) {
            if (combinedPath == null) {
                combinedPath = this.config.classpath;
            } else if (!combinedPath.equals(this.config.classpath)) {
                combinedPath.append(this.config.classpath);
            }
        }
        return combinedPath;
    }

    protected void log(String message, int level) {
        this.getTask().log(message, level);
    }

    protected Location getLocation() {
        return this.getTask().getLocation();
    }

    protected void registerKnownDTDs(DescriptorHandler handler) {
    }

    protected void checkConfiguration(String descriptorFileName, SAXParser saxParser) throws BuildException {
    }

    private String replacePattern(String[] pat) {
        String result = "";
        for (int i = 0; i < pat.length; ++i) {
            result = pat[i].endsWith(".class") ? result + pat[i].substring(0, pat[i].length() - 6) + ".java" : (pat[i].endsWith("**/*") ? result + pat[i] + ".java" : (pat[i].endsWith("**") ? result + pat[i] + "/*.java" : (pat[i].endsWith("*") ? result + pat[i] + ".java" : result + pat[i])));
            result = result + ",";
        }
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected void addSupportClasses(Hashtable ejbFiles) {
        File supportBaseDir;
        int i;
        int n = this.config.supportFileSets.size();
        for (i = 0; i < n; ++i) {
            Support supportFileSet = (Support)((Object)this.config.supportFileSets.get(i));
            supportBaseDir = supportFileSet.getDir(this.project);
            if (!supportBaseDir.exists()) {
                this.project.log("Directory '" + supportBaseDir.toString() + "' does not exist - skipping its processing.", 1);
                continue;
            }
            DirectoryScanner supportScanner = supportFileSet.getDirectoryScanner(this.project);
            String[] supportFiles1 = supportScanner.getIncludedFiles();
            for (int j = 0; j < supportFiles1.length; ++j) {
                ejbFiles.put(supportFiles1[j], new File(supportBaseDir, supportFiles1[j]));
            }
        }
        if (TSBuildListener.skipMakeupCompile() || TSBuildListener.getAlreadyMadeup()) {
            return;
        }
        n = this.config.supportFileSets.size();
        for (i = 0; i < n; ++i) {
            Support spt = (Support)((Object)this.config.supportFileSets.get(i));
            supportBaseDir = spt.getDir(this.project);
            String[] clsIncludes = spt.getOriginalIncludesArray();
            String[] clsExcludes = spt.getOriginalExcludesArray();
            String srcIncludes = this.replacePattern(clsIncludes);
            String srcExcludes = this.replacePattern(clsExcludes);
            FileSet shadow = new FileSet();
            shadow.setDir(TSBuildListener.fSrcDir);
            shadow.setIncludes(srcIncludes);
            shadow.setExcludes(srcExcludes);
            DirectoryScanner ds = shadow.getDirectoryScanner(this.project);
            String[] supportFiles = ds.getIncludedFiles();
            for (int j = 0; j < supportFiles.length; ++j) {
                String clsName = null;
                clsName = supportFiles[j].endsWith(".java") ? supportFiles[j].substring(0, supportFiles[j].length() - 5) + ".class" : supportFiles[j];
                ejbFiles.put(clsName, new File(supportBaseDir, clsName));
            }
        }
    }

    protected void addContentFiles(Hashtable webFiles) {
        for (FileSet contentFileSet : this.config.contentFileSets) {
            File contentFileSetDir = contentFileSet.getDir(this.task.getProject());
            DirectoryScanner contentScanner = contentFileSet.getDirectoryScanner(this.project);
            String[] contentFiles = contentScanner.getIncludedFiles();
            for (int j = 0; j < contentFiles.length; ++j) {
                webFiles.put(contentFiles[j], new File(contentFileSetDir, contentFiles[j]));
            }
        }
    }

    protected boolean needToRebuild(Hashtable ejbFiles, File jarFile) {
        return true;
    }

    protected String getPublicId() {
        return this.handler.getPublicId();
    }

    protected void checkAndAddInherited(Hashtable checkEntries) throws BuildException {
        Hashtable copiedHash = (Hashtable)checkEntries.clone();
        if (!TSBuildListener.skipMakeupCompile() && !TSBuildListener.getAlreadyMadeup()) {
            this.makeupCompile(copiedHash);
        }
        String classname = null;
        try {
            for (String entryName : copiedHash.keySet()) {
                File entryFile = (File)copiedHash.get(entryName);
                if (!entryName.endsWith(".class")) continue;
                classname = entryName.substring(0, entryName.lastIndexOf(".class")).replace(File.separatorChar, '.');
                ClassLoader loader = this.getClassLoaderForBuild();
                Class<?> c = loader.loadClass(classname);
                if (c.isPrimitive()) continue;
                if (c.isInterface()) {
                    this.log("looking at interface " + c.getName(), 3);
                    Class<?>[] interfaces = c.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        this.log("     implements " + interfaces[i].getName(), 3);
                        this.addInterface(interfaces[i], checkEntries);
                    }
                    continue;
                }
                this.log("looking at class " + c.getName(), 3);
                Class<?> s = c.getSuperclass();
                this.addSuperClass(c.getSuperclass(), checkEntries);
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new BuildException(cnfe.getMessage());
        }
        catch (NoClassDefFoundError ncdfe) {
            ncdfe.printStackTrace();
            throw new BuildException(ncdfe.getMessage());
        }
    }

    private void makeupCompile(Hashtable copiedHash) {
        String includesPattern = "";
        File local = TaskUtil.getCurrentSrcDir(this.project);
        for (String entryName : copiedHash.keySet()) {
            long javaTime;
            long clsTime;
            File file = (File)copiedHash.get(entryName);
            if (!entryName.endsWith(".class")) continue;
            String javaFileName = entryName.substring(0, entryName.lastIndexOf(".class")) + ".java";
            File javaFile = new File(TSBuildListener.tsHome + "/src", javaFileName);
            if (!file.exists()) {
                includesPattern = includesPattern + javaFileName + ",";
                continue;
            }
            if (local.compareTo(javaFile.getParentFile()) == 0 || (clsTime = file.lastModified()) >= (javaTime = javaFile.lastModified())) continue;
            includesPattern = includesPattern + javaFileName + ",";
        }
        if (includesPattern.endsWith(",")) {
            includesPattern = includesPattern.substring(0, includesPattern.length() - 1);
            this.project.log("Some classes have not been compiled, so recompile:\n" + includesPattern);
            this.doCompile(includesPattern);
        }
    }

    private void doCompile(String includesPattern) {
        String localClassRi;
        String tsClasspath = this.project.getProperty("ts.classpath");
        if (tsClasspath == null || tsClasspath.length() == 0) {
            this.project.log("ts.classpath not set in ts.jte or build.properties.", 1);
            tsClasspath = this.project.getProperty("j2ee.home.ri") + "/lib/j2ee.jar:" + TSBuildListener.tsHome + "/lib/tsharness.jar:" + TSBuildListener.tsHome + "/lib/javatest.jar:" + TSBuildListener.tsHome + "/classes";
        }
        if ((localClassRi = this.project.getProperty("local.classes.ri")) != null && localClassRi.length() != 0) {
            tsClasspath = tsClasspath + ":" + localClassRi;
        }
        Path tsAndLocalClasspath = new Path(this.project, tsClasspath);
        Javac compiler = new Javac();
        compiler.setProject(this.project);
        compiler.init();
        Path srcPath = new Path(this.project, TSBuildListener.sSrcDir);
        compiler.setSrcdir(srcPath);
        compiler.setDestdir(TSBuildListener.fClassDir);
        compiler.setFork(false);
        compiler.setIncludes(includesPattern);
        compiler.setDeprecation(true);
        compiler.setDebug(true);
        compiler.setClasspath(tsAndLocalClasspath);
        compiler.setFailonerror(false);
        compiler.setTaskName("recompile");
        compiler.perform();
    }

    protected void addInterface(Class theInterface, Hashtable checkEntries) {
        boolean acceptedIntf;
        boolean bl = acceptedIntf = !theInterface.getName().startsWith("java") && !theInterface.getName().startsWith("com.sun.ts.lib.util") && !theInterface.getName().startsWith("com.sun.javatest.Status");
        if (acceptedIntf) {
            this.log("** adding interface:" + theInterface.getName(), 3);
            File interfaceFile = new File(this.config.srcDir.getAbsolutePath() + File.separatorChar + theInterface.getName().replace('.', File.separatorChar) + ".class");
            if (interfaceFile.exists() && interfaceFile.isFile()) {
                String tmp = theInterface.getName().replace('.', File.separatorChar) + ".class";
                if (this.config.autocheckexcludes == null) {
                    checkEntries.put(tmp, interfaceFile);
                } else if (!this.config.autocheckexcludes.contains(tmp)) {
                    checkEntries.put(tmp, interfaceFile);
                }
                Class<?>[] superInterfaces = theInterface.getInterfaces();
                for (int i = 0; i < superInterfaces.length; ++i) {
                    this.addInterface(superInterfaces[i], checkEntries);
                }
            }
        } else {
            this.log("****** Interface skipped '" + theInterface.getName() + "'", 3);
        }
    }

    protected void addSuperClass(Class superClass, Hashtable checkEntries) {
        boolean acceptedClass;
        boolean bl = acceptedClass = !superClass.getName().startsWith("java") && !superClass.getName().startsWith("com.sun.ts.lib.util") && !superClass.getName().startsWith("com.sun.javatest.Status");
        if (acceptedClass) {
            this.log("*** adding super class:" + superClass.getName(), 3);
            File superClassFile = new File(this.config.srcDir.getAbsolutePath() + File.separatorChar + superClass.getName().replace('.', File.separatorChar) + ".class");
            if (superClassFile.exists() && superClassFile.isFile()) {
                String tmp = superClass.getName().replace('.', File.separatorChar) + ".class";
                if (this.config.autocheckexcludes == null) {
                    checkEntries.put(tmp, superClassFile);
                } else if (!this.config.autocheckexcludes.contains(tmp)) {
                    checkEntries.put(tmp, superClassFile);
                }
                Class<?>[] superInterfaces = superClass.getInterfaces();
                for (int i = 0; i < superInterfaces.length; ++i) {
                    this.addInterface(superInterfaces[i], checkEntries);
                }
                this.addSuperClass(superClass.getSuperclass(), checkEntries);
            }
        } else {
            this.log("****** Class skipped '" + superClass.getName() + "'", 3);
        }
    }

    protected ClassLoader getClassLoaderForBuild() {
        if (this.classpathLoader != null) {
            return this.classpathLoader;
        }
        Path combinedClasspath = this.getCombinedClasspath();
        this.classpathLoader = combinedClasspath == null ? this.getClass().getClassLoader() : new AntClassLoader(this.getTask().getProject(), combinedClasspath);
        return this.classpathLoader;
    }

    public void validateConfigured() throws BuildException {
        if (this.destDir == null || !this.destDir.isDirectory()) {
            this.destDir = TaskUtil.getFullDistDir(this.project);
            this.destDir.mkdirs();
        }
    }

    protected Packager.Config getConfig() {
        return this.config;
    }

    public void configure(Packager.Config config) {
        this.config = config;
        this.classpathLoader = null;
    }

    protected void autoCheckExclude(Map map) {
        if (this.config.autocheckexcludes != null) {
            int n = this.config.autocheckexcludes.size();
            for (int i = 0; i < n; ++i) {
                Object o = this.config.autocheckexcludes.get(i);
                map.remove(o);
            }
        }
    }
}

