/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.Set;
import java.util.StringTokenizer;

public final class ConstructorDescr
extends MemberDescription {
    public static final ConstructorDescr[] EMPTY_ARRAY = new ConstructorDescr[0];
    public static final String CONSTRUCTOR_NAME = "<init>";

    public ConstructorDescr() {
        super(MemberType.CONSTRUCTOR, '.');
    }

    public ConstructorDescr(ClassDescription clazz, int modifiers) {
        super(MemberType.CONSTRUCTOR, '.');
        this.setupConstuctorName(clazz.getQualifiedName());
        this.setModifiers(modifiers);
    }

    public ConstructorDescr(Class<?> clazz, int modifiers) {
        super(MemberType.CONSTRUCTOR, '.');
        this.setupConstuctorName(clazz.getName());
        this.setModifiers(modifiers);
    }

    public void setupConstuctorName(String clName) {
        this.declaringClass = clName.intern();
        this.name = CONSTRUCTOR_NAME;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ConstructorDescr)) {
            return false;
        }
        ConstructorDescr ctor = (ConstructorDescr)o;
        return this.name == ctor.name && SwissKnife.equals(this.typeParameters, ctor.typeParameters) && this.args.equals(ctor.args);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() + this.args.hashCode() + (this.typeParameters != null ? this.typeParameters.hashCode() : 0);
    }

    @Override
    public boolean isCompatible(MemberDescription m) {
        if (!this.equals(m)) {
            throw new IllegalArgumentException("Only equal members can be checked for compatibility!");
        }
        return this.memberType.isCompatible(this.getModifiers(), m.getModifiers()) && this.throwables.equals(m.throwables);
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    public String toString() {
        AnnotationItem[] annoList;
        StringBuffer buf = new StringBuffer();
        buf.append("constructor");
        String modifiers = Modifier.toString(this.memberType, this.getModifiers(), true);
        if (!modifiers.isEmpty()) {
            buf.append(' ');
            buf.append(modifiers);
        }
        if (this.typeParameters != null) {
            buf.append(' ');
            buf.append(this.typeParameters);
        }
        buf.append(' ');
        if (!"".equals(this.declaringClass)) {
            buf.append(this.declaringClass);
            buf.append(this.delimiter);
        }
        buf.append(this.name);
        buf.append('(');
        buf.append(this.args);
        buf.append(')');
        if (!this.throwables.isEmpty()) {
            buf.append(" throws ");
            buf.append(this.throwables);
        }
        for (AnnotationItem annotationItem : annoList = this.getAnnoList()) {
            buf.append("\n ");
            buf.append(annotationItem);
        }
        return buf.toString();
    }

    public String getSignature() {
        return this.declaringClass + this.delimiter + this.name + '(' + this.args + ')';
    }

    @Override
    protected void populateDependences(Set<String> set) {
        StringTokenizer st = new StringTokenizer(this.args, ",");
        while (st.hasMoreTokens()) {
            this.addDependency(set, st.nextToken());
        }
        st = new StringTokenizer(this.throwables, ",");
        while (st.hasMoreTokens()) {
            this.addDependency(set, st.nextToken());
        }
    }
}

