/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.resultSet.resultSet49;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import javax.sql.DataSource;

public class resultSetClient49
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.resultSet.resultSet49";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private DataSource ds1 = null;
    private String drManager = null;
    private String sqlStmt = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private Properties props = null;
    private Properties sqlp = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        resultSetClient49 theTests = new resultSetClient49();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.rsSch = new rsSchema();
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTime13() throws EETest.Fault {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            this.msg.setMsg("perform query to get the value of Time from Time_Tab");
            String Time_Query_Brk = this.sqlp.getProperty("Time_Query_Brk", null);
            rs = this.stmt.executeQuery(Time_Query_Brk);
            rs.next();
            this.msg.setMsg("Calling getTime on Time_Tab");
            Time retVal = rs.getTime(1);
            this.msg.setMsg("extract the Value of Time from Time_Tab");
            str = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            str = this.getSingleQuoteContent(str);
            Time brkVal = Time.valueOf(str);
            this.msg.addOutputMsg("" + brkVal, "" + retVal);
            if (retVal.equals(brkVal)) {
                this.msg.setMsg("getTime method returns: " + retVal);
            } else {
                this.msg.printTestError("getTime does not return the Time value from Time_Tab", "Call to getTime(int columnIndex) failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTime method has failed!!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTime method has failed!!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTime14() throws EETest.Fault {
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            String Time_Query_Null = this.sqlp.getProperty("Time_Query_Null", null);
            rs = this.stmt.executeQuery(Time_Query_Null);
            rs.next();
            this.msg.setMsg("Calling getTime on Time_Tab");
            Time retVal = rs.getTime(1);
            if (retVal == null) {
                this.msg.setMsg("getTime method returns :" + retVal);
            } else {
                this.msg.printTestError("getTime method does not return null", "test getTime Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTime method has failed!!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTime method has failed!!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTime16() throws EETest.Fault {
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            String Timestamp_Query_Null = this.sqlp.getProperty("Timestamp_Query_Null", null);
            rs = this.stmt.executeQuery(Timestamp_Query_Null);
            rs.next();
            this.msg.setMsg("Calling getTime on Timestamp_Tab");
            Time retVal = rs.getTime(1);
            if (retVal == null) {
                this.msg.setMsg("getTime method returns :" + retVal);
            } else {
                this.msg.printTestError("getTime method does not return null", "test getTime Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTime method has failed!!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTime method has failed!!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTime17() throws EETest.Fault {
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        String columname = null;
        String str = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            this.msg.setMsg("perform query to get the value of Time from Time_Tab");
            String Time_Query_Brk = this.sqlp.getProperty("Time_Query_Brk", null);
            rs = this.stmt.executeQuery(Time_Query_Brk);
            rsmd = rs.getMetaData();
            rs.next();
            this.msg.setMsg("Calling getTime on Time_Tab");
            columname = rsmd.getColumnName(1);
            Time retVal = rs.getTime(columname);
            this.msg.setMsg("extract the Value of Time from Time_Tab");
            str = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            str = this.getSingleQuoteContent(str);
            Time brkVal = Time.valueOf(str);
            this.msg.addOutputMsg("" + brkVal, "" + retVal);
            if (retVal.equals(brkVal)) {
                this.msg.setMsg("getTime method returns: " + retVal);
            } else {
                this.msg.printTestError("getTime does not return the Time value from Char_Tab", "test getTime(int columnIndex) failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTime method has failed!!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTime method has failed!!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTime18() throws EETest.Fault {
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        String columname = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            String Time_Query_Null = this.sqlp.getProperty("Time_Query_Null", null);
            rs = this.stmt.executeQuery(Time_Query_Null);
            rsmd = rs.getMetaData();
            rs.next();
            this.msg.setMsg("Calling getTime on Time_Tab");
            columname = rsmd.getColumnName(1);
            Time retVal = rs.getTime(columname);
            if (retVal == null) {
                this.msg.setMsg("getTime method returns :" + retVal);
            } else {
                this.msg.printTestError("getTime method does not return null", "test getTime Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTime method has failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTime method has failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTimestamp01() throws EETest.Fault {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("extract the Value of Timestamp from Timestamp_Tab");
            str = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            TestUtil.logMsg((String)("Table String is " + str));
            str = this.getSingleQuoteContent(str);
            TestUtil.logMsg((String)("Modified String is " + str));
            String sPrepStatement = this.sqlp.getProperty("Char_Tab_Name_Update", null);
            PreparedStatement pstmt = this.conn.prepareStatement(sPrepStatement);
            Timestamp brkVal = Timestamp.valueOf(str);
            pstmt.setString(1, str);
            pstmt.executeUpdate();
            this.msg.setMsg("perform query to get the value of Timestamp from Timestamp_Tab");
            String Char_Query_Name = this.sqlp.getProperty("Char_Query_Name", null);
            rs = this.stmt.executeQuery(Char_Query_Name);
            rs.next();
            this.msg.setMsg("Calling getTime on Char_Tab");
            Timestamp retVal = rs.getTimestamp(1);
            this.msg.addOutputMsg("" + brkVal, "" + retVal);
            if (retVal.equals(brkVal)) {
                this.msg.setMsg("getTimestamp method returns: " + retVal);
            } else {
                this.msg.printTestError("getTimestamp does not return the Timestamp value from Char_Tab", "test getTimestamp(int columnIndex) Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimestamp method has failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimestamp method has failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.pstmt.close();
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTimestamp13() throws EETest.Fault {
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String Char_Query_Null = this.sqlp.getProperty("Char_Query_Null", null);
            rs = this.stmt.executeQuery(Char_Query_Null);
            rs.next();
            this.msg.setMsg("Calling getTimestamp on Char_Tab");
            Timestamp retVal = rs.getTimestamp(1);
            if (retVal == null) {
                this.msg.setMsg("getTimestamp method returns :" + retVal);
            } else {
                this.msg.printTestError("getTimestamp method does not return null", "test getTimestamp Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimestamp method has failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimestamp method has failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTimestamp03() throws EETest.Fault {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("extract the Value of Timestamp from Timestamp_Tab");
            str = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            str = this.getSingleQuoteContent(str);
            String sPrepStatement = this.sqlp.getProperty("Varchar_Tab_Name_Update", null);
            PreparedStatement pstmt = this.conn.prepareStatement(sPrepStatement);
            Timestamp brkVal = Timestamp.valueOf(str);
            pstmt.setString(1, str);
            pstmt.executeUpdate();
            this.msg.setMsg("perform query to get the value of Timestamp from Timestamp_Tab");
            String Varchar_Query_Name = this.sqlp.getProperty("Varchar_Query_Name", null);
            rs = this.stmt.executeQuery(Varchar_Query_Name);
            rs.next();
            this.msg.setMsg("Calling getTime on Varchar_Tab");
            Timestamp retVal = rs.getTimestamp(1);
            this.msg.addOutputMsg("" + brkVal, "" + retVal);
            if (retVal.equals(brkVal)) {
                this.msg.setMsg("getTimestamp method returns: " + retVal);
            } else {
                this.msg.printTestError("getTimestamp does not return the Timestamp value from Varchar_Tab", "Call to getTimestamp(int columnIndex) failed!!!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimestamp method has failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimestamp method has failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.pstmt.close();
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTimestamp04() throws EETest.Fault {
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String Varchar_Query_Null = this.sqlp.getProperty("Varchar_Query_Null", null);
            rs = this.stmt.executeQuery(Varchar_Query_Null);
            rs.next();
            this.msg.setMsg("Calling getTime on Varchar_Tab");
            Timestamp retVal = rs.getTimestamp(1);
            if (retVal == null) {
                this.msg.setMsg("getTimestamp method returns :" + retVal);
            } else {
                this.msg.printTestError("getTimestamp method does not return null", "call to getTimestamp failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimestamp method has failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimestamp method has failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTimestamp12() throws EETest.Fault {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Longvarchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("extract the Value of Timestamp from Timestamp_Tab");
            str = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            str = this.getSingleQuoteContent(str);
            String sPrepStatement = this.sqlp.getProperty("Longvarchar_Tab_Name_Update", null);
            PreparedStatement pstmt = this.conn.prepareStatement(sPrepStatement);
            Timestamp brkVal = Timestamp.valueOf(str);
            pstmt.setString(1, str);
            pstmt.executeUpdate();
            this.msg.setMsg("perform query to get the value of Timestamp from Timestamp_Tab");
            String Longvarchar_Query_Name = this.sqlp.getProperty("Longvarchar_Query_Name", null);
            rs = this.stmt.executeQuery(Longvarchar_Query_Name);
            rs.next();
            this.msg.setMsg("Calling getTimestamp on Longvarchar_Tab");
            Timestamp retVal = rs.getTimestamp(1);
            this.msg.addOutputMsg("" + brkVal, "" + retVal);
            if (retVal.equals(brkVal)) {
                this.msg.setMsg("getTimestamp method returns: " + retVal);
            } else {
                this.msg.printTestError("getTimestamp does not return the Timestamp value from Longvarchar_Tab", "test getTimestamp Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimestamp method has failed!!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimestamp method has failed!!");
        }
        finally {
            try {
                this.stmt.close();
                this.pstmt.close();
                this.rsSch.dropTab("Longvarchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    private String getSingleQuoteContent(String str) {
        int index1 = str.indexOf("'");
        String retStr = "";
        if (index1 < 0) {
            this.logErr("Error - No single quotes found in :  " + str);
            return "";
        }
        int index2 = str.indexOf("'", index1 + 1);
        if (index2 < 0) {
            this.logErr("Error - No closing quote found in : " + str);
            return "";
        }
        retStr = str.substring(index1 + 1, index2);
        this.logTrace("Found the properly quoted string: \"" + retStr + "\"");
        return retStr;
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

