/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitybeantest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitybeantest.Helper;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitybeantest.HelperHome;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitybeantest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitybeantest.TestBeanHome;
import jakarta.ejb.DuplicateKeyException;
import jakarta.ejb.FinderException;
import jakarta.ejb.Handle;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testName = "EntityBeanTest";
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static final String helperBean = "java:comp/env/ejb/HelperBean";
    private static final String testProps = "entitybeantest.properties";
    private static final String testDir = System.getProperty("user.dir");
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private Properties props = null;
    private TSNamingContext nctx = null;
    private Helper helperRef = null;
    private HelperHome helperHome = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logTrace("Client: Initializing BMP table...");
            DAOFactory.getInstance().getCoffeeDAO().cleanup();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/HelperBean");
            this.helperHome = (HelperHome)this.nctx.lookup(helperBean, HelperHome.class);
            this.logMsg("Creating helper EJB");
            this.helperRef = this.helperHome.create(this.props);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 2.0f, this.helperRef);
            this.logMsg("check if proper lifecycle creation order was called in the bean");
            pass = this.helperRef.isCreateLifeCycle1();
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test2() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
            this.logMsg("check if proper lifecycle creation order was called in the bean");
            pass = this.helperRef.isCreateLifeCycle2();
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void test3() throws EETest.Fault {
        boolean pass = true;
        try {
            this.helperRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
            this.logMsg("Remove bean and check ejbRemove() was called in the bean");
            this.beanRef.remove();
            pass = this.helperRef.isRemove();
            if (pass) {
                this.logMsg("ejbRemove was called - expected");
            } else {
                try {
                    TestBean theBean = this.beanHome.findByPrimaryKey(new Integer(1));
                    pass = false;
                    this.logErr("findByPrimaryKey succeeded after entity removal");
                }
                catch (FinderException e) {
                    TestUtil.printStackTrace((Throwable)e);
                    this.logMsg("FinderException occurs, entity was removed");
                    pass = true;
                }
                catch (RemoteException e) {
                    this.logErr("RemoteException occurs, expected FinderException");
                    pass = false;
                }
            }
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanRef.remove();
                this.logErr("object was not removed, was able to invoke object");
                pass = false;
            }
            catch (NoSuchObjectException e) {
                this.logMsg("NoSuchObjectException received as expected");
            }
            catch (RemoteException e) {
                this.logMsg("RemoteException received as expected");
            }
            catch (Exception e) {
                throw new EETest.Fault("test3 failed", e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test3 failed");
        }
    }

    public void test3a() throws EETest.Fault {
        boolean pass = true;
        try {
            this.helperRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
            this.logMsg("Remove bean and check ejbRemove() was called in the bean");
            Handle handle = this.beanRef.getHandle();
            this.beanHome.remove(handle);
            pass = this.helperRef.isRemove();
            if (pass) {
                this.logMsg("ejbRemove was called - expected");
            } else {
                try {
                    TestBean theBean = this.beanHome.findByPrimaryKey(new Integer(1));
                    pass = false;
                    this.logErr("findByPrimaryKey succeeded after entity removal");
                }
                catch (FinderException e) {
                    TestUtil.printStackTrace((Throwable)e);
                    this.logMsg("FinderException occurs, entity was removed");
                    pass = true;
                }
                catch (RemoteException e) {
                    this.logErr("RemoteException occurs, expected FinderException");
                    pass = false;
                }
            }
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanHome.remove(handle);
                this.logErr("object was not removed, was able to invoke object");
                pass = false;
            }
            catch (NoSuchObjectException e) {
                this.logMsg("NoSuchObjectException received as expected");
            }
            catch (RemoteException e) {
                this.logMsg("RemoteException received as expected");
            }
            catch (Exception e) {
                throw new EETest.Fault("test3a failed", e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3a failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test3a failed");
        }
    }

    public void test3b() throws EETest.Fault {
        boolean pass = true;
        try {
            this.helperRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
            this.logMsg("Remove bean and check ejbRemove() was called in the bean");
            Object pkey = this.beanRef.getPrimaryKey();
            this.beanHome.remove(pkey);
            pass = this.helperRef.isRemove();
            if (pass) {
                this.logMsg("ejbRemove was called - expected");
            } else {
                try {
                    TestBean theBean = this.beanHome.findByPrimaryKey(new Integer(1));
                    pass = false;
                    this.logErr("findByPrimaryKey succeeded after entity removal");
                }
                catch (FinderException e) {
                    TestUtil.printStackTrace((Throwable)e);
                    this.logMsg("FinderException occurs, entity was removed");
                    pass = true;
                }
                catch (RemoteException e) {
                    this.logErr("RemoteException occurs, expected FinderException");
                    pass = false;
                }
            }
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanHome.remove(pkey);
                this.logErr("object was not removed, was able to invoke object");
                pass = false;
            }
            catch (NoSuchObjectException e) {
                this.logMsg("NoSuchObjectException received as expected");
            }
            catch (RemoteException e) {
                this.logMsg("RemoteException received as expected");
            }
            catch (Exception e) {
                throw new EETest.Fault("test3b failed", e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3b failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test3b failed");
        }
    }

    public void test3c() throws EETest.Fault {
        boolean pass = true;
        try {
            this.helperRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
            this.logMsg("Remove bean and check ejbRemove() was called in the bean");
            this.beanRef.remove();
            pass = this.helperRef.isRemove();
            if (pass) {
                this.logMsg("ejbRemove was called - expected");
            } else {
                try {
                    TestBean theBean = this.beanHome.findByPrimaryKey(new Integer(1));
                    pass = false;
                    this.logErr("findByPrimaryKey succeeded after entity removal");
                }
                catch (FinderException e) {
                    TestUtil.printStackTrace((Throwable)e);
                    this.logMsg("FinderException occurs, entity was removed");
                    pass = true;
                }
                catch (RemoteException e) {
                    this.logErr("RemoteException occurs, expected FinderException");
                    pass = false;
                }
            }
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanRef.ping();
                this.logErr("object was not removed, was able to invoke object");
                pass = false;
            }
            catch (NoSuchObjectException e) {
                this.logMsg("NoSuchObjectException received as expected: " + e);
            }
            catch (RemoteException e) {
                this.logMsg("RemoteException received as expected: " + e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3c failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test3c failed");
        }
    }

    public void test3d() throws EETest.Fault {
        boolean pass = true;
        try {
            this.helperRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
            this.logMsg("Remove bean and check ejbRemove() was called in the bean");
            Handle handle = this.beanRef.getHandle();
            this.beanHome.remove(handle);
            pass = this.helperRef.isRemove();
            if (pass) {
                this.logMsg("ejbRemove was called - expected");
            } else {
                try {
                    TestBean theBean = this.beanHome.findByPrimaryKey(new Integer(1));
                    pass = false;
                    this.logErr("findByPrimaryKey succeeded after entity removal");
                }
                catch (FinderException e) {
                    TestUtil.printStackTrace((Throwable)e);
                    this.logMsg("FinderException occurs, entity was removed");
                    pass = true;
                }
                catch (RemoteException e) {
                    this.logErr("RemoteException occurs, expected FinderException");
                    pass = false;
                }
            }
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanRef.ping();
                this.logErr("object was not removed, was able to invoke object");
                pass = false;
            }
            catch (NoSuchObjectException e) {
                this.logMsg("NoSuchObjectException received as expected: " + e);
            }
            catch (RemoteException e) {
                this.logMsg("RemoteException received as expected: " + e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3d failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test3d failed");
        }
    }

    public void test3e() throws EETest.Fault {
        boolean pass = true;
        try {
            this.helperRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
            this.logMsg("Remove bean and check ejbRemove() was called in the bean");
            Object pkey = this.beanRef.getPrimaryKey();
            this.beanHome.remove(pkey);
            pass = this.helperRef.isRemove();
            if (pass) {
                this.logMsg("ejbRemove was called - expected");
            } else {
                try {
                    TestBean theBean = this.beanHome.findByPrimaryKey(new Integer(1));
                    pass = false;
                    this.logErr("findByPrimaryKey succeeded after entity removal");
                }
                catch (FinderException e) {
                    TestUtil.printStackTrace((Throwable)e);
                    this.logMsg("FinderException occurs, entity was removed");
                    pass = true;
                }
                catch (RemoteException e) {
                    this.logErr("RemoteException occurs, expected FinderException");
                    pass = false;
                }
            }
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanRef.ping();
                this.logErr("object was not removed, was able to invoke object");
                pass = false;
            }
            catch (NoSuchObjectException e) {
                this.logMsg("NoSuchObjectException received as expected: " + e);
            }
            catch (RemoteException e) {
                this.logMsg("RemoteException received as expected: " + e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3e failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test3e failed");
        }
    }

    public void test4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Use callback bean to do direct insert of database record");
            this.helperRef.directInsert(2, "mycoffee", 1.1f);
            this.logMsg("Perform a find by primary key on new entity");
            this.beanRef = this.beanHome.findByPrimaryKey(new Integer(2));
            if (this.beanRef == null) {
                TestUtil.logErr((String)"find by primaryKey did not yield entity bean");
                pass = false;
            } else {
                TestUtil.logMsg((String)"find by primaryKey did yield entity bean");
            }
            TestUtil.logMsg((String)"Check if primary keys match");
            if ((Integer)this.beanRef.getPrimaryKey() != 2) {
                TestUtil.logErr((String)"primary key does not match expected");
            } else {
                TestUtil.logMsg((String)"primary key does match expected");
            }
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    public void test4a() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Use callback bean to direct insert database record");
            this.helperRef.directInsert(1, "mycoffee", 1.1f);
            try {
                this.logMsg("Create entity bean instance");
                this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
                pass = false;
                this.beanRef.remove();
            }
            catch (DuplicateKeyException e) {
                TestUtil.logMsg((String)"DuplicateKeyException received as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception received - unexpected", (Throwable)e);
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test4a failed", e);
        }
        finally {
            try {
                this.logMsg("Use callback bean to direct delete database record");
                this.helperRef.directDelete(1);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test4a failed");
        }
    }

    public void test5() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
            this.logMsg("Use callback bean to do direct delete of database record");
            this.helperRef.directDelete(1);
            this.logMsg("attempt to invoke bean after removal");
            try {
                this.beanRef.ping();
                this.logErr("object was not removed, was able to invoke object");
                pass = false;
            }
            catch (RemoteException e) {
                this.logMsg("RemoteException received as expected: " + e);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test5 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    public void test7() throws EETest.Fault {
        boolean pass = true;
        try {
            this.helperRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
            this.logMsg("invoke bean to throw EJBException");
            try {
                this.beanRef.throwEJBException();
                this.logErr("No EJBException occurred");
                pass = false;
            }
            catch (RemoteException e) {
                this.logMsg("RemoteException received as expected: " + e);
            }
            catch (Exception e) {
                this.logErr("Exception received - unexpected: " + e, e);
                pass = false;
            }
            if (this.beanRef.iAmDestroyed()) {
                TestUtil.logErr((String)"instance has not been destroyed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"instance has been destroyed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test7 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test7 failed");
        }
    }

    public void test8() throws EETest.Fault {
        boolean pass = true;
        try {
            this.helperRef.reset();
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, this.helperRef);
            this.logMsg("invoke bean to throw Error");
            try {
                this.beanRef.throwError();
                this.logErr("No Error occurred");
                pass = false;
            }
            catch (RemoteException e) {
                this.logMsg("RemoteException received as expected: " + e);
            }
            catch (Exception e) {
                this.logErr("Exception received - unexpected: " + e, e);
                pass = false;
            }
            if (this.beanRef.iAmDestroyed()) {
                TestUtil.logErr((String)"instance has not been destroyed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"instance has been destroyed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test8 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test8 failed");
        }
    }

    public void test10() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 2.0f, this.helperRef);
            this.helperRef.reset();
            this.logMsg("check if ejbStore was invoked");
            this.beanRef.loadOrStoreTest(this.helperRef);
            if (this.helperRef.isStore()) {
                this.logMsg("ejbStore was called");
            } else {
                this.logErr("ejbStore was not called");
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test10 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test10 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

