/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.common;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import jdk.incubator.http.internal.common.Utils8;

public final class MinimalFuture<T>
extends CompletableFuture<T> {
    static final AtomicLong TOKENS = new AtomicLong();
    final long id = TOKENS.incrementAndGet();

    public static <U> MinimalFuture<U> completedFuture(U u) {
        MinimalFuture<U> minimalFuture = new MinimalFuture<U>();
        minimalFuture.complete(u);
        return minimalFuture;
    }

    public static <U> CompletableFuture<U> failedFuture(Throwable throwable) {
        Objects.requireNonNull(throwable);
        MinimalFuture minimalFuture = new MinimalFuture();
        minimalFuture.completeExceptionally(throwable);
        return minimalFuture;
    }

    public static <U> CompletableFuture<U> supply(ExceptionalSupplier<U> exceptionalSupplier) {
        MinimalFuture<U> minimalFuture = new MinimalFuture<U>();
        try {
            U u = exceptionalSupplier.get();
            minimalFuture.complete(u);
        }
        catch (Throwable throwable) {
            minimalFuture.completeExceptionally(throwable);
        }
        return minimalFuture;
    }

    public static <U> CompletableFuture<U> supply(ExceptionalSupplier<U> exceptionalSupplier, Executor executor) {
        MinimalFuture minimalFuture = new MinimalFuture();
        Utils8.completeAsync(minimalFuture, () -> {
            try {
                return exceptionalSupplier.get();
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        }, executor);
        return minimalFuture;
    }

    public static <T> MinimalFuture<T> copy(CompletionStage<T> completionStage, Executor executor) {
        MinimalFuture minimalFuture = new MinimalFuture();
        BiConsumer<Object, Throwable> biConsumer = (object, throwable) -> {
            if (throwable != null) {
                minimalFuture.completeExceptionally((Throwable)throwable);
            } else {
                minimalFuture.complete(object);
            }
        };
        if (completionStage.getClass() == CompletableFuture.class) {
            completionStage.whenCompleteAsync(biConsumer, executor);
            return minimalFuture;
        }
        completionStage.whenComplete(biConsumer);
        return (MinimalFuture)minimalFuture.thenApplyAsync(Function.identity(), executor);
    }

    @Override
    public <U> MinimalFuture<U> newIncompleteFuture() {
        return new MinimalFuture<T>();
    }

    @Override
    public void obtrudeValue(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void obtrudeException(Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return super.toString() + " (id=" + this.id + ")";
    }

    @FunctionalInterface
    public static interface ExceptionalSupplier<U> {
        public U get() throws Throwable;
    }
}

