/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta12;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class dbMetaClient12
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta12";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String drManager = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient12 theTests = new dbMetaClient12();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testGetSQLStateType() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getSQLStateType");
            int SQLState = this.dbmd.getSQLStateType();
            this.msg.setMsg("getSQLStateType methods returns SQLStateType: " + SQLState);
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getSQLStateType is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getSQLStateType is Failed!");
        }
    }

    public void testGetDatabaseMinorVersion() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getDatabaseMinorVersion");
            int dbMinorVersion = this.dbmd.getDatabaseMinorVersion();
            this.msg.setMsg("getDatabaseMinorVersion methods returns DatabaseMinorVersion: " + dbMinorVersion);
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDatabaseMinorVersion is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDatabaseMinorVersion is Failed!");
        }
    }

    public void testGetDatabaseMajorVersion() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getDatabaseMajorVersion");
            int dbMajorVersion = this.dbmd.getDatabaseMajorVersion();
            this.msg.setMsg("getDatabaseMajorVersion methods returns DatabaseMajorVersion: " + dbMajorVersion);
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDatabaseMajorVersion is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDatabaseMajorVersion is Failed!");
        }
    }

    public void testGetJDBCMinorVersion() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getJDBCMinorVersion");
            int jdbcMinorVersion = this.dbmd.getJDBCMinorVersion();
            this.msg.setMsg("getJDBCMinorVersion methods returns JDBCMinorVersion: " + jdbcMinorVersion);
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getJDBCMinorVersion is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getJDBCMinorVersion is Failed!");
        }
    }

    public void testGetJDBCMajorVersion() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getJDBCMajorVersion");
            int jdbcMajorVersion = this.dbmd.getJDBCMajorVersion();
            this.msg.setMsg("getJDBCMajorVersion methods returns JDBCMajorrVersion : " + jdbcMajorVersion);
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getJDBCMajorVersion is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getJDBCMajorVersion is Failed!");
        }
    }

    public void testSupportsSavepoints() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsBatchUpdates");
            boolean retValue = this.dbmd.supportsSavepoints();
            if (retValue) {
                this.msg.setMsg("supportsSavepoints is supported");
            } else {
                this.msg.setMsg("supportsSavepoints is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSavepoints is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSavepoints is Failed!");
        }
    }

    public void testSupportsNamedParameters() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsNamedParameters");
            boolean retValue = this.dbmd.supportsNamedParameters();
            if (retValue) {
                this.msg.setMsg("supportsNamedParameters is supported");
            } else {
                this.msg.setMsg("supportsNamedParameters is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsNamedParameters is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsNamedParameters is Failed!");
        }
    }

    public void testSupportsMultipleOpenResults() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsMultipleOpenResults");
            boolean retValue = this.dbmd.supportsMultipleOpenResults();
            if (retValue) {
                this.msg.setMsg("supportsMultipleOpenResults is supported");
            } else {
                this.msg.setMsg("supportsMultipleOpenResults is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsMultipleOpenResults is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsMultipleOpenResults is Failed!");
        }
    }

    public void testSupportsGetGeneratedKeys() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsGetGeneratedKeys");
            boolean retValue = this.dbmd.supportsGetGeneratedKeys();
            if (retValue) {
                this.msg.setMsg("supportsGetGeneratedKeys is supported");
            } else {
                this.msg.setMsg("supportsGetGeneratedKeys is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsGetGeneratedKeys is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsGetGeneratedKeys is Failed!");
        }
    }

    public void testSupportsResultSetHoldability01() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetHoldability");
            boolean retValue = this.dbmd.supportsResultSetHoldability(1);
            if (retValue) {
                this.msg.setMsg("supportsResultSetHoldability(ResultSet.HOLD_CURSORS_OVER_COMMIT) is supported");
            } else {
                this.msg.setMsg("supportsResultSetHoldability(ResultSet.HOLD_CURSORS_OVER_COMMIT) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetHoldability is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetHoldability is Failed!");
        }
    }

    public void testSupportsResultSetHoldability02() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetHoldability");
            boolean retValue = this.dbmd.supportsResultSetHoldability(2);
            if (retValue) {
                this.msg.setMsg("supportsResultSetHoldability(ResultSet.CLOSE_CURSORS_AT_COMMIT) is supported");
            } else {
                this.msg.setMsg("supportsResultSetHoldability (ResultSet.CLOSE_CURSORS_AT_COMMIT)is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetHoldability is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetHoldability is Failed!");
        }
    }

    public void testGetResultSetHoldability() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetHoldability");
            int holdability = this.dbmd.getResultSetHoldability();
            if (holdability == 2 || holdability == 1) {
                this.msg.setMsg("getResultSetHoldability returns: " + holdability);
            } else {
                this.msg.printTestError("getResultSetHoldability does not return default value: ", "call to getResultSetHoldability fails");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getResultSetHoldability is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getResultSetHoldability is Failed!");
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

