/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.File;
import java.util.StringTokenizer;
import javasoft.sqe.apiCheck.API;
import javasoft.sqe.apiCheck.Expander;
import javasoft.sqe.apiCheck.Main;
import javasoft.sqe.apiCheck.Merger;
import javasoft.sqe.apiCheck.PackageSet;
import javasoft.sqe.apiCheck.ReadJhu;
import javasoft.sqe.apiCheck.Tran;
import javasoft.sqe.apiCheck.Version;
import javasoft.sqe.apiCheck.WriteJh;

public class Merge {
    static String[] pars = new String[]{"base$m$s", "update$m$s", "package$m$s", "expackage$m$s", "sigout$s", "reflect", "static", "version", "time", "debug"};
    static String help = "Options are:\n-base <spec>\n-update <file>\n-package <packs>\n-expackage <packs>\n-sigout <file>\n-reflect\n-static\n-version";

    public static void main(String[] args) {
        if (!Main.args.Parse(args, pars) || Main.args.isEmpty()) {
            System.err.println(help);
            return;
        }
        if (Main.args.getProperty("version") != null) {
            System.out.println("Version: " + Version.Ident());
            if (Main.args.size() == 1) {
                return;
            }
        }
        PackageSet packs = new PackageSet(Main.args.getProperty("package"), Main.args.getProperty("expackage"));
        API baseapi = new API();
        String basepath = Main.args.getProperty("base");
        if (basepath == null) {
            System.err.println("base not defined - using default classpath");
            if (!Merge.Read(baseapi, null, packs)) {
                Merge.Stop("no classes found in default classpath");
            }
        } else {
            StringTokenizer st = new StringTokenizer(basepath, File.pathSeparator + ' ', false);
            while (st.hasMoreElements()) {
                String fname = (String)st.nextElement();
                if (Merge.Read(baseapi, fname, packs)) continue;
                Merge.Stop("no classes found in \"" + fname + "\"");
            }
        }
        if (baseapi.units != null) {
            Expander e = new Expander();
            e.Expand(baseapi.units);
            e.PrintResults(System.err);
        }
        if (Main.args.getProperty("update") != null) {
            Tran tran = new Tran();
            ReadJhu readupd = new ReadJhu(tran);
            StringTokenizer st = new StringTokenizer(Main.args.getProperty("update"), File.pathSeparator + ' ', false);
            while (st.hasMoreElements()) {
                String fname = (String)st.nextElement();
                File f = new File(fname);
                if (!f.exists() && !fname.endsWith(".jhu") && (f = new File(fname + ".jhu")).exists() && f.isFile()) {
                    fname = fname + ".jhu";
                }
                f = null;
                if (readupd.Read(baseapi, fname)) continue;
                Merge.Stop(null);
            }
            Merger dec = new Merger(baseapi.GetUnits(), tran);
            if (!dec.Work(baseapi.props)) {
                Merge.Stop("update error");
            }
            dec = null;
            baseapi.xprog = null;
        }
        WriteJh writer = new WriteJh();
        if (Main.args.getProperty("sigout") == null) {
            writer.Write(baseapi, System.out);
        } else {
            writer.Write(baseapi, Main.args.getProperty("sigout"));
        }
        writer.OutExtern(baseapi.GetXProg());
        writer.Close();
        System.exit(0);
    }

    static boolean Read(API api, String name, PackageSet pset) {
        if (name != null && name.indexOf(System.getProperty("path.separator")) == -1 && !name.equals("$")) {
            File f = new File(name);
            if (!f.exists()) {
                if (name.endsWith(".jh")) {
                    System.err.println("not found \"" + name + "\"");
                    return false;
                }
                f = new File(name + ".jh");
                if (!f.exists() || !f.isFile()) {
                    System.err.println("not found \"" + name + "\"");
                    return false;
                }
                name = name + ".jh";
            }
            if (f.isFile()) {
                if (!f.canRead()) {
                    System.err.println("cannot read \"" + name + "\"");
                    return false;
                }
                return api.ReadAll(name, pset) > 0;
            }
        }
        return api.ReadAll(name, pset) > 0;
    }

    static void Stop(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println("Merge terminated.");
        System.exit(1);
    }
}

