/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.util.Vector;

public class StringArray {
    private static final String[] empty = new String[0];

    public static String[] split(String s) {
        if (s == null) {
            return empty;
        }
        Vector<String> v = new Vector<String>();
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (StringArray.white(s.charAt(i))) {
                if (start != -1) {
                    v.addElement(s.substring(start, i));
                }
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            v.addElement(s.substring(start));
        }
        if (v.size() == 0) {
            return empty;
        }
        Object[] a = new String[v.size()];
        v.copyInto(a);
        return a;
    }

    public static String join(String[] ss) {
        return StringArray.join(ss, " ");
    }

    public static String join(String[] ss, String sep) {
        if (ss == null || ss.length == 0) {
            return "";
        }
        int l = (ss.length - 1) * sep.length();
        for (int i = 0; i < ss.length; ++i) {
            l += ss[i] == null ? 0 : ss[i].length();
        }
        StringBuffer sb = new StringBuffer(l);
        sb.append(ss[0]);
        for (int i = 1; i < ss.length; ++i) {
            sb.append(sep);
            sb.append(ss[i]);
        }
        return sb.toString();
    }

    public static String[] splitList(String list, String delim) {
        int nextD;
        if (list == null || list.length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int pos = 0;
        while ((nextD = list.indexOf(delim, pos)) != -1) {
            v.addElement(list.substring(pos, nextD));
            pos = nextD + delim.length();
            pos = StringArray.skipWhite(list, pos);
        }
        if (pos < list.length()) {
            v.addElement(list.substring(pos));
        }
        if (v.size() == 0) {
            return new String[0];
        }
        Object[] a = new String[v.size()];
        v.copyInto(a);
        return a;
    }

    public static boolean contains(String[] list, String target) {
        if (list == null || list.length == 0) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(target)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String list, String target) {
        return StringArray.contains(StringArray.split(list), target);
    }

    private static int skipWhite(String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            if (StringArray.white(s.charAt(i))) continue;
            return i;
        }
        return s.length();
    }

    private static boolean white(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }
}

