/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.xml;

import com.sun.ant.taskdefs.xml.BaseProcessor;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.filter.ContentFilter;
import org.jdom.filter.Filter;

public class ReadProcessor
extends BaseProcessor {
    private StringBuffer buf = new StringBuffer();
    private boolean firstInsert;
    private String separator;

    public ReadProcessor() {
        this.mode = 3;
        this.separator = System.getProperty("PROPERTY_DELIMITER", "##");
        this.firstInsert = true;
    }

    private void addToBuf(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        if (this.firstInsert) {
            this.firstInsert = false;
        } else {
            this.buf.append(this.separator);
        }
        this.buf.append(str);
    }

    public void processElement(Element el) {
        List allTextNodes = el.getContent((Filter)new ContentFilter(5));
        int numNodes = allTextNodes == null ? 0 : allTextNodes.size();
        for (int i = 0; i < numNodes; ++i) {
            Object o = allTextNodes.get(i);
            if (o instanceof Text) {
                Text t = (Text)o;
                this.addToBuf(t.getTextNormalize());
                continue;
            }
            if (o instanceof Element) {
                Element e = (Element)o;
                this.processElement(e);
                continue;
            }
            this.project.log("JDOM filter failed in ReadProcessor.processElement()", 0);
        }
    }

    public void processAttrprocessTextibute(Attribute attr) {
        this.addToBuf(attr.getValue());
    }

    public void processText(Text text) {
        this.addToBuf(text.getTextNormalize());
    }

    public String getMessage() {
        return "Results loaded into property \"" + this.taskData.getProperty() + "\"";
    }

    public void fini() {
        this.project.setNewProperty(this.taskData.getProperty(), this.buf.toString());
    }
}

