/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface WebSocket {
    public static final int NORMAL_CLOSURE = 1000;

    public CompletableFuture<WebSocket> sendText(CharSequence var1, boolean var2);

    public CompletableFuture<WebSocket> sendBinary(ByteBuffer var1, boolean var2);

    public CompletableFuture<WebSocket> sendPing(ByteBuffer var1);

    public CompletableFuture<WebSocket> sendPong(ByteBuffer var1);

    public CompletableFuture<WebSocket> sendClose(int var1, String var2);

    public void request(long var1);

    public String getSubprotocol();

    public boolean isClosed();

    public void abort() throws IOException;

    public static enum MessagePart {
        FIRST,
        PART,
        LAST,
        WHOLE;

    }

    public static interface Listener {
        default public void onOpen(WebSocket webSocket) {
            webSocket.request(1L);
        }

        default public CompletionStage<?> onText(WebSocket webSocket, CharSequence charSequence, MessagePart messagePart) {
            webSocket.request(1L);
            return null;
        }

        default public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer byteBuffer, MessagePart messagePart) {
            webSocket.request(1L);
            return null;
        }

        default public CompletionStage<?> onPing(WebSocket webSocket, ByteBuffer byteBuffer) {
            webSocket.request(1L);
            return null;
        }

        default public CompletionStage<?> onPong(WebSocket webSocket, ByteBuffer byteBuffer) {
            webSocket.request(1L);
            return null;
        }

        default public CompletionStage<?> onClose(WebSocket webSocket, int n, String string) {
            return null;
        }

        default public void onError(WebSocket webSocket, Throwable throwable) {
        }
    }

    public static interface Builder {
        public Builder header(String var1, String var2);

        public Builder subprotocols(String var1, String ... var2);

        public Builder connectTimeout(Duration var1);

        public CompletableFuture<WebSocket> buildAsync();
    }
}

