/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.props;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.apache.tools.ant.PropertyHelper;

public abstract class DelegatingPropertyEvaluator
implements PropertyHelper.PropertyEvaluator {
    private final ThreadLocal stack = new ThreadLocal();
    private ArrayList delegates = new ArrayList();

    protected void addDelegate(PropertyHelper.PropertyEvaluator propertyEvaluator) {
        this.delegates.add(propertyEvaluator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(String propertyName, PropertyHelper propertyHelper) {
        if (this.getRequiredStack().contains(propertyName)) {
            return null;
        }
        this.push(propertyName);
        try {
            Iterator iter = this.delegates.iterator();
            while (iter.hasNext()) {
                Object value = ((PropertyHelper.PropertyEvaluator)iter.next()).evaluate(propertyName, propertyHelper);
                if (value == null) continue;
                Object object = value;
                return object;
            }
        }
        finally {
            this.pop();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DelegatingPropertyEvaluator)) {
            return false;
        }
        return this.delegates.equals(((DelegatingPropertyEvaluator)obj).delegates);
    }

    public int hashCode() {
        return 17 * this.delegates.hashCode();
    }

    private synchronized Stack getRequiredStack() {
        Stack result = (Stack)this.stack.get();
        if (result == null) {
            result = new Stack();
            this.stack.set(result);
        }
        return result;
    }

    private synchronized void push(String propertyName) {
        this.getRequiredStack().push(propertyName);
    }

    private synchronized void pop() {
        Stack stk = (Stack)this.stack.get();
        if (stk != null) {
            stk.pop();
            if (stk.isEmpty()) {
                this.stack.set(null);
            }
        }
    }
}

