/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.NonSerializable;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlElement
extends DomElement
implements Element {
    public static final String ATTRIBUTE_NOT_DEFINED = new String("");
    public static final String ATTRIBUTE_VALUE_EMPTY = new String("");
    public static final Short TAB_INDEX_OUT_OF_BOUNDS = new Short(Short.MIN_VALUE);
    private final transient Log mainLog_ = LogFactory.getLog(this.getClass());
    private Map<String, DomAttr> attributes_;
    private Map<String, String> namespaces_ = new HashMap<String, String>();
    private List<HtmlAttributeChangeListener> attributeListeners_;
    private HtmlForm owningForm_;

    protected HtmlElement(String namespaceURI, String qualifiedName, Page page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page);
        if (attributes != null) {
            this.attributes_ = attributes;
            for (DomAttr entry : this.attributes_.values()) {
                entry.setParentNode(this);
                String attrNamespaceURI = entry.getNamespaceURI();
                if (attrNamespaceURI == null) continue;
                this.namespaces_.put(attrNamespaceURI, entry.getPrefix());
            }
        } else {
            this.attributes_ = Collections.emptyMap();
        }
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlElement newNode = (HtmlElement)super.cloneNode(deep);
        newNode.attributes_ = HtmlElement.createAttributeMap(this.attributes_.size());
        for (DomAttr attr : this.attributes_.values()) {
            newNode.setAttributeValue(attr.getNamespaceURI(), attr.getQualifiedName(), attr.getNodeValue(), true);
        }
        return newNode;
    }

    @Override
    public final String getAttribute(String attributeName) {
        return this.getAttributeValue(attributeName);
    }

    private String getQualifiedName(String namespaceURI, String localName) {
        String prefix;
        String qualifiedName = namespaceURI != null ? ((prefix = this.namespaces_.get(namespaceURI)) != null ? prefix + ':' + localName : localName) : localName;
        return qualifiedName;
    }

    @Override
    public final String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeValue(this.getQualifiedName(namespaceURI, localName));
    }

    @Override
    public boolean hasAttributes() {
        return !this.attributes_.isEmpty();
    }

    @Override
    public final boolean hasAttribute(String attributeName) {
        return this.attributes_.get(attributeName) != null;
    }

    @Override
    public final boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.attributes_.get(this.getQualifiedName(namespaceURI, localName)) != null;
    }

    public final String getAttributeValue(String attributeName) {
        DomAttr attr = this.attributes_.get(attributeName.toLowerCase());
        if (attr != null) {
            return attr.getNodeValue();
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public final void setAttribute(String attributeName, String attributeValue) {
        this.setAttributeValue(null, attributeName, attributeValue);
    }

    @Override
    public final void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        this.setAttributeValue(namespaceURI, qualifiedName, attributeValue);
    }

    public final void setAttributeValue(String attributeName, String attributeValue) {
        this.setAttributeValue(null, attributeName, attributeValue);
    }

    public final void setAttributeValue(String namespaceURI, String qualifiedName, String attributeValue) {
        this.setAttributeValue(namespaceURI, qualifiedName, attributeValue, false);
    }

    protected void setAttributeValue(String namespaceURI, String qualifiedName, String attributeValue, boolean cloning) {
        String oldAttributeValue = this.getAttributeValue(qualifiedName);
        String value = attributeValue;
        if (this.attributes_ == Collections.EMPTY_MAP) {
            this.attributes_ = HtmlElement.createAttributeMap(1);
        }
        if (value.length() == 0) {
            value = ATTRIBUTE_VALUE_EMPTY;
        }
        if (this.getOwnerDocument() instanceof HtmlPage) {
            ((HtmlPage)this.getPage()).removeMappedElement(this);
        }
        DomAttr newAttr = HtmlElement.addAttributeToMap((Page)((Object)this.getOwnerDocument()), this.attributes_, namespaceURI, qualifiedName.toLowerCase(), value);
        if (namespaceURI != null) {
            this.namespaces_.put(namespaceURI, newAttr.getPrefix());
        }
        if (!(this.getOwnerDocument() instanceof HtmlPage)) {
            return;
        }
        ((HtmlPage)this.getPage()).addMappedElement(this);
        HtmlAttributeChangeEvent htmlEvent = oldAttributeValue == ATTRIBUTE_NOT_DEFINED ? new HtmlAttributeChangeEvent(this, qualifiedName, attributeValue) : new HtmlAttributeChangeEvent(this, qualifiedName, oldAttributeValue);
        if (oldAttributeValue == ATTRIBUTE_NOT_DEFINED) {
            this.fireHtmlAttributeAdded(htmlEvent);
            ((HtmlPage)this.getPage()).fireHtmlAttributeAdded(htmlEvent);
        } else {
            this.fireHtmlAttributeReplaced(htmlEvent);
            ((HtmlPage)this.getPage()).fireHtmlAttributeReplaced(htmlEvent);
        }
        if (this.getPage().getWebClient().getBrowserVersion().isIE()) {
            this.fireEvent(Event.createPropertyChangeEvent(this, qualifiedName));
        }
    }

    @Override
    public NodeList getElementsByTagName(String tagName) {
        return new DomNodeList(this, "//" + tagName);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespace, String name) {
        throw new UnsupportedOperationException("HtmlElement.getElementsByTagNameNS is not yet implemented.");
    }

    public final List<? extends HtmlElement> getHtmlElementsByTagNames(List<String> tagNames) {
        ArrayList<? extends HtmlElement> list = new ArrayList<HtmlElement>();
        for (String tagName : tagNames) {
            list.addAll(this.getHtmlElementsByTagName(tagName));
        }
        return list;
    }

    public final List<? extends HtmlElement> getHtmlElementsByTagName(String tagName) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        String lowerCaseTagName = tagName.toLowerCase();
        for (HtmlElement element : this.getAllHtmlChildElements()) {
            if (!lowerCaseTagName.equals(element.getTagName())) continue;
            list.add(element);
        }
        return list;
    }

    @Override
    public Attr setAttributeNodeNS(Attr attribute) {
        throw new UnsupportedOperationException("HtmlElement.setAttributeNodeNS is not yet implemented.");
    }

    @Override
    public Attr setAttributeNode(Attr attribute) {
        throw new UnsupportedOperationException("HtmlElement.setAttributeNode is not yet implemented.");
    }

    @Override
    public Attr removeAttributeNode(Attr attribute) {
        throw new UnsupportedOperationException("HtmlElement.removeAttributeNode is not yet implemented.");
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("HtmlElement.getAttributeNodeNS is not yet implemented.");
    }

    @Override
    public Attr getAttributeNode(String name) {
        throw new UnsupportedOperationException("HtmlElement.getAttributeNode is not yet implemented.");
    }

    @Override
    public final void removeAttribute(String attributeName) {
        String value = this.getAttributeValue(attributeName);
        ((HtmlPage)this.getPage()).removeMappedElement(this);
        this.attributes_.remove(attributeName.toLowerCase());
        ((HtmlPage)this.getPage()).addMappedElement(this);
        HtmlAttributeChangeEvent event = new HtmlAttributeChangeEvent(this, attributeName, value);
        this.fireHtmlAttributeRemoved(event);
        ((HtmlPage)this.getPage()).fireHtmlAttributeRemoved(event);
    }

    @Override
    public final void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(this.getQualifiedName(namespaceURI, localName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeAdded(HtmlAttributeChangeEvent event) {
        DomNode parentNode;
        if (this.attributeListeners_ != null) {
            HtmlElement htmlElement = this;
            synchronized (htmlElement) {
                for (HtmlAttributeChangeListener listener : this.attributeListeners_) {
                    listener.attributeAdded(event);
                }
            }
        }
        if ((parentNode = this.getParentNode()) instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeAdded(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeReplaced(HtmlAttributeChangeEvent event) {
        DomNode parentNode;
        if (this.attributeListeners_ != null) {
            HtmlElement htmlElement = this;
            synchronized (htmlElement) {
                for (HtmlAttributeChangeListener listener : this.attributeListeners_) {
                    listener.attributeReplaced(event);
                }
            }
        }
        if ((parentNode = this.getParentNode()) instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeReplaced(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeRemoved(HtmlAttributeChangeEvent event) {
        DomNode parentNode;
        if (this.attributeListeners_ != null) {
            HtmlElement htmlElement = this;
            synchronized (htmlElement) {
                for (HtmlAttributeChangeListener listener : this.attributeListeners_) {
                    listener.attributeRemoved(event);
                }
            }
        }
        if ((parentNode = this.getParentNode()) instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeRemoved(event);
        }
    }

    public boolean isAttributeDefined(String attributeName) {
        return this.attributes_.get(attributeName.toLowerCase()) != null;
    }

    @Deprecated
    public Iterator<DomAttr> getAttributeEntriesIterator() {
        return this.getAttributesCollection().iterator();
    }

    @Override
    public org.w3c.dom.NamedNodeMap getAttributes() {
        return new NamedNodeMap(this);
    }

    public Collection<DomAttr> getAttributesCollection() {
        return this.attributes_.values();
    }

    @Override
    public String getTagName() {
        if (this.getNamespaceURI() == null) {
            return this.getLocalName().toLowerCase();
        }
        return this.getQualifiedName();
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    public final String getId() {
        return this.getAttributeValue("id");
    }

    public final void setId(String newId) {
        this.setAttributeValue("id", newId);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("HtmlElement.getSchemaTypeInfo is not yet implemented.");
    }

    @Override
    public final void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new UnsupportedOperationException("HtmlElement.setIdAttribute is not yet implemented.");
    }

    @Override
    public final void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new UnsupportedOperationException("HtmlElement.setIdAttributeNS is not yet implemented.");
    }

    @Override
    public final void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new UnsupportedOperationException("HtmlElement.setIdAttributeNode is not yet implemented.");
    }

    public Short getTabIndex() {
        String index = this.getAttributeValue("tabindex");
        if (index == null || index.length() == 0) {
            return null;
        }
        try {
            long l = Long.parseLong(index);
            if (l >= 0L && l <= 32767L) {
                return new Short(new Long(l).shortValue());
            }
            return TAB_INDEX_OUT_OF_BOUNDS;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public HtmlElement getEnclosingElement(String tagName) {
        String tagNameLC = tagName.toLowerCase();
        for (DomNode currentNode = this.getParentNode(); currentNode != null; currentNode = currentNode.getParentNode()) {
            if (!(currentNode instanceof HtmlElement) || !currentNode.getNodeName().equals(tagNameLC)) continue;
            return (HtmlElement)currentNode;
        }
        return null;
    }

    public HtmlForm getEnclosingForm() {
        if (this.owningForm_ != null) {
            return this.owningForm_;
        }
        return (HtmlForm)this.getEnclosingElement("form");
    }

    public HtmlForm getEnclosingFormOrDie() throws IllegalStateException {
        HtmlForm form = this.getEnclosingForm();
        if (form == null) {
            throw new IllegalStateException("Element is not contained within a form: " + this);
        }
        return form;
    }

    public void type(String text) throws IOException {
        for (char ch : text.toCharArray()) {
            this.type(ch);
        }
    }

    public void type(String text, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        for (char ch : text.toCharArray()) {
            this.type(ch, shiftKey, ctrlKey, altKey);
        }
    }

    public Page type(char c) throws IOException {
        return this.type(c, false, false, false);
    }

    public Page type(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        this.focus();
        this.fireEvent(new Event(this, "keydown", c, shiftKey, ctrlKey, altKey));
        this.fireEvent(new Event(this, "keypress", c, shiftKey, ctrlKey, altKey));
        this.doType(c, shiftKey, ctrlKey, altKey);
        this.fireEvent(new Event(this, "keyup", c, shiftKey, ctrlKey, altKey));
        HtmlForm form = this.getEnclosingForm();
        if (form != null && c == '\n' && this.isSubmittableByEnter()) {
            return form.submit((SubmittableElement)((Object)this));
        }
        return this.getPage();
    }

    protected void doType(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
    }

    protected boolean isSubmittableByEnter() {
        return false;
    }

    @Override
    protected void printXml(String indent, PrintWriter printWriter) {
        boolean hasChildren = this.getFirstChild() != null;
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        if (!hasChildren && !this.isEmptyXmlTagExpanded()) {
            printWriter.println("/>");
        } else {
            printWriter.println(">");
            this.printChildrenAsXml(indent, printWriter);
            printWriter.println(indent + "</" + this.getTagName() + ">");
        }
    }

    protected boolean isEmptyXmlTagExpanded() {
        return false;
    }

    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        for (String name : this.attributes_.keySet()) {
            printWriter.print(" ");
            printWriter.print(name);
            printWriter.print("=\"");
            printWriter.print(StringEscapeUtils.escapeXml((String)this.attributes_.get(name).getNodeValue()));
            printWriter.print("\"");
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(ClassUtils.getShortClassName(this.getClass()));
        buffer.append("[<");
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        this.printOpeningTagContentAsXml(printWriter);
        buffer.append(writer.toString());
        buffer.append(">]");
        return buffer.toString();
    }

    public final HtmlElement getOneHtmlElementByAttribute(String elementName, String attributeName, String attributeValue) throws ElementNotFoundException {
        WebAssert.notNull("elementName", elementName);
        WebAssert.notNull("attributeName", attributeName);
        WebAssert.notNull("attributeValue", attributeValue);
        List<? extends HtmlElement> list = this.getHtmlElementsByAttribute(elementName, attributeName, attributeValue);
        int listSize = list.size();
        if (listSize == 0) {
            throw new ElementNotFoundException(elementName, attributeName, attributeValue);
        }
        return list.get(0);
    }

    public HtmlElement getHtmlElementById(String id) throws ElementNotFoundException {
        return ((HtmlPage)this.getPage()).getHtmlElementById(id);
    }

    public boolean hasHtmlElementWithId(String id) {
        try {
            this.getHtmlElementById(id);
            return true;
        }
        catch (ElementNotFoundException e) {
            return false;
        }
    }

    public final List<? extends HtmlElement> getHtmlElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        String lowerCaseTagName = elementName.toLowerCase();
        for (HtmlElement next : this.getAllHtmlChildElements()) {
            String attValue;
            if (!next.getTagName().equals(lowerCaseTagName) || (attValue = next.getAttributeValue(attributeName)) == null || !attValue.equals(attributeValue)) continue;
            list.add(next);
        }
        return list;
    }

    public final HtmlElement appendChildIfNoneExists(String tagName) {
        HtmlElement child;
        List<? extends HtmlElement> children = this.getHtmlElementsByTagName(tagName);
        if (children.isEmpty()) {
            child = ((HtmlPage)this.getPage()).createHtmlElement(tagName);
            this.appendChild(child);
        } else {
            child = children.get(0);
        }
        return child;
    }

    public final void removeChild(String tagName, int i) {
        List<? extends HtmlElement> children = this.getHtmlElementsByTagName(tagName);
        if (i >= 0 && i < children.size()) {
            HtmlElement child = children.get(i);
            child.remove();
        }
    }

    public final Iterable<HtmlElement> getChildElements() {
        return new Iterable<HtmlElement>(){

            @Override
            public Iterator<HtmlElement> iterator() {
                return new ChildElementsIterator();
            }
        };
    }

    @Deprecated
    public final Iterator<HtmlElement> getChildElementsIterator() {
        return new ChildElementsIterator();
    }

    static Map<String, DomAttr> createAttributeMap(int attributeCount) {
        return ListOrderedMap.decorate(new HashMap(attributeCount));
    }

    static DomAttr addAttributeToMap(Page page, Map<String, DomAttr> attributeMap, String namespaceURI, String qualifiedName, String value) {
        DomAttr newAttr = new DomAttr(page, namespaceURI, qualifiedName, value);
        attributeMap.put(qualifiedName, newAttr);
        return newAttr;
    }

    public final Function getEventHandler(String eventName) {
        HTMLElement jsObj = (HTMLElement)this.getScriptObject();
        return jsObj.getEventHandler(eventName);
    }

    public final void setEventHandler(String eventName, Function eventHandler) {
        HTMLElement jsObj = (HTMLElement)this.getScriptObject();
        jsObj.setEventHandler(eventName, eventHandler);
    }

    public final void setEventHandler(String eventName, String jsSnippet) {
        EventHandler function = new EventHandler(this, eventName, jsSnippet);
        this.setEventHandler(eventName, (Function)function);
        if (this.mainLog_.isDebugEnabled()) {
            this.mainLog_.debug((Object)("Created event handler " + function.getFunctionName() + " for " + eventName + " on " + this));
        }
    }

    public final void removeEventHandler(String eventName) {
        this.setEventHandler(eventName, (Function)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        HtmlElement htmlElement = this;
        synchronized (htmlElement) {
            if (this.attributeListeners_ == null) {
                this.attributeListeners_ = new ArrayList<HtmlAttributeChangeListener>();
            }
            this.attributeListeners_.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        HtmlElement htmlElement = this;
        synchronized (htmlElement) {
            if (this.attributeListeners_ != null) {
                this.attributeListeners_.remove(listener);
            }
        }
    }

    public ScriptResult fireEvent(String eventType) {
        return this.fireEvent(new Event(this, eventType));
    }

    public ScriptResult fireEvent(final Event event) {
        if (!this.getPage().getWebClient().isJavaScriptEnabled()) {
            return null;
        }
        if (this.mainLog_.isDebugEnabled()) {
            this.mainLog_.debug((Object)("Firing " + (Object)((Object)event)));
        }
        final HTMLElement jsElt = (HTMLElement)this.getScriptObject();
        ContextAction action = new ContextAction(){

            public Object run(Context cx) {
                return jsElt.fireEvent(event);
            }
        };
        ScriptResult result = (ScriptResult)ContextFactory.getGlobal().call(action);
        boolean isIE = this.getPage().getWebClient().getBrowserVersion().isIE();
        if (!isIE && event.isPreventDefault() || isIE && ScriptResult.isFalse(result)) {
            this.preventDefault();
        }
        return result;
    }

    protected void preventDefault() {
    }

    public Page mouseOver() {
        return this.mouseOver(false, false, false, 0);
    }

    public Page mouseOver(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseover", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseMove() {
        return this.mouseMove(false, false, false, 0);
    }

    public Page mouseMove(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mousemove", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseOut() {
        return this.mouseOut(false, false, false, 0);
    }

    public Page mouseOut(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseout", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseDown() {
        return this.mouseDown(false, false, false, 0);
    }

    public Page mouseDown(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mousedown", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseUp() {
        return this.mouseUp(false, false, false, 0);
    }

    public Page mouseUp(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseup", shiftKey, ctrlKey, altKey, button);
    }

    public Page rightClick() {
        return this.rightClick(false, false, false);
    }

    public Page rightClick(boolean shiftKey, boolean ctrlKey, boolean altKey) {
        Page mouseDownPage = this.mouseDown(shiftKey, ctrlKey, altKey, 2);
        if (mouseDownPage != this.getPage()) {
            if (this.mainLog_.isDebugEnabled()) {
                this.mainLog_.debug((Object)"rightClick() is incomplete, as mouseDown() loaded a different page.");
            }
            return mouseDownPage;
        }
        Page mouseUpPage = this.mouseUp(shiftKey, ctrlKey, altKey, 2);
        if (mouseUpPage != this.getPage()) {
            if (this.mainLog_.isDebugEnabled()) {
                this.mainLog_.debug((Object)"rightClick() is incomplete, as mouseUp() loaded a different page.");
            }
            return mouseUpPage;
        }
        return this.doMouseEvent("contextmenu", shiftKey, ctrlKey, altKey, 2);
    }

    private Page doMouseEvent(String eventType, boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        HtmlPage page = (HtmlPage)this.getPage();
        MouseEvent event = new MouseEvent((DomNode)this, eventType, shiftKey, ctrlKey, altKey, button);
        ScriptResult scriptResult = this.fireEvent(event);
        Page currentPage = scriptResult == null ? page : scriptResult.getNewPage();
        return currentPage;
    }

    public void blur() {
        ((HtmlPage)this.getPage()).setFocusedElement(null);
    }

    public void focus() {
        ((HtmlPage)this.getPage()).setFocusedElement(this);
        WebClient webClient = this.getPage().getWebClient();
        if (webClient.getBrowserVersion().isIE()) {
            HTMLElement jsElt = (HTMLElement)this.getScriptObject();
            jsElt.jsxFunction_setActive();
        }
    }

    @Override
    public SgmlPage getPage() {
        return (SgmlPage)super.getPage();
    }

    @Override
    protected void checkChildHierarchy(Node childNode) throws DOMException {
        if (!(childNode instanceof Element || childNode instanceof Text || childNode instanceof Comment || childNode instanceof ProcessingInstruction || childNode instanceof CDATASection || childNode instanceof EntityReference)) {
            throw new DOMException(3, "The Element may not have a child of this type: " + childNode.getNodeType());
        }
        super.checkChildHierarchy(childNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        HtmlElement htmlElement = this;
        synchronized (htmlElement) {
            ArrayList<HtmlAttributeChangeListener> temp;
            if (this.attributeListeners_ != null) {
                temp = new ArrayList<HtmlAttributeChangeListener>(this.attributeListeners_);
                Iterator<HtmlAttributeChangeListener> i = this.attributeListeners_.iterator();
                while (i.hasNext()) {
                    HtmlAttributeChangeListener listener = i.next();
                    if (!(listener instanceof NonSerializable)) continue;
                    i.remove();
                }
            } else {
                temp = null;
            }
            stream.defaultWriteObject();
            this.attributeListeners_ = temp;
        }
    }

    void setOwningForm(HtmlForm form) {
        this.owningForm_ = form;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChildElementsIterator
    implements Iterator<HtmlElement> {
        private HtmlElement nextElement_;

        public ChildElementsIterator() {
            if (HtmlElement.this.getFirstChild() != null) {
                if (HtmlElement.this.getFirstChild() instanceof HtmlElement) {
                    this.nextElement_ = (HtmlElement)HtmlElement.this.getFirstChild();
                } else {
                    this.setNextElement(HtmlElement.this.getFirstChild());
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextElement_ != null;
        }

        @Override
        public HtmlElement next() {
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (this.nextElement_ == null) {
                throw new IllegalStateException();
            }
            DomNode sibling = this.nextElement_.getPreviousSibling();
            if (sibling != null) {
                sibling.remove();
            }
        }

        public HtmlElement nextElement() {
            if (this.nextElement_ != null) {
                HtmlElement result = this.nextElement_;
                this.setNextElement(this.nextElement_);
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextElement(DomNode node) {
            DomNode next;
            for (next = node.getNextSibling(); next != null && !(next instanceof HtmlElement); next = next.getNextSibling()) {
            }
            this.nextElement_ = (HtmlElement)next;
        }
    }
}

