package com.sun.ts.tests.common.el.api.resolver;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import java.util.Iterator;

public class BarELResolver extends ELResolver
{

    public Object getValue(ELContext context, Object base, Object property)
        throws ELException
    {
        Object result = null;
        if(context == null) throw new NullPointerException();
        
        if(base == null) {
            // Resolving first variable (e.g. ${Bar}).  
            // We only handle "Bar"
            String propertyName = (String)property;
            if(propertyName.equals("Bar")) {
                result = "Foo";
                context.setPropertyResolved(true);
            }
        }
        return result;
    }

    public Class getType(ELContext context, Object base, Object property)
        throws ELException
    {
        if(context == null) throw new NullPointerException();

        if (base == null && property instanceof String && 
                property.toString().equals("Bar")) {
            context.setPropertyResolved(true);
        }
        
        // we never set a value
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, 

        Object value)
        throws ELException
    {   
        if(context == null) throw new NullPointerException();

        if (base == null && property instanceof String && 
                property.toString().equals("Bar")) {
            context.setPropertyResolved(true);
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, 
        Object property)
        throws ELException
    {
        if(context == null) throw new NullPointerException();

        if (base == null && property instanceof String && 
                property.toString().equals("Bar")) {
            context.setPropertyResolved(true);
        }

        return true;
    }

    public Iterator getFeatureDescriptors(ELContext context, Object base) {
        if(context == null) throw new NullPointerException();
        return null;
    }


    public Class getCommonPropertyType(ELContext context,
                                                Object base)
    {
        if(context == null) throw new NullPointerException();

        if (base == null) return String.class;
        return null;      
    }
}
