/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.SocketConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;

public class InterruptableSocketConnection
extends SocketConnection {
    public InterruptableSocketConnection(Socket socket) throws IOException {
        super(socket);
    }

    public InterruptableSocketConnection(String host, int port) throws IOException {
        super(host, port);
    }

    public InputStream getInputStream() {
        return new InterruptableInputStream();
    }

    class InterruptableInputStream
    extends InputStream {
        private boolean reading = false;
        private Object data;

        InterruptableInputStream() {
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b);
            if (n == -1) {
                return -1;
            }
            n = 0xFF & b[0];
            return n;
        }

        public int read(byte[] buffer, int offset, int count) throws IOException {
            if (count == 0) {
                return 0;
            }
            try {
                return new InterruptableReader().read(buffer, offset, count);
            }
            catch (InterruptedException ie) {
                InterruptedIOException iio = new InterruptedIOException("Interrupted while waiting for agent response");
                iio.fillInStackTrace();
                throw iio;
            }
        }

        public void close() throws IOException {
            InterruptableSocketConnection.this.socketInput.close();
        }

        private synchronized void waitWhileReading() throws InterruptedException {
            while (this.reading) {
                this.wait();
            }
        }

        static /* synthetic */ InterruptableSocketConnection access$300(InterruptableInputStream x0) {
            return x0.InterruptableSocketConnection.this;
        }

        class InterruptableReader {
            private IOException ioe;
            private int n;

            InterruptableReader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] buffer, int offset, int count) throws IOException, InterruptedException {
                InterruptableInputStream interruptableInputStream = InterruptableInputStream.this;
                synchronized (interruptableInputStream) {
                    this.ioe = null;
                    this.n = -1;
                    this.readInThread(buffer, offset, count);
                    InterruptableInputStream.this.waitWhileReading();
                    if (this.ioe != null) {
                        throw this.ioe;
                    }
                    return this.n;
                }
            }

            private void readInThread(byte[] buffer, int offset, int count) {
                byte[] b = buffer;
                int o = offset;
                int c = count;
                Thread reader = new Thread(this, b, o, c){
                    private final /* synthetic */ byte[] val$b;
                    private final /* synthetic */ int val$o;
                    private final /* synthetic */ int val$c;
                    private final /* synthetic */ InterruptableReader this$2;
                    {
                        this.this$2 = this$2;
                        this.val$b = val$b;
                        this.val$o = val$o;
                        this.val$c = val$c;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            try {
                                InterruptableReader.access$102(this.this$2, InterruptableInputStream.access$300((InterruptableInputStream)InterruptableReader.access$200((InterruptableReader)this.this$2)).socketInput.read(this.val$b, this.val$o, this.val$c));
                            }
                            catch (IOException io) {
                                InterruptableReader.access$402(this.this$2, io);
                                Object var3_2 = null;
                                InterruptableInputStream interruptableInputStream2 = InterruptableReader.access$200(this.this$2);
                                synchronized (interruptableInputStream2) {
                                    InterruptableInputStream.access$502(InterruptableReader.access$200(this.this$2), false);
                                    InterruptableReader.access$200(this.this$2).notifyAll();
                                    return;
                                }
                            }
                            Object var3_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            InterruptableInputStream interruptableInputStream = InterruptableReader.access$200(this.this$2);
                            synchronized (interruptableInputStream) {
                                InterruptableInputStream.access$502(InterruptableReader.access$200(this.this$2), false);
                                InterruptableReader.access$200(this.this$2).notifyAll();
                                throw throwable;
                            }
                        }
                        InterruptableInputStream interruptableInputStream = InterruptableReader.access$200(this.this$2);
                        synchronized (interruptableInputStream) {
                            InterruptableInputStream.access$502(InterruptableReader.access$200(this.this$2), false);
                            InterruptableReader.access$200(this.this$2).notifyAll();
                            return;
                        }
                    }
                };
                InterruptableInputStream.this.reading = true;
                reader.start();
            }

            static /* synthetic */ int access$102(InterruptableReader x0, int x1) {
                x0.n = x1;
                return x0.n;
            }

            static /* synthetic */ InterruptableInputStream access$200(InterruptableReader x0) {
                return x0.InterruptableInputStream.this;
            }

            static /* synthetic */ IOException access$402(InterruptableReader x0, IOException x1) {
                x0.ioe = x1;
                return x0.ioe;
            }
        }
    }
}

