/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.ModBase;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ModuleDescriptionLoader;
import com.sun.tdk.signaturetest.core.context.ModFeatures;
import com.sun.tdk.signaturetest.core.context.ModTestOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.model.ModuleDescription;
import com.sun.tdk.signaturetest.sigfile.MultipleFileReader;
import com.sun.tdk.signaturetest.sigfile.f43.F43Reader;
import com.sun.tdk.signaturetest.toyxml.Elem;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.io.File;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModTest
extends ModBase {
    private ModTestOptions mo = AppContext.getContext().getBean(ModTestOptions.class);
    private EnumSet<ModFeatures> checkers = EnumSet.of(ModFeatures.REQUIRES_TRANSITIVE, ModFeatures.EXPORTS_PUBLIC);

    public static void main(String[] args) {
        ModTest t = new ModTest();
        t.run(args, new PrintWriter(System.err, true), null);
        t.exit();
    }

    public boolean run(String[] args, PrintWriter pw, PrintWriter ref) {
        this.setLog(pw);
        if (this.parseParameters(args)) {
            Map<String, ModuleDescription> thisModel = this.filterModuleSet(this.createModel(), false, this.mo.isSet(Option.DEBUG));
            Map<String, ModuleDescription> fileModel = this.filterModuleSet(this.readFile(), true, this.mo.isSet(Option.DEBUG));
            this.passed();
            this.check(thisModel, fileModel);
            this.errorFormatter.out(pw);
            this.getLog().flush();
        } else if (args.length > 0 && Option.VERSION.accept(args[0])) {
            pw.println(Version.getVersionInfo());
        } else {
            this.usage();
        }
        if (this.errorFormatter.getNunErrors() == 0) {
            if (this.isPassed()) {
                return this.passed();
            }
            return false;
        }
        return this.failed(i18n.getString("MTest.msg.failed", Integer.toString(this.errorFormatter.getNunErrors())));
    }

    private boolean check(Map<String, ModuleDescription> thisModel, Map<String, ModuleDescription> thatModel) {
        boolean result = this.checkModuleList(thisModel, thatModel);
        for (String mN : thisModel.keySet()) {
            ModuleDescription thisModule = thisModel.get(mN);
            ModuleDescription thatModule = thatModel.get(mN);
            if (thatModule == null) continue;
            result &= this.checkVersion(thisModule, thatModule);
            result &= this.checkMainClass(thisModule, thatModule);
            result &= this.checkPackages(thisModule, thatModule);
            result &= this.checkExports(thisModule, thatModule);
            result &= this.checkRequires(thisModule, thatModule);
            result &= this.checkServices(thisModule, thatModule);
            result &= this.checkUses(thisModule, thatModule);
        }
        return result;
    }

    private boolean checkModuleList(Map<String, ModuleDescription> thisModel, Map<String, ModuleDescription> thatModel) {
        HashSet<String> onlyHere = new HashSet<String>(thisModel.keySet());
        onlyHere.removeAll(thatModel.keySet());
        HashSet<String> onlyThere = new HashSet<String>(thatModel.keySet());
        onlyThere.removeAll(thisModel.keySet());
        boolean result = true;
        for (String mName : onlyHere) {
            this.errorFormatter.addError(i18n.getString("MTest.error.module.extra"), mName);
            result = false;
        }
        for (String mName : onlyThere) {
            this.errorFormatter.addError(i18n.getString("MTest.error.module.not.found"), mName);
            result = false;
        }
        return result;
    }

    private boolean checkMainClass(ModuleDescription thisModule, ModuleDescription thatModule) {
        if (!this.supports(ModFeatures.MAIN_CLASS)) {
            return true;
        }
        if (!this.assertChecker(ModFeatures.MAIN_CLASS, thatModule)) {
            return false;
        }
        String s1 = thisModule.getMainClass();
        String s2 = thatModule.getMainClass();
        if (s1 == null ? s2 == null : s1.equals(s2)) {
            return true;
        }
        if (s1 == null || s1.isEmpty()) {
            s1 = "n/a";
        }
        if (s2 == null || s2.isEmpty()) {
            s2 = "n/a";
        }
        this.errorFormatter.addError(i18n.getString("MTest.error.main.class"), thatModule.getName(), s1, s2);
        return false;
    }

    private boolean checkVersion(ModuleDescription thisModule, ModuleDescription thatModule) {
        if (!this.supports(ModFeatures.VERSION)) {
            return true;
        }
        if (!this.assertChecker(ModFeatures.VERSION, thatModule)) {
            return false;
        }
        String s1 = thisModule.getVersion();
        String s2 = thatModule.getVersion();
        if (s1 == null ? s2 == null : s1.equals(s2)) {
            return true;
        }
        if (s1 == null || s1.isEmpty()) {
            s1 = "n/a";
        }
        if (s2 == null || s2.isEmpty()) {
            s2 = "n/a";
        }
        this.errorFormatter.addError(i18n.getString("MTest.error.version"), thatModule.getName(), s1, s2);
        return false;
    }

    private boolean checkPackages(ModuleDescription thisModule, ModuleDescription thatModule) {
        if (!this.supports(ModFeatures.PACKAGES)) {
            return true;
        }
        if (!this.assertChecker(ModFeatures.PACKAGES, thatModule)) {
            return false;
        }
        return this.compareStringSets(thisModule, thisModule.getPackages(), thatModule.getPackages(), "package");
    }

    private boolean checkExports(ModuleDescription thisModule, ModuleDescription thatModule) {
        boolean checkAll;
        if (!this.supports(ModFeatures.EXPORTS_PUBLIC) && !this.supports(ModFeatures.EXPORTS_ALL)) {
            return true;
        }
        boolean bl = checkAll = this.checkers.contains((Object)ModFeatures.EXPORTS_ALL) || this.checkers.contains((Object)ModFeatures.ALL);
        if (checkAll ? !this.assertChecker(ModFeatures.EXPORTS_ALL, thatModule) : !this.assertChecker(ModFeatures.EXPORTS_PUBLIC, thatModule)) {
            return false;
        }
        boolean retVal = true;
        Set<ModuleDescription.Exports> thisExports = thisModule.getExports();
        Set<ModuleDescription.Exports> thatExports = thatModule.getExports();
        for (ModuleDescription.Exports thisEx : thisExports) {
            ModuleDescription.Exports thatEx = null;
            if (!checkAll && !thisEx.targets.isEmpty()) continue;
            for (ModuleDescription.Exports t : thatExports) {
                if (!t.source.equals(thisEx.source)) continue;
                thatEx = t;
                break;
            }
            if (thatEx == null) {
                this.errorFormatter.addError(i18n.getString("MTest.error.export.not.found"), thisEx.source, thisModule.getName());
                continue;
            }
            if (thisEx.targets.equals(thatEx.targets)) continue;
            this.errorFormatter.addError(i18n.getString("MTest.error.export.targets"), thisEx.source, thisModule.getName(), thisEx.targets.toString(), thatEx.targets.toString());
        }
        for (ModuleDescription.Exports thatEx : thatExports) {
            ModuleDescription.Exports thisEx = null;
            if (!checkAll && !thatEx.targets.isEmpty()) continue;
            for (ModuleDescription.Exports t : thisExports) {
                if (!t.source.equals(thatEx.source)) continue;
                thisEx = t;
                break;
            }
            if (thisEx != null) continue;
            this.errorFormatter.addError(i18n.getString("MTest.error.export.missing"), thatEx.source, thatModule.getName());
        }
        return retVal;
    }

    private boolean checkRequires(ModuleDescription thisModule, ModuleDescription thatModule) {
        boolean checkAll;
        if (!this.supports(ModFeatures.REQUIRES_TRANSITIVE) && !this.supports(ModFeatures.REQUIRES_ALL)) {
            return true;
        }
        boolean bl = checkAll = this.checkers.contains((Object)ModFeatures.REQUIRES_ALL) || this.checkers.contains((Object)ModFeatures.ALL);
        if (checkAll ? !this.assertChecker(ModFeatures.REQUIRES_ALL, thatModule) : !this.assertChecker(ModFeatures.REQUIRES_TRANSITIVE, thatModule)) {
            return false;
        }
        HashSet<String> thisTransRequires = new HashSet<String>();
        for (ModuleDescription.Requires rq : thisModule.getRequires()) {
            if (!checkAll && !rq.modifiers.contains((Object)ModuleDescription.Requires.Modifier.TRANSITIVE)) continue;
            thisTransRequires.add(rq.getName());
        }
        HashSet<String> thatTransRequires = new HashSet<String>();
        for (ModuleDescription.Requires rq : thatModule.getRequires()) {
            if (!checkAll && !rq.modifiers.contains((Object)ModuleDescription.Requires.Modifier.TRANSITIVE)) continue;
            thatTransRequires.add(rq.getName());
        }
        return this.compareStringSets(thisModule, thisTransRequires, thatTransRequires, checkAll ? "requires" : "requires transitive");
    }

    private boolean checkServices(ModuleDescription thisModule, ModuleDescription thatModule) {
        if (!this.supports(ModFeatures.SERVICES)) {
            return true;
        }
        if (!this.assertChecker(ModFeatures.SERVICES, thatModule)) {
            return false;
        }
        Set<String> thisProvides = thisModule.getProvides().keySet();
        Set<String> thatProvides = thatModule.getProvides().keySet();
        return this.compareStringSets(thisModule, thisProvides, thatProvides, "service");
    }

    private boolean checkUses(ModuleDescription thisModule, ModuleDescription thatModule) {
        if (!this.supports(ModFeatures.USES)) {
            return true;
        }
        if (!this.assertChecker(ModFeatures.USES, thatModule)) {
            return false;
        }
        Set<String> thisUses = thisModule.getUses();
        Set<String> thatUses = thatModule.getUses();
        return this.compareStringSets(thisModule, thisUses, thatUses, "uses");
    }

    private boolean supports(ModFeatures checker) {
        return this.checkers.contains((Object)ModFeatures.ALL) || this.checkers.contains((Object)checker);
    }

    private boolean assertChecker(ModFeatures checker, ModuleDescription thatModule) {
        assert (checker != null);
        assert (thatModule.getFeatures() != null);
        if (!thatModule.getFeatures().contains((Object)ModFeatures.ALL) && !thatModule.getFeatures().contains((Object)checker)) {
            this.errorFormatter.addError(i18n.getString("MTest.checker.not.supported"), thatModule.getName(), checker.name());
            return false;
        }
        return true;
    }

    private boolean compareStringSets(ModuleDescription thisModule, Set<String> thisSet, Set<String> thatSet, String objName) {
        boolean retVal = true;
        if (!thisSet.equals(thatSet)) {
            HashSet<String> onlyHere = new HashSet<String>(thisSet);
            onlyHere.removeAll(thatSet);
            HashSet<String> onlyThere = new HashSet<String>(thatSet);
            onlyThere.removeAll(thisSet);
            for (String sName : onlyHere) {
                this.errorFormatter.addError(i18n.getString("MTest.error.extra.entity"), objName, sName, thisModule.getName());
                retVal = false;
            }
            for (String sName : onlyThere) {
                this.errorFormatter.addError(i18n.getString("MTest.error.missing.entity"), objName, sName, thisModule.getName());
                retVal = false;
            }
        }
        return retVal;
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        this.mo.readOptions(optionName, args);
    }

    private Map<String, ModuleDescription> readFile() {
        MultipleFileReader in = new MultipleFileReader(this.getLog(), 1, this.getFileManager());
        String testUrl = "";
        if (this.mo.getValue(Option.TEST_URL) != null) {
            testUrl = this.mo.getValue(Option.TEST_URL);
        }
        in.readSignatureFile(testUrl, this.mo.getValue(Option.FILE_NAME));
        HashMap<String, ModuleDescription> modules = new HashMap<String, ModuleDescription>();
        List<Elem> docs = in.getElements();
        if (docs != null) {
            for (Elem m : docs) {
                ModuleDescription md = F43Reader.fromTDom(m);
                modules.put(md.getName(), md);
            }
        }
        return modules;
    }

    private Map<String, ModuleDescription> createModel() {
        ModuleDescriptionLoader mdl = ModTest.getModuleLoader();
        Set<ModuleDescription> modules = mdl.loadBootModules();
        HashMap<String, ModuleDescription> model = new HashMap<String, ModuleDescription>();
        for (ModuleDescription md : modules) {
            model.put(md.getName(), md);
        }
        return model;
    }

    protected boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        if (args == null || args.length == 0 || args.length == 1 && Option.VERSION.accept(args[0])) {
            return false;
        }
        String optionsDecoder = "decodeOptions";
        parser.addOption("-Verbose", OptionInfo.optionVariableParams(0, 1), "decodeOptions");
        parser.addOptions(this.mo.getOptions(), "decodeOptions");
        try {
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            this.getLog().println(e.getMessage());
            return this.failed(e.getMessage());
        }
        if (!this.processHelpOptions()) {
            return false;
        }
        this.setupModulesAndPackages(this.mo);
        if (this.mo.getValue(Option.FILE_NAME) == null) {
            return this.error(i18n.getString("MTest.error.filename.missing"));
        }
        if (this.mo.getValue(Option.APIVERSION) != null) {
            this.apiVer = this.mo.getValue(Option.APIVERSION);
        }
        if (this.mo.getValue(Option.TEST_URL) != null && new File(this.mo.getValue(Option.FILE_NAME)).isAbsolute()) {
            return this.error(i18n.getString("MTest.error.testurl.absolutepath", new Object[]{Option.TEST_URL.getKey(), this.mo.getValue(Option.FILE_NAME)}));
        }
        return this.processCheckersList(this.mo);
    }

    private boolean processCheckersList(ModTestOptions mo) {
        try {
            this.checkers = ModFeatures.featureSetFromCommaList(mo.getValue(Option.CHECKS));
        }
        catch (IllegalArgumentException ex) {
            this.error(i18n.getString("MTest.error.wrongcheck", ex.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    protected void usage() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getComponentName() + " - " + i18n.getString("MTest.usage.version", "4.0"));
        sb.append(i18n.getString("MTest.usage"));
        System.err.println(sb.toString());
    }

    @Override
    protected String getComponentName() {
        return "Mod-Test";
    }
}

