/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.NewsAddress;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>parse()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *	Parse the given comma separated sequence of newsgroup into NewsAddress objects. <p>
 * api2test: public NewsAddress[] parse(String)  <p>
 *
 * how2test: Call API with string argument, verify returned object type to be
 *           NewsAddress[], if so then testcase passes, otherwise it fails.
 */

public class parse_Test extends MailTest {

    public static void main( String argv[] )
    {
        parse_Test test = new parse_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class NewsAddress: parse(String)\n");

        try {
	   // Construct a NewsAddress object
	      NewsAddress na = new NewsAddress();

	      if( na == null ) {
		  return Status.failed("Failed to create newsgroup object!");
	      }
	   // BEGIN UNIT TEST 1:
              out.println("UNIT TEST 1:  parse("+pattern+")");

	      NewsAddress[] nalist = na.parse(pattern); 	// API TEST
	      boolean ngFound = false;

	      for( int k = 0; k < nalist.length; k++ ) {
                   if( nalist[k] != null ) {
		       out.println("Newsgroup name is "+ nalist[k].getNewsgroup());
		       ngFound = true;
		   }
	      }
	      if( ngFound )
                  out.println("UNIT TEST 1: passed");
              else {
                    out.println("UNIT TEST 1: FAILED");
                    errors++;
              }
           // END UNIT TEST 1:
              checkStatus();

        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
