/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */
package com.sun.ts.tests.jaxrs.api.client.clientbuilder;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
public class JAXRSClient extends JAXRSCommonClient {

	private static final long serialVersionUID = 7395392827433641768L;

	/**
	 * Entry point for different-VM execution. It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}

	/* Run test */

	/*
	 * @testName: newClientNoParamTest
	 * @assertion_ids: JAXRS:JAVADOC:1019;
	 * @test_Strategy: Create new client instance using the default client 
	 * 					builder factory provided by the JAX-RS implementation 
	 * 					provider.
	 */
	public void newClientNoParamTest() throws Fault {
		Client client = ClientBuilder.newClient();
		assertFault(client != null, "could not create Client instance");
	}

	/*
	 * @testName: newClientWithConfigurationTest
	 * @assertion_ids: JAXRS:JAVADOC:1020;
	 * @test_Strategy: Create new configured client instance using the 
	 * 					default client builder factory provided by the JAX-RS 
	 * 					implementation provider.
	 */
	public void newClientWithConfigurationTest() throws Fault {
		String property = "JAXRSTCK";
		Client client = ClientBuilder.newClient();
		client.property(property, property);
		Configuration config = client.getConfiguration();
		client = ClientBuilder.newClient(config);
		assertNotNull(client, "could not create Client instance");
		assertEquals(property, client.getConfiguration().getProperty(property),
				"client does not contain given config");
	}

}
