/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.api.rs.core.configurable;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;

import com.sun.ts.lib.harness.EETest.Fault;

public abstract class Assertable {
	final static String[] LOCATION = { "Client", "WebTarget",
			"Invocation.Builder", "Invocation" };

	private int locationIndex = 0;

	public abstract void check1OnClient(Client client) throws Fault;

	public abstract void check2OnTarget(WebTarget target) throws Fault;

	public void incrementLocation() {
		locationIndex = (locationIndex + 1 == LOCATION.length) ? 0
				: locationIndex + 1;
	}

	public String getLocation() {
		return new StringBuilder().append("on ")
				.append(LOCATION[locationIndex]).append(" configuration")
				.toString();
	}
	
	public static String getLocation(int index){
		return LOCATION[index];
	}

	public int getLocationIndex() {
		return locationIndex;
	}

}
